/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutionContext {
    public static final String APPLICATION_NAME = "jeus.app.name";
    public static final String ENC_JNDI_PREFIX = "jeus.jndi.enc.prefix";
    public static final String LOGGER = "jeus.logger";
    public static final String CONTEXT_LOADER = "jeus.contextloader";
    public static final String JNDI_PROPERTIES_KEY = "JNDI_PROPERTIES";
    public static final String WEB_CONTEXT = "WEB_CONTEXT";
    protected static ExecutionContextThreadLocal executionContextStack = new ExecutionContextThreadLocal();
    protected Map context;
    protected ClassLoader previousLoader;

    public ExecutionContext() {
        this.context = new HashMap();
    }

    public ExecutionContext(Map context) {
        this.context = context;
    }

    public static ExecutionContext pop() {
        List list = (List)executionContextStack.get();
        if (list.size() == 0) {
            throw new IllegalStateException("Internal error: no more execution context to pop");
        }
        ExecutionContext context = (ExecutionContext)list.remove(list.size() - 1);
        if (context.previousLoader != null) {
            Thread currentThread = Thread.currentThread();
            currentThread.setContextClassLoader(context.previousLoader);
            context.previousLoader = null;
        }
        return context;
    }

    public static Object getFromContextStacks(String key) {
        List list = (List)executionContextStack.get();
        for (int i = list.size() - 1; i >= 0; --i) {
            ExecutionContext context = (ExecutionContext)list.get(i);
            Object obj = context.get(key);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static ExecutionContext getExecutionContext() {
        ExecutionContext ec;
        List list = (List)executionContextStack.get();
        if (list.size() == 0) {
            ec = new ExecutionContext();
            ExecutionContext.push(ec);
        } else {
            ec = (ExecutionContext)list.get(list.size() - 1);
        }
        return ec;
    }

    public boolean containsKey(String key) {
        return this.context.containsKey(key);
    }

    public Object get(String key) {
        Object obj = this.context.get(key);
        if (obj instanceof StackableValue) {
            StackableValue value = (StackableValue)obj;
            return value.get(value.size() - 1);
        }
        return obj;
    }

    public static void push(ExecutionContext context) {
        ((List)executionContextStack.get()).add(context);
        if (context.containsKey(CONTEXT_LOADER)) {
            Thread currentThread = Thread.currentThread();
            context.previousLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader((ClassLoader)context.get(CONTEXT_LOADER));
        }
    }

    public static void push(Map context) {
        ExecutionContext.push(new ExecutionContext(context));
    }

    public String getENCJndiPrefix() {
        String prefix = (String)this.context.get(ENC_JNDI_PREFIX);
        return prefix == null ? "" : prefix;
    }

    public String getAppName() {
        return (String)this.context.get(APPLICATION_NAME);
    }

    public void setName(String name) {
        this.context.put(ENC_JNDI_PREFIX, name);
    }

    public String getName() {
        String prefix = (String)this.context.get(ENC_JNDI_PREFIX);
        return prefix == null ? "" : prefix;
    }

    public void put(String key, Object value) {
        this.context.put(key, value);
    }

    public void pushStackableValue(String key, Object value) {
        StackableValue stackValue = (StackableValue)this.context.get(key);
        if (stackValue == null) {
            stackValue = new StackableValue();
            this.context.put(key, stackValue);
        }
        stackValue.add(value);
    }

    public Object popStackableValue(String key) {
        StackableValue stackValue = (StackableValue)this.context.get(key);
        if (stackValue != null) {
            if (stackValue.size() == 1) {
                this.context.remove(key);
            }
            return stackValue.remove(stackValue.size() - 1);
        }
        return null;
    }

    public Object peekStackableValue(String key) {
        StackableValue stackValue = (StackableValue)this.context.get(key);
        if (stackValue != null) {
            return stackValue.get(stackValue.size() - 1);
        }
        return null;
    }

    static class StackableValue
    extends ArrayList {
        StackableValue() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExecutionContextThreadLocal
    extends InheritableThreadLocal<List<ExecutionContext>> {
        ExecutionContextThreadLocal() {
        }

        @Override
        protected List<ExecutionContext> initialValue() {
            return new ArrayList<ExecutionContext>();
        }

        @Override
        protected List<ExecutionContext> childValue(List<ExecutionContext> parentValue) {
            ArrayList<ExecutionContext> stack = new ArrayList<ExecutionContext>();
            ExecutionContext newExecutionContext = new ExecutionContext();
            if (parentValue.size() > 0) {
                ExecutionContext parentExecutionContext = parentValue.get(parentValue.size() - 1);
                newExecutionContext.put(ExecutionContext.APPLICATION_NAME, parentExecutionContext.getAppName());
                newExecutionContext.put(ExecutionContext.ENC_JNDI_PREFIX, parentExecutionContext.getENCJndiPrefix());
                stack.add(newExecutionContext);
            }
            return stack;
        }
    }
}

