/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import jeus.util.JeusPort;
import jeus.util.VirtualDNS;
import jeus.util.net.IPAddressFormat;

public class HostInfo {
    private final String hostname;
    private final int port;
    private final boolean isIPv6LiteralAddress;

    public HostInfo(String hostname) {
        this(hostname, JeusPort.JeusBase);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HostInfo(String hostname, int port) {
        if (hostname == null) {
            throw new IllegalArgumentException("Invalid host " + hostname);
        }
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
        if (hostname.startsWith("[")) {
            if (!hostname.endsWith("]")) throw new IllegalArgumentException("Invalid ipv6 expression " + hostname);
            this.hostname = hostname.substring(1, hostname.length() - 1);
            this.isIPv6LiteralAddress = IPAddressFormat.isIPv6LiteralAddress(this.hostname);
            if (!this.isIPv6LiteralAddress) {
                throw new IllegalArgumentException("Invalid ipv6 expression " + hostname);
            }
        } else {
            this.hostname = hostname;
            this.isIPv6LiteralAddress = IPAddressFormat.isIPv6LiteralAddress(this.hostname);
        }
        this.port = port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String composeServerAddress() {
        if (this.isIPv6LiteralAddress) {
            return "[" + this.hostname + "]:" + this.port;
        }
        return this.hostname + ":" + this.port;
    }

    public String getQualifiedHostName() {
        if (this.isIPv6LiteralAddress) {
            return "[" + this.hostname + "]";
        }
        return this.hostname;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.port;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostInfo other = (HostInfo)obj;
        if (this.port != other.port) {
            return false;
        }
        return !(this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname));
    }

    public String toString() {
        if (this.port != 0) {
            return this.hostname + ":" + this.port;
        }
        return this.hostname;
    }

    public static String composeServerAddress(String hostname, int port) {
        return new HostInfo(hostname, port).composeServerAddress();
    }

    public static String fromServerAddress(String hostAndPort) {
        HostInfo hostInfo = HostInfo.fromServerAddressToHostInfo(hostAndPort);
        return hostInfo.composeServerAddress();
    }

    public static String fromServerAddress(String hostAndPort, int defaultPort) {
        HostInfo hostInfo = HostInfo.fromServerAddressToHostInfo(hostAndPort, defaultPort);
        return hostInfo.composeServerAddress();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HostInfo fromServerAddressToHostInfo(String hostAndPort, int defaultPort) {
        int port;
        String host;
        if (hostAndPort.startsWith("[")) {
            if (!hostAndPort.contains("]")) throw new IllegalArgumentException("Invalid ipv6 expression");
            int index = hostAndPort.lastIndexOf("]");
            if (!IPAddressFormat.isIPv6LiteralAddress(hostAndPort.substring(1, index))) {
                throw new IllegalArgumentException("Invalid ipv6 expression");
            }
            host = hostAndPort.substring(1, index);
            port = hostAndPort.indexOf(":", index + 1) >= 0 ? Integer.parseInt(hostAndPort.substring(hostAndPort.lastIndexOf(":") + 1)) : defaultPort;
            return new HostInfo(host, port);
        } else if (IPAddressFormat.isIPv6LiteralAddress(hostAndPort)) {
            host = hostAndPort;
            port = defaultPort;
            return new HostInfo(host, port);
        } else if (IPAddressFormat.isIPv4LiteralAddress(hostAndPort)) {
            host = hostAndPort;
            port = defaultPort;
            return new HostInfo(host, port);
        } else {
            int index = hostAndPort.lastIndexOf(":");
            if (index > 0) {
                host = hostAndPort.substring(0, index);
                if (IPAddressFormat.isIPv6LiteralAddress(host) || host.contains(":")) {
                    throw new IllegalArgumentException("Invalid ipv6 expression " + hostAndPort);
                }
                port = Integer.parseInt(hostAndPort.substring(index + 1));
                return new HostInfo(host, port);
            } else {
                host = VirtualDNS.getRealNodeName(hostAndPort, defaultPort);
                index = host.lastIndexOf(":");
                if (index > 0) {
                    port = Integer.parseInt(host.substring(index + 1));
                    host = host.substring(0, index);
                    return new HostInfo(host, port);
                } else {
                    port = defaultPort;
                }
            }
        }
        return new HostInfo(host, port);
    }

    public static HostInfo fromServerAddressToHostInfo(String hostAndPort) {
        return HostInfo.fromServerAddressToHostInfo(hostAndPort, JeusPort.JeusBase);
    }
}

