/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.BinaryRefAddr;
import javax.naming.LinkRef;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import jeus.jndi.JNSContext;
import jeus.jndi.JNSContextFactory;
import jeus.jndi.jns.common.DynamicLinkRef;
import jeus.jndi.jns.common.JeusNameClassPair;
import jeus.jndi.objectfactory.ReferenceRefAddr;
import jeus.jndi.objectfactory.SerializableRefAddr;
import jeus.util.StringUtil;
import jeus.util.logging.Utility;

public class JNDIUtil {
    public static String getJndiInfo(String jndiName, String providerUrl) throws NamingException {
        JNSContext context = JNDIUtil.getJNSContext(providerUrl);
        Object obj = context.lookupRawObject(jndiName);
        if (obj == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int level = 0;
        StringUtil.writeStringBuffer(buffer, level++, "Class for the name " + jndiName + " in the server " + providerUrl + " : " + obj.getClass().getName());
        if (obj instanceof LinkRef) {
            StringUtil.writeStringBuffer(buffer, level, "LinkRef linkname : " + ((LinkRef)obj).getLinkName());
        } else if (obj instanceof DynamicLinkRef) {
            StringUtil.writeStringBuffer(buffer, level, "DynamicLinkRef links : ");
            DynamicLinkRef dynamicLinkRef = (DynamicLinkRef)obj;
            Vector links = dynamicLinkRef.getLinks();
            int linkLevel = level + 1;
            for (int i = 0; i < links.size(); ++i) {
                String s = (String)links.elementAt(i);
                StringUtil.writeStringBuffer(buffer, linkLevel, "[" + i + "] : " + s);
            }
        } else if (obj instanceof Reference) {
            JNDIUtil.writeReferenceInfo(buffer, level, (Reference)obj);
        } else {
            StringUtil.writeStringBuffer(buffer, level, "object : " + obj);
        }
        return buffer.toString();
    }

    private static JNSContext getJNSContext(String providerUrl) throws NamingException {
        Hashtable<String, String> t = new Hashtable<String, String>();
        if (providerUrl != null) {
            t.put("java.naming.provider.url", providerUrl);
        }
        return (JNSContext)JNSContextFactory.getInternalInitialContext(t);
    }

    private static void writeReferenceInfo(StringBuffer buffer, int level, Reference ref) {
        StringUtil.writeStringBuffer(buffer, level, "Reference class name : " + ref.getClassName());
        StringUtil.writeStringBuffer(buffer, level, "Reference Factory class name : " + ref.getFactoryClassName());
        ++level;
        Enumeration<RefAddr> e = ref.getAll();
        int index = 0;
        while (e.hasMoreElements()) {
            RefAddr refAddr = e.nextElement();
            if (refAddr instanceof StringRefAddr) {
                StringUtil.writeStringBuffer(buffer, level, "[" + index + "] StringRefAddr : " + refAddr.getContent());
            } else if (refAddr instanceof BinaryRefAddr) {
                StringUtil.writeStringBuffer(buffer, level, "[" + index + "] BinaryRefAddr : " + Utility.getDump((byte[])refAddr.getContent()));
            } else if (refAddr instanceof ReferenceRefAddr) {
                StringUtil.writeStringBuffer(buffer, level, "[" + index + "] ReferenceRefAddr : ");
                Reference refInAddr = (Reference)refAddr.getContent();
                if (refInAddr != null) {
                    JNDIUtil.writeReferenceInfo(buffer, level + 1, refInAddr);
                } else {
                    StringUtil.writeStringBuffer(buffer, level + 1, "null Reference");
                }
            } else if (refAddr instanceof SerializableRefAddr) {
                StringUtil.writeStringBuffer(buffer, level, "[" + index + "] SerializableRefAddr : " + refAddr.getContent());
            } else {
                StringUtil.writeStringBuffer(buffer, level, "[" + index + "] RefAddr type : " + refAddr.getType() + ", content : " + refAddr.getContent());
            }
            ++index;
        }
        StringUtil.writeStringBuffer(buffer, level, "end of RefAddr");
    }

    public static String getJndiListInfo(String jndiName, String providerUrl, boolean allInfos) throws NamingException {
        JNSContext context = JNDIUtil.getJNSContext(providerUrl);
        NamingEnumeration e = context.list(jndiName);
        NameClassComparator nameComparator = new NameClassComparator();
        ArrayList<JeusNameClassPair> nameClassPairList = new ArrayList<JeusNameClassPair>();
        while (e.hasMoreElements()) {
            JeusNameClassPair pair = (JeusNameClassPair)e.nextElement();
            nameClassPairList.add(pair);
        }
        Collections.sort(nameClassPairList, nameComparator);
        StringBuffer buffer = new StringBuffer();
        StringUtil.writeStringBuffer(buffer, 0, "List of the context /" + jndiName);
        for (JeusNameClassPair pair : nameClassPairList) {
            StringUtil.writeStringBuffer(buffer, 1, "name : " + pair.getName() + ", class : " + pair.getClassName());
            if (!allInfos) continue;
            StringUtil.writeStringBuffer(buffer, 1, "Is local binding? : " + pair.isLocalBinding());
            Reference reference = pair.getReference();
            if (reference != null) {
                JNDIUtil.writeReferenceInfo(buffer, 1, reference);
            }
            StringUtil.writeStringBuffer(buffer, 0, "");
        }
        StringUtil.writeStringBuffer(buffer, 1, "end of list");
        return buffer.toString();
    }

    public static NamingException makeNamingException(Throwable e) {
        if (e instanceof NamingException) {
            return (NamingException)e;
        }
        NamingException ne = new NamingException(e.toString());
        ne.setRootCause(e);
        return ne;
    }

    public static final class NameClassComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return ((NameClassPair)o1).getName().compareToIgnoreCase(((NameClassPair)o2).getName());
        }
    }
}

