/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import jeus.internal.message.MessageBundlesFactory;
import jeus.util.JeusLocalizedException;

public class JeusException
extends RemoteException
implements JeusLocalizedException {
    private static final long serialVersionUID = Boolean.valueOf(System.getProperty("jeus.util.JeusException.useOldSerialVersionUID")) != false ? -5561136766330531963L : -5804718591607261768L;
    private transient int msgID = -1;
    private transient Object[] args;
    private Throwable t;

    public JeusException() {
    }

    public JeusException(String s) {
        this(s, null);
    }

    public JeusException(Throwable t) {
        this(null, t);
    }

    public JeusException(int msgID) {
        this(msgID, null, null);
    }

    public JeusException(int msgID, Throwable t) {
        this(msgID, null, t);
    }

    public JeusException(int msgID, Object arg) {
        this(msgID, arg, null);
    }

    public JeusException(int msgID, Object[] args) {
        this(msgID, args, (Throwable)null);
    }

    public JeusException(int msgID, Object arg, Throwable t) {
        this(MessageBundlesFactory.getInstance().getMessageString(msgID, arg), t);
        this.msgID = msgID;
        if (arg != null) {
            this.args = new Object[]{arg};
        }
    }

    public JeusException(int msgID, Object[] args, Throwable t) {
        this(MessageBundlesFactory.getInstance().getMessageString(msgID, args), t);
        this.msgID = msgID;
        this.args = args;
    }

    public JeusException(String s, Throwable t) {
        super(s);
        this.t = t;
    }

    public int getMessageNumber() {
        return this.msgID;
    }

    public Object getParameter() {
        if (this.args != null && this.args.length == 1) {
            return this.args[0].toString();
        }
        return null;
    }

    public Object[] getParameters() {
        return this.args;
    }

    public Throwable getCause() {
        return this.t;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.msgID == 0) {
            this.msgID = -1;
        }
    }
}

