/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import jeus.util.HashMap;
import jeus.util.RefinedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedHashMap<K, V>
extends HashMap<K, V>
implements RefinedHashMap<K, V> {
    protected transient Entry<K, V> header;
    private final boolean accessOrder;

    public LinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map<? extends K, ? extends V> m) {
        super(m);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    @Override
    void init() {
        this.header = new Entry<Object, Object>(-1, null, null, null);
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    void transfer(HashMap.Entry[] newTable) {
        int newCapacity = newTable.length;
        Entry e = this.header.after;
        while (e != this.header) {
            int index = HashMap.indexFor(e.hash, newCapacity);
            e.next = newTable[index];
            newTable[index] = e;
            e = e.after;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            Entry e = this.header.after;
            while (e != this.header) {
                if (e.value == null) {
                    return true;
                }
                e = e.after;
            }
        } else {
            Entry e = this.header.after;
            while (e != this.header) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.after;
            }
        }
        return false;
    }

    public Object peekEldest() {
        Entry first = this.header.after;
        return first == this.header ? null : first.getKey();
    }

    @Override
    public V recover(K key, V value) {
        return this.putAsEldest(key, value);
    }

    public void recover(LinkedHashMap<K, V> t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int capacity;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (capacity = this.table.length; capacity < n; capacity <<= 1) {
            }
            this.resize(capacity);
        }
        Entry e = t.header.before;
        while (e != t.header) {
            this.putAsEldest(e.getKey(), e.getValue());
            e = e.before;
        }
    }

    protected V putAsEldest(K key, V value) {
        if (key == null) {
            return this.putForNullKey(value);
        }
        int hash = HashMap.hash(key.hashCode());
        int i = HashMap.indexFor(hash, this.table.length);
        HashMap.Entry<K, V> e = this.table[i];
        while (e != null) {
            if (e.hash == hash && HashMap.eq(key, e.key)) {
                Object oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.table[i] = e = new Entry<K, V>(hash, key, value, this.table[i]);
        ((Entry)e).addAfter(this.header);
        ++this.size;
        if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return null;
    }

    @Override
    public HashMap.Entry<K, V> getEntry(Object key) {
        return super.getEntry(key);
    }

    Entry<K, V> getEntry(int nth) {
        boolean forward = true;
        if (nth > this.size - 1) {
            return this.header.after;
        }
        if (nth >= this.size / 2) {
            nth = this.size - nth - 1;
            forward = false;
        }
        Entry entry = forward ? this.header.after : this.header.before;
        for (int i = 0; i < nth; ++i) {
            entry = forward ? entry.after : entry.before;
        }
        return entry == this.header ? null : entry;
    }

    public K getKey(int nth) {
        Entry<K, V> entry = this.getEntry(nth);
        return entry == null ? null : (K)entry.getKey();
    }

    public V getValue(int index) {
        Entry<K, V> entry = this.getEntry(index);
        return entry == null ? null : (V)entry.getValue();
    }

    @Override
    public V get(Object key) {
        Entry e = (Entry)this.getEntry(key);
        if (e == null) {
            return null;
        }
        e.recordAccess(this);
        return (V)e.value;
    }

    public V removeYoungestValue() {
        Entry first = this.header.before;
        if (first != this.header) {
            return this.remove(first.key);
        }
        return null;
    }

    @Override
    public V removeEldestValue() {
        Entry first = this.header.after;
        if (first != this.header) {
            return this.remove(first.key);
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.header.after = this.header;
        this.header.before = this.header.after;
    }

    @Override
    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    @Override
    Iterator<V> newValueIterator() {
        return new ValueIterator();
    }

    @Override
    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    void addEntry(int hash, K key, V value, int bucketIndex) {
        this.createEntry(hash, key, value, bucketIndex);
        Entry eldest = this.header.after;
        if (this.removeEldestEntry(eldest)) {
            this.removeEntryForKey(eldest.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void addEntryPrevOf(Entry<K, V> next, int hash, K key, V value, int bucketIndex) {
        this.createEntryPrev(next, hash, key, value, bucketIndex);
        if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void addEntryNextOf(Entry<K, V> prev, int hash, K key, V value, int bucketIndex) {
        this.createEntryNext(prev, hash, key, value, bucketIndex);
        if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    @Override
    void createEntry(int hash, K key, V value, int bucketIndex) {
        Entry<K, V> e;
        this.table[bucketIndex] = e = new Entry<K, V>(hash, key, value, this.table[bucketIndex]);
        e.addBefore(this.header);
        ++this.size;
    }

    void createEntryPrev(Entry<K, V> next, int hash, K key, V value, int bucketIndex) {
        Entry<K, V> e;
        this.table[bucketIndex] = e = new Entry<K, V>(hash, key, value, this.table[bucketIndex]);
        e.addBefore(next);
        ++this.size;
    }

    void createEntryNext(Entry<K, V> prev, int hash, K key, V value, int bucketIndex) {
        Entry<K, V> e;
        this.table[bucketIndex] = e = new Entry<K, V>(hash, key, value, this.table[bucketIndex]);
        e.addAfter(prev);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return false;
    }

    @Override
    public Iterator getCirculatedTwoWayValueIterator(Object key, boolean forward) {
        if (key == null || !this.containsKey(key)) {
            return new ValueIterator();
        }
        Entry entry = (Entry)this.getEntry(key);
        return new CirculatedTwoWayValueIterator(entry, forward);
    }

    private class CirculatedTwoWayValueIterator
    extends LinkedHashIterator {
        private Entry start;
        private boolean forward;

        CirculatedTwoWayValueIterator(Entry start, boolean forward) {
            this.start = start;
            this.forward = forward;
            this.nextEntry = forward ? start.after : start.before;
        }

        public boolean hasNext() {
            return this.lastReturned != this.start;
        }

        public Entry nextEntry() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastReturned == this.start) {
                throw new NoSuchElementException();
            }
            Entry e = this.lastReturned = this.nextEntry;
            Entry entry = this.nextEntry = this.forward ? e.after : e.before;
            if (e == LinkedHashMap.this.header) {
                return this.nextEntry();
            }
            return e;
        }

        public Object next() {
            return this.nextEntry().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends LinkedHashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends LinkedHashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends LinkedHashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LinkedHashIterator<T>
    implements Iterator<T> {
        Entry<K, V> nextEntry;
        Entry<K, V> lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = LinkedHashMap.this.header.after;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != LinkedHashMap.this.header;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        Entry<K, V> nextEntry() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == LinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            Entry e = this.lastReturned;
            this.nextEntry = e.after;
            return e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<K, V>
    extends HashMap.Entry<K, V> {
        Entry<K, V> before;
        Entry<K, V> after;

        Entry(int hash, K key, V value, HashMap.Entry<K, V> next) {
            super(hash, key, value, next);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        protected void addBefore(Entry<K, V> existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        protected void addAfter(Entry<K, V> existingEntry) {
            this.after = existingEntry.after;
            this.before = existingEntry;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        void recordAccess(HashMap<K, V> m) {
            LinkedHashMap lm = (LinkedHashMap)m;
            if (lm.accessOrder) {
                ++lm.modCount;
                this.remove();
                this.addBefore(lm.header);
            }
        }

        @Override
        void recordRemoval(HashMap<K, V> m) {
            this.remove();
        }
    }
}

