/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import jeus.util.SimpleDeque;
import jeus.util.Sortable;
import jeus.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleSortedViewDeque<E>
extends SimpleDeque<E> {
    private final Map<Sortable, SortedView<E>> viewMap = new HashMap<Sortable, SortedView<E>>();
    private final Map<Sortable, SoftReference<SortedView<E>>> viewCache = new HashMap<Sortable, SoftReference<SortedView<E>>>();
    public static final Sortable ANONYMOUS_SORTABLE = new Sortable(){

        public Comparable getIndex(Object obj) {
            return null;
        }

        public boolean accept(Object obj) {
            return false;
        }

        public boolean isAscending() {
            return false;
        }

        public String getType() {
            return null;
        }
    };

    public void enqueueLast(Sortable sortable, E element) {
        SoftReference<SortedView<E>> reference;
        SortedView<E> view = this.viewMap.get(sortable);
        if (view == null && (reference = this.viewCache.remove(sortable)) != null) {
            view = reference.get();
            if (sortable.accept(element)) {
                this.viewMap.put(sortable, view);
            }
        }
        if (view != null && ((SortedView)view).sortable.accept(element)) {
            SimpleDeque.Entry position = ((SortedView)view).getPosition(element);
            ViewEntry entry = (ViewEntry)this.addBefore(element, position == null ? this.header : position);
            ((SortedView)view).add(entry);
        } else if (view == null && sortable.accept(element)) {
            SortedView newView = new SortedView(sortable);
            this.viewMap.put(sortable, newView);
            SimpleDeque.Entry position = newView.getPosition(element);
            ViewEntry entry = (ViewEntry)this.addBefore(element, position == null ? this.header : position);
            newView.add(entry);
        } else {
            this.add(element);
        }
    }

    private void removeEmptyView() {
        for (SortedView<E> view : this.viewMap.values()) {
            if (((SortedView)view).buckets.size() != 0) continue;
            this.viewMap.remove(((SortedView)view).sortable);
            this.viewCache.put(((SortedView)view).sortable, new SoftReference<SortedView<E>>(view));
        }
    }

    @Override
    protected SimpleDeque.Entry<E> createEntry(E e) {
        return new ViewEntry(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.size() == 0) {
            return false;
        }
        for (E element : c) {
            this.add(element);
        }
        return true;
    }

    @Override
    public void clear() {
        for (SortedView<E> view : this.viewMap.values()) {
            ((SortedView)view).clear();
        }
        this.viewMap.clear();
        super.clear();
    }

    @Override
    protected E remove(SimpleDeque.Entry<E> entry) {
        if (entry == this.header) {
            throw new NoSuchElementException();
        }
        Object result = entry.element;
        entry.remove();
        --this.size;
        ++this.modCount;
        this.removeEmptyView();
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MultipleSortedViewDeque - whole list = { ");
        for (Object e : this) {
            buffer.append(e);
            buffer.append(", ");
        }
        if (this.size != 0) {
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append(" },");
        buffer.append("\nview list = {\n");
        for (SortedView sortedView : this.viewMap.values()) {
            buffer.append("\t{ ");
            for (Object element : sortedView) {
                buffer.append(element);
                buffer.append(", ");
            }
            if (sortedView.buckets.size() != 0) {
                buffer.deleteCharAt(buffer.length() - 1);
                buffer.deleteCharAt(buffer.length() - 1);
            }
            buffer.append(" } -> ");
            buffer.append(sortedView.buckets);
            buffer.append("\n");
        }
        if (this.viewMap.size() != 0) {
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.deleteCharAt(buffer.length() - 1);
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ViewEntry<E>
    extends SimpleDeque.Entry<E> {
        private ViewEntry<E> before;
        private ViewEntry<E> after;
        private SortedView<E> view;

        private ViewEntry(E element) {
            super(element);
        }

        void addBefore(ViewEntry<E> existingEntry) {
            this.after = existingEntry;
            this.before = existingEntry.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        protected void remove() {
            if (this.view != null) {
                this.before.after = this.after;
                this.after.before = this.before;
                ((SortedView)this.view).remove(this);
            }
            this.before = null;
            this.after = null;
            this.view = null;
            super.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortedView<E>
    implements Iterable<E> {
        private Sortable sortable;
        private final TreeMap<Comparable, ViewEntry<E>> buckets;
        private ViewEntry<E> viewHeader = new ViewEntry(null);

        private SortedView(final Sortable sortable) {
            this.sortable = sortable;
            this.buckets = new TreeMap(new Comparator<Comparable>(){

                @Override
                public int compare(Comparable o1, Comparable o2) {
                    int result = o1.compareTo(o2);
                    return sortable.isAscending() ? result : -result;
                }
            });
            ((ViewEntry)this.viewHeader).after = (((ViewEntry)this.viewHeader).before = (ViewEntry)this.viewHeader);
        }

        @Override
        public Iterator<E> iterator() {
            LinkedList<Object> list = new LinkedList<Object>();
            ViewEntry pivot = ((ViewEntry)this.viewHeader).after;
            while (pivot != this.viewHeader) {
                list.add(pivot.element);
                pivot = pivot.after;
            }
            return list.iterator();
        }

        private SimpleDeque.Entry<E> getPosition(E element) {
            Comparable index = this.sortable.getIndex(element);
            for (ViewEntry<E> entry : this.buckets.values()) {
                int cmp = this.sortable.getIndex(entry.element).compareTo(index);
                if ((cmp <= 0 || !this.sortable.isAscending()) && (cmp >= 0 || this.sortable.isAscending())) continue;
                return entry;
            }
            return null;
        }

        private void add(ViewEntry<E> entry) {
            Comparable index = this.sortable.getIndex(entry.element);
            this.buckets.put(index, entry);
            ((ViewEntry)entry).view = this;
            for (ViewEntry<E> position : this.buckets.values()) {
                int cmp = this.sortable.getIndex(position.element).compareTo(index);
                if ((cmp <= 0 || !this.sortable.isAscending()) && (cmp >= 0 || this.sortable.isAscending())) continue;
                entry.addBefore(position);
                return;
            }
            entry.addBefore(this.viewHeader);
        }

        private void remove(ViewEntry<E> entry) {
            Comparable index = this.sortable.getIndex(entry.element);
            ViewEntry<E> bucket = this.buckets.get(index);
            if (bucket == entry) {
                ViewEntry pivot = ((ViewEntry)bucket).before;
                if (pivot == this.viewHeader || !this.sortable.getIndex(pivot.element).equals(index)) {
                    this.buckets.remove(index);
                } else {
                    this.buckets.put(index, pivot);
                }
            }
        }

        private void clear() {
            this.buckets.clear();
            this.viewHeader = null;
            this.sortable = null;
        }
    }
}

