/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.Locale;

public class OS {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    public static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    public static final String PATH_SEP = System.getProperty("path.separator");
    private String family;
    private String name;
    private String version;
    private String arch;

    public OS() {
    }

    public static boolean isWindows() {
        return OS.isOs("windows", null, null, null) || OS.isOs("win9x", null, null, null);
    }

    public static boolean isAIX() {
        return OS.isOs(null, "aix", null, null);
    }

    public static boolean isUNIX() {
        return OS.isOs("unix", null, null, null);
    }

    public static boolean isUnix() {
        return OS.isUNIX();
    }

    public static boolean isSun() {
        return OS.isOs(null, "sun", null, null);
    }

    public static boolean isLinux() {
        return OS.isOs(null, "linux", null, null);
    }

    public static boolean isWindowsForSure() {
        return OS.isWindows();
    }

    public OS(String family) {
        this.setFamily(family);
    }

    public void setFamily(String f) {
        this.family = f.toLowerCase(Locale.US);
    }

    public void setName(String name) {
        this.name = name.toLowerCase(Locale.US);
    }

    public void setArch(String arch) {
        this.arch = arch.toLowerCase(Locale.US);
    }

    public void setVersion(String version) {
        this.version = version.toLowerCase(Locale.US);
    }

    public static boolean isFamily(String family) {
        return OS.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return OS.isOs(null, name, null, null);
    }

    public static boolean isArch(String arch) {
        return OS.isOs(null, null, arch, null);
    }

    public static boolean isVersion(String version) {
        return OS.isOs(null, null, null, version);
    }

    public static boolean isOs(String family, String name, String arch, String version) {
        boolean retValue = false;
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (family != null) {
                if (family.equals("windows")) {
                    isFamily = OS_NAME.indexOf("windows") > -1;
                } else if (family.equals("os/2")) {
                    isFamily = OS_NAME.indexOf("os/2") > -1;
                } else if (family.equals("netware")) {
                    isFamily = OS_NAME.indexOf("netware") > -1;
                } else if (family.equals("dos")) {
                    isFamily = PATH_SEP.equals(";") && !OS.isFamily("netware");
                } else if (family.equals("mac")) {
                    isFamily = OS_NAME.indexOf("mac") > -1;
                } else if (family.equals("tandem")) {
                    isFamily = OS_NAME.indexOf("nonstop_kernel") > -1;
                } else if (family.equals("unix")) {
                    isFamily = PATH_SEP.equals(":") && !OS.isFamily("openvms") && (!OS.isFamily("mac") || OS_NAME.endsWith("x"));
                } else if (family.equals("win9x")) {
                    isFamily = OS.isFamily("windows") && (OS_NAME.indexOf("95") >= 0 || OS_NAME.indexOf("98") >= 0 || OS_NAME.indexOf("me") >= 0 || OS_NAME.indexOf("ce") >= 0);
                } else if (family.equals("z/os")) {
                    isFamily = OS_NAME.indexOf("z/os") > -1 || OS_NAME.indexOf("os/390") > -1;
                } else if (family.equals("os/400")) {
                    isFamily = OS_NAME.indexOf("os/400") > -1;
                } else if (family.equals("openvms")) {
                    isFamily = OS_NAME.indexOf("openvms") > -1;
                } else {
                    throw new RuntimeException("Don't know how to detect os family \"" + family + "\"");
                }
            }
            if (name != null) {
                boolean bl = isName = OS_NAME.indexOf(name.toLowerCase(Locale.US)) >= 0;
            }
            if (arch != null) {
                isArch = arch.toLowerCase(Locale.US).equals(OS_ARCH);
            }
            if (version != null) {
                isVersion = version.toLowerCase(Locale.US).equals(OS_VERSION);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }

    public static void main(String[] args) {
        System.out.println(OS_NAME + " " + OS_ARCH + " " + OS_VERSION);
        System.out.println("isUNIX() returned: " + OS.isUNIX());
        System.out.println("isWindows() returned: " + OS.isWindows());
        System.out.println("isWindowsForSure() returned: " + OS.isWindowsForSure());
        System.out.println("isSun() returned: " + OS.isSun());
        System.out.println("isLinux() returned: " + OS.isLinux());
        System.out.println("isAIX() returned: " + OS.isAIX());
    }
}

