/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import jeus.net.Endpoint;
import jeus.net.NetworkControlPacket;
import jeus.net.ReplyListener;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.helper.MsgSync;
import jeus.util.ScheduleTask;
import jeus.util.ThreadPoolThreadFactory;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;

public class PingTimerTask
extends ScheduleTask
implements Executor {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.net");
    private final Endpoint endpoint;
    private final SocketID mySocketID;
    private final NetworkControlPacket pingPacket;
    private final long pingTimeout;
    private final long pingPeriod;
    private final Executor threadPool;

    public PingTimerTask(Endpoint endpoint) {
        this(endpoint, JeusNetProperties.PING_PERIOD, JeusNetProperties.PING_TIMEOUT);
    }

    public PingTimerTask(Endpoint endpoint, long period, long timeout) {
        this(endpoint, period, timeout, true);
    }

    public PingTimerTask(Endpoint endpoint, long period, long timeout, boolean sync) {
        this.endpoint = endpoint;
        this.mySocketID = endpoint.getMySocketID();
        this.pingPacket = new NetworkControlPacket(5);
        this.pingPacket.setSocketID(this.mySocketID);
        this.pingPeriod = period;
        this.pingTimeout = timeout;
        this.threadPool = sync ? this : Executors.newCachedThreadPool(new ThreadPoolThreadFactory("PING-THREAD(" + this.mySocketID + ")", true));
    }

    public void execute(Runnable command) {
        command.run();
    }

    public void run() {
        int i;
        SocketStream[] servers = this.endpoint.getConnectionManager().getSocketStreams();
        MsgSync[] syncs = new MsgSync[servers.length];
        for (i = 0; i < servers.length; ++i) {
            SocketStream server = servers[i];
            if (!server.getEndpoint().isIdleTime(this.pingPeriod / 2L)) continue;
            MsgSync sync = new MsgSync(this.pingTimeout);
            this.threadPool.execute(new WriteCommand(this.endpoint, server, this.pingPacket, sync));
            syncs[i] = sync;
        }
        for (i = 0; i < syncs.length; ++i) {
            MsgSync sync = syncs[i];
            if (sync == null) continue;
            try {
                Object returnValue = sync.waitReply();
                if (returnValue instanceof NetworkControlPacket && ((NetworkControlPacket)returnValue).getCode() == 6) continue;
                throw new IOException("did not received ping packet");
            }
            catch (IOException e) {
                SocketStream server = servers[i];
                if (logger.isLoggable(JeusMessage_Network._1001_LEVEL)) {
                    logger.log(JeusMessage_Network._1001_LEVEL, JeusMessage_Network._1001, server.getSocketID(), (Throwable)e);
                }
                server.destroy();
            }
        }
    }

    private static class WriteCommand
    implements Runnable {
        private final Endpoint endpoint;
        private final SocketStream server;
        private final NetworkControlPacket packet;
        private final MsgSync sync;

        private WriteCommand(Endpoint endpoint, SocketStream server, NetworkControlPacket packet, MsgSync sync) {
            this.endpoint = endpoint;
            this.server = server;
            this.packet = packet;
            this.sync = sync;
        }

        public void run() {
            try {
                this.server.write(this.packet, (ReplyListener)this.sync);
            }
            catch (IOException e) {
                if (logger.isLoggable(JeusMessage_Network._1000_LEVEL)) {
                    logger.log(JeusMessage_Network._1000_LEVEL, JeusMessage_Network._1000, this.server.getSocketID(), (Throwable)e);
                }
                this.endpoint.getConnectionManager().remove(this.server);
            }
        }
    }
}

