/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import jeus.util.RefinedThreadPoolExecutor;
import jeus.util.ThreadPoolExecutor;
import jeus.util.ThreadPoolThreadFactory;
import jeus.util.concurrent50.concurrent.Executor;
import jeus.util.properties.JeusNetProperties;
import jeus.util.properties.JeusThreadPoolProperties;

public class PooledExecutorFactory {
    private static PooledExecutorFactory executorFactory = new PooledExecutorFactory();

    public static Executor createPooledExecutor(String threadNamePrefix, int maximumPoolSize) {
        return executorFactory.createPooledExecutorInternal(threadNamePrefix, PooledExecutorFactory.getDefaultInitSize(maximumPoolSize), maximumPoolSize, JeusNetProperties.THREAD_KEEP_ALIVE_TIME, true);
    }

    public static java.util.concurrent.Executor createThreadPoolExecutor(String threadNamePrefix, int maximumPoolSize) {
        return executorFactory.createThreadPoolExecutorInternal(threadNamePrefix, PooledExecutorFactory.getDefaultInitSize(maximumPoolSize), maximumPoolSize, JeusNetProperties.THREAD_KEEP_ALIVE_TIME, true);
    }

    public static Executor createPooledExecutor(String threadNamePrefix, int maximumPoolSize, int corePoolSize, long keepAliveTime) {
        return executorFactory.createPooledExecutorInternal(threadNamePrefix, corePoolSize, maximumPoolSize, keepAliveTime, true);
    }

    public static java.util.concurrent.Executor createThreadPoolExecutor(String threadNamePrefix, int corePoolSize, int maximumPoolSize, long keepAliveTime) {
        return executorFactory.createThreadPoolExecutorInternal(threadNamePrefix, corePoolSize, maximumPoolSize, keepAliveTime, true);
    }

    public static Executor createPooledExecutor(String threadNamePrefix, int maximumPoolSize, int corePoolSize, long keepAliveTime, boolean isDaemon) {
        return executorFactory.createPooledExecutorInternal(threadNamePrefix, corePoolSize, maximumPoolSize, keepAliveTime, isDaemon);
    }

    public static java.util.concurrent.Executor createThreadPoolExecutor(String threadNamePrefix, int corePoolSize, int maximumPoolSize, long keepAliveTime, boolean isDaemon) {
        return executorFactory.createThreadPoolExecutorInternal(threadNamePrefix, corePoolSize, maximumPoolSize, keepAliveTime, isDaemon);
    }

    public static void setPooledExecutorFactory(PooledExecutorFactory factory) {
        executorFactory = factory;
    }

    protected Executor createPooledExecutorInternal(String threadNamePrefix, int corePoolSize, int maximumPoolSize, long keepAliveTime, boolean isDaemon) {
        return new RefinedThreadPoolExecutor(threadNamePrefix, corePoolSize, maximumPoolSize, keepAliveTime, isDaemon);
    }

    protected java.util.concurrent.Executor createThreadPoolExecutorInternal(String threadNamePrefix, int corePoolSize, int maximumPoolSize, long keepAliveTime, boolean isDaemon) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(JeusThreadPoolProperties.THREAD_POOL_QUEUE_SIZE), new ThreadPoolThreadFactory(threadNamePrefix, isDaemon), new ThreadPoolExecutor.CallerRunsPolicy());
        executor.prestartAllCoreThreads();
        return executor;
    }

    public static int getDefaultInitSize(int size) {
        int initSize = size / 10;
        if (initSize > 10) {
            initSize = 10;
        } else if (initSize == 0) {
            initSize = 1;
        }
        return initSize;
    }
}

