/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import javax.rmi.CORBA.Stub;
import jeus.ejb.bean.objectbase.JeusEJBObject;
import jeus.ejb.bean.rmi.RMIInterceptorProvider;
import jeus.ejb.bean.rmi.RMIStub;
import jeus.ejb.util.JeusRemoteClassLoader;
import jeus.rmi.impl.server.JeusProxyMarker;
import jeus.rmi.spec.server.RemoteStub;
import jeus.server.RootClassLoader;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusRootClassLoader;
import jeus.util.cnet.classftp.ClassFTPClassLoader;
import jeus.util.message.JeusMessage_Util;
import jeus.util.properties.JeusEJBProperties;

public class RMISerializer
extends ObjectOutputStream {
    private static String codebase = JeusEJBProperties.RMI_CODEBASE;

    public RMISerializer(OutputStream out) throws IOException {
        super(out);
        this.flush();
        try {
            this.enableReplaceObject(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected void annotateClass(Class cl) throws IOException {
        if (!Remote.class.isAssignableFrom(cl)) {
            return;
        }
        String ejbcodebase = this.getCodeBase(cl);
        if (ejbcodebase != null) {
            this.writeUTF(ejbcodebase);
        } else if (codebase != null) {
            this.writeUTF(codebase);
        } else {
            String codebase1 = RMIClassLoader.getClassAnnotation(cl);
            if (codebase1 != null) {
                this.writeUTF(codebase1);
            }
        }
    }

    private String getCodeBase(Class cl) {
        try {
            String moduleName;
            ClassLoader loader = JeusRootClassLoader.loader;
            if (!(loader instanceof RootClassLoader)) {
                return null;
            }
            ClassLoader ejbArchiveLoader = cl.getClassLoader();
            if (ejbArchiveLoader instanceof JeusRemoteClassLoader) {
                moduleName = ((JeusRemoteClassLoader)((Object)ejbArchiveLoader)).getCodeBasePath(cl.getName());
            } else {
                if (ejbArchiveLoader instanceof ClassFTPClassLoader) {
                    return ((ClassFTPClassLoader)ejbArchiveLoader).getUrlString();
                }
                if (!((loader = ((RootClassLoader)loader).getEJBRootClassLoader()) instanceof JeusRemoteClassLoader)) {
                    return null;
                }
                moduleName = ((JeusRemoteClassLoader)((Object)loader)).getCodeBasePath(cl.getName());
            }
            if (moduleName == null) {
                return null;
            }
            if (moduleName.endsWith(".jar")) {
                return System.getProperty("jeus.ejb.codebase") + moduleName;
            }
            return System.getProperty("jeus.ejb.codebase") + moduleName + cl.getName().replace('.', File.separatorChar) + ".class";
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected Object replaceObject(Object obj) throws IOException {
        try {
            if (obj instanceof Remote && !(obj instanceof Stub)) {
                Object stub;
                if (obj instanceof RemoteObjectInvocationHandler) {
                    return obj;
                }
                if (obj instanceof JeusEJBObject || obj instanceof RemoteStub || obj instanceof JeusProxyMarker || obj instanceof jeus.rmi.spec.server.RemoteObjectInvocationHandler) {
                    stub = obj instanceof RemoteStub || obj instanceof jeus.rmi.spec.server.RemoteObjectInvocationHandler || obj instanceof JeusProxyMarker ? obj : jeus.rmi.spec.server.RemoteObject.toStub((Remote)obj);
                } else {
                    try {
                        stub = RemoteObject.toStub((Remote)obj);
                    }
                    catch (NoSuchObjectException ex) {
                        return obj;
                    }
                }
                if (stub instanceof RMIStub && obj instanceof RMIInterceptorProvider) {
                    ((RMIStub)stub).setClientInterceptor(((RMIInterceptorProvider)obj).getClientInterceptor());
                }
                return stub;
            }
            return obj;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new IOException(ErrorMsgManager.getLocalizedString(JeusMessage_Util._15) + ex);
        }
    }
}

