/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import jeus.util.BlockingQueueForRefinedExecutor;
import jeus.util.concurrent50.ThreadPoolThreadFactory;
import jeus.util.concurrent50.concurrent.ArrayBlockingQueue;
import jeus.util.concurrent50.concurrent.BlockingQueue;
import jeus.util.concurrent50.concurrent.LinkedBlockingQueue;
import jeus.util.concurrent50.concurrent.ThreadFactory;
import jeus.util.concurrent50.concurrent.ThreadPoolExecutor;
import jeus.util.concurrent50.concurrent.TimeUnit;
import jeus.util.properties.JeusThreadPoolProperties;

public class RefinedThreadPoolExecutor
extends ThreadPoolExecutor {
    protected String poolName;
    static int result;

    public RefinedThreadPoolExecutor(String threadNamePrefix, int corePoolSize, int maximumPoolSize, long keepAliveTime, boolean isDaemon) {
        super(RefinedThreadPoolExecutor.getCorePoolSize(corePoolSize, maximumPoolSize), maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, RefinedThreadPoolExecutor.getBlockingQueue(corePoolSize));
        threadNamePrefix = this.checkThreadName(threadNamePrefix);
        ThreadFactory factory = this.createThreadFactory(threadNamePrefix, isDaemon);
        this.poolName = threadNamePrefix;
        this.setThreadFactory(factory);
        this.prestartAllCoreThreads();
    }

    private static int getCorePoolSize(int minPoolSize, int maxPoolSize) {
        if (JeusThreadPoolProperties.THREAD_POOL_TYPE_JDK) {
            int corePoolSize = minPoolSize;
            int increase = 0;
            if (maxPoolSize > minPoolSize && minPoolSize >= 0) {
                increase = (int)((double)(maxPoolSize - minPoolSize) * 0.2 + 0.5);
                corePoolSize += increase;
            }
            return corePoolSize;
        }
        return minPoolSize;
    }

    private static BlockingQueue getBlockingQueue(int corePoolSize) {
        if (JeusThreadPoolProperties.THREAD_POOL_TYPE_JDK) {
            return new ArrayBlockingQueue(JeusThreadPoolProperties.THREAD_POOL_QUEUE_SIZE, true);
        }
        return new LinkedBlockingQueue(corePoolSize / 2 > 0 ? corePoolSize / 2 : 1);
    }

    protected String checkThreadName(String threadNamePrefix) {
        return threadNamePrefix;
    }

    protected ThreadFactory createThreadFactory(String threadNamePrefix, boolean isDaemon) {
        return new ThreadPoolThreadFactory(threadNamePrefix, isDaemon);
    }

    public void execute(Runnable command) {
        if (JeusThreadPoolProperties.THREAD_POOL_TYPE_JDK) {
            super.execute(command);
        } else {
            this.doExecute(command);
        }
    }

    public void doExecute(Runnable command) {
        Runnable statisticRunnable;
        Runnable r;
        if (command == null) {
            throw new NullPointerException();
        }
        do {
            if (this.runState != 0) {
                this.reject(command);
                return;
            }
            if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(command)) {
                return;
            }
            statisticRunnable = this.getQueueingCommand(command);
            if (this.workQueue.offer(statisticRunnable)) {
                return;
            }
            r = this.addIfUnderMaximumPoolSize(command);
            if (r != command) continue;
            return;
        } while (r != null);
        if (this.workQueue instanceof BlockingQueueForRefinedExecutor) {
            ((BlockingQueueForRefinedExecutor)this.workQueue).offerInfinite(statisticRunnable);
        } else {
            this.reject(command);
        }
    }

    protected Runnable getQueueingCommand(Runnable command) {
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            int size = 100;
            Runnable[] runnables = new Runnable[size];
            for (int i = 0; i < runnables.length; ++i) {
                final int index = i;
                runnables[i] = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        System.out.println("***** runnable : " + index);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        System.out.println("***** runnable ended : " + index);
                        Class<RefinedThreadPoolExecutor> clazz = RefinedThreadPoolExecutor.class;
                        synchronized (RefinedThreadPoolExecutor.class) {
                            if (++result >= 100) {
                                RefinedThreadPoolExecutor.class.notify();
                            }
                            // ** MonitorExit[var1_2] (shouldn't be in output)
                            return;
                        }
                    }
                };
            }
            RefinedThreadPoolExecutor executor = new RefinedThreadPoolExecutor("Haha", 1, 10, 10000L, true);
            for (int i = 0; i < runnables.length; ++i) {
                Runnable runnable = runnables[i];
                executor.execute(runnable);
            }
            System.out.println("***** execute ended");
            Class<RefinedThreadPoolExecutor> clazz = RefinedThreadPoolExecutor.class;
            synchronized (RefinedThreadPoolExecutor.class) {
                RefinedThreadPoolExecutor.class.wait();
                // ** MonitorExit[var4_7] (shouldn't be in output)
                System.out.println("***** result : " + result);
                Thread.sleep(30000L);
                System.out.println("***** dump");
                Thread.sleep(30000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

