/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.Iterator;
import jeus.security.base.CredentialFactory;
import jeus.security.base.CredentialFactoryException;
import jeus.security.base.Environment;
import jeus.security.base.SecurityException;
import jeus.security.base.ServiceException;
import jeus.security.base.Subject;
import jeus.security.resource.Password;
import jeus.security.spi.AuthenticationRepositoryService;
import jeus.security.spi.LoginService;
import jeus.security.spi.SecurityInstaller;
import jeus.security.util.LoggerUtil;
import jeus.util.JeusPort;
import jeus.util.JeusRuntimeException;
import jeus.util.VirtualDNS;
import jeus.util.message.JeusMessage_Security;

public class SecurityUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Password getPassword(String subjName) throws ServiceException, SecurityException {
        Iterator credFactories;
        Subject subj = null;
        try {
            LoginService.loginCodeSubject();
            subj = AuthenticationRepositoryService.getSubject(subjName);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            LoginService.logout();
            throw throwable;
        }
        LoginService.logout();
        if (subj != null && (credFactories = subj.getCredentialFactories().iterator()).hasNext()) {
            CredentialFactory factory = (CredentialFactory)credFactories.next();
            try {
                return (Password)factory.getCredential();
            }
            catch (CredentialFactoryException e) {
                throw new SecurityException("Exception", e);
            }
        }
        throw new JeusRuntimeException("The password corresponding to the name " + subjName + " cannot be found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Password getPassword(Subject subj) throws ServiceException, SecurityException {
        Iterator credFactories;
        try {
            LoginService.loginCodeSubject();
            subj = AuthenticationRepositoryService.getSubject(subj);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            LoginService.logout();
            throw throwable;
        }
        LoginService.logout();
        if (subj != null && (credFactories = subj.getPrivateCredentials().iterator()).hasNext()) {
            return (Password)credFactories.next();
        }
        throw new JeusRuntimeException("The password corresponding to the subject " + subj + " cannot be found");
    }

    public static synchronized void installClientSecurity(String nodeName) {
        try {
            if (!SecurityInstaller.isSecurityInstalled()) {
                SecurityInstaller.installSecurity(SecurityUtil.getClientEnvironment(nodeName));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JeusRuntimeException(ex);
        }
    }

    public static synchronized void changeServer(String nodeName) {
        try {
            if (SecurityInstaller.isSecurityInstalled()) {
                SecurityInstaller.setEnvironment(SecurityUtil.getClientEnvironment(nodeName));
                if (LoggerUtil.logger.isLoggable(JeusMessage_Security._79_LEVEL)) {
                    LoggerUtil.logger.log(JeusMessage_Security._79_LEVEL, JeusMessage_Security._79, new Object[]{nodeName});
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new JeusRuntimeException(ex);
        }
    }

    private static Environment getClientEnvironment(String nodeName) {
        int port;
        String node;
        int idx;
        String realnode = nodeName;
        if (realnode.lastIndexOf(":") < 0) {
            realnode = VirtualDNS.getRealNodeName(nodeName);
        }
        if ((idx = realnode.lastIndexOf(":")) == -1) {
            node = realnode;
            port = JeusPort.JeusBase;
        } else {
            node = realnode.substring(0, idx);
            port = Integer.parseInt(realnode.substring(idx + 1));
        }
        Environment env = Environment.getBasicLocalAuthClientConfiguration();
        env.hostNames[0] = node;
        if (port > 0) {
            env.remoteBaseSecurityPorts = new int[]{port};
        }
        return env;
    }

    public static void uninstallSecurity() {
        SecurityInstaller.uninstallSecurity();
    }

    public static String getPlainPassword(String subjName) throws ServiceException, SecurityException {
        return SecurityUtil.getPassword(subjName).getPlainPassword();
    }

    public static String getPlainPassword(Subject subj) throws ServiceException, SecurityException {
        return SecurityUtil.getPassword(subj).getPlainPassword();
    }
}

