/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import jeus.util.JeusException;
import jeus.util.JeusRuntimeException;
import jeus.util.ObjectInputStreamWithLoader;
import jeus.util.SerializerTable;

public class Serializer {
    private ByteArrayOutputStream serOut = new ByteArrayOutputStream(4096);
    public static final SerializerTable serializers = new SerializerTable();

    public static byte[] serializeStatic(Object obj) throws IOException {
        return ((Serializer)serializers.get()).serialize(obj);
    }

    public static Object deserializeStatic(byte[] b) throws IOException {
        return ((Serializer)serializers.get()).deserialize(b);
    }

    public static Object deserializeStatic(byte[] b, ClassLoader loader) throws Exception {
        return ((Serializer)serializers.get()).deserialize(b, loader);
    }

    public static Object cloneObjectStatic(Object s) {
        try {
            return ((Serializer)serializers.get()).cloneObject(s);
        }
        catch (IOException e) {
            throw new JeusRuntimeException("failed to clone", (Throwable)e);
        }
    }

    public static Object cloneObjectStatic(Object s, ClassLoader loader) throws Exception {
        return ((Serializer)serializers.get()).cloneObject(s, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = this.serOut;
        synchronized (byteArrayOutputStream) {
            ObjectOutputStream serIn = new ObjectOutputStream(this.serOut);
            serIn.writeObject(obj);
            byte[] bytes = this.serOut.toByteArray();
            this.serOut.reset();
            return bytes;
        }
    }

    public Object deserialize(byte[] b) throws IOException {
        try {
            return this.deserializeWithCNFE(b);
        }
        catch (Throwable th) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new JeusException("failed to deserialize", th);
        }
    }

    public Object deserializeWithCNFE(byte[] b) throws ClassNotFoundException, IOException {
        ByteArrayInputStream deserIn = new ByteArrayInputStream(b);
        ObjectInputStreamWithLoader deserOut = new ObjectInputStreamWithLoader(deserIn, Thread.currentThread().getContextClassLoader());
        return deserOut.readObject();
    }

    public Object deserialize(byte[] b, ClassLoader loader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream deserIn = new ByteArrayInputStream(b);
        ObjectInputStreamWithLoader deserOut = new ObjectInputStreamWithLoader(deserIn, loader);
        return deserOut.readObject();
    }

    public Object cloneObject(Object s) throws IOException {
        byte[] b = this.serialize(s);
        return this.deserialize(b);
    }

    public Object cloneObject(Object s, ClassLoader loader) throws IOException, ClassNotFoundException {
        byte[] b = this.serialize(s);
        return this.deserialize(b, loader);
    }
}

