/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import jeus.util.Deque;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDeque<E>
implements Deque<E> {
    protected final transient Entry<E> header = new Entry<Object>(null);
    protected transient int size = 0;
    protected transient int modCount = 0;

    public SimpleDeque() {
        this.header.previous = this.header;
        this.header.next = this.header.previous;
    }

    @Override
    public void addFirst(E e) {
        this.addBefore(e, this.header.next);
    }

    @Override
    public void addLast(E e) {
        this.addBefore(e, this.header);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        return this.remove(this.header.next);
    }

    @Override
    public E removeLast() {
        return this.remove(this.header.previous);
    }

    @Override
    public E pollFirst() {
        return this.size == 0 ? null : (E)this.removeFirst();
    }

    @Override
    public E pollLast() {
        return this.size == 0 ? null : (E)this.removeLast();
    }

    @Override
    public E getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    @Override
    public E getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    @Override
    public E peekFirst() {
        return this.size == 0 ? null : (E)this.getFirst();
    }

    @Override
    public E peekLast() {
        return this.size == 0 ? null : (E)this.getLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o == null) {
            Entry e = this.header.previous;
            while (e != this.header) {
                if (e.element == null) {
                    this.remove(e);
                    return true;
                }
                e = e.previous;
            }
        } else {
            Entry e = this.header.previous;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    this.remove(e);
                    return true;
                }
                e = e.previous;
            }
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        this.addBefore(e, this.header);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.size == 0 ? null : (E)this.removeFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.size == 0 ? null : (E)this.getFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    this.remove(e);
                    return true;
                }
                e = e.next;
            }
        } else {
            Entry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    this.remove(e);
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            Entry e = this.header.next;
            while (e != this.header) {
                if (e.element == null) {
                    return true;
                }
                e = e.next;
            }
        } else {
            Entry e = this.header.next;
            while (e != this.header) {
                if (o.equals(e.element)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return new ListItr(0);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Entry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int i = 0;
        T[] result = a;
        Entry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.size() == 0) {
            return false;
        }
        ++this.modCount;
        Entry<E> successor = this.header;
        Entry predecessor = this.header.previous;
        for (E element : c) {
            Entry<E> e = new Entry<E>(element);
            e.previous = predecessor;
            e.next = successor;
            predecessor.next = e;
            predecessor = e;
        }
        successor.previous = predecessor;
        this.size += c.size();
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (!c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        Entry e = this.header.next;
        while (e != this.header) {
            Entry next = e.next;
            e.previous = null;
            e.next = null;
            e.element = null;
            e = next;
        }
        this.header.previous = this.header;
        this.header.next = this.header.previous;
        this.size = 0;
        ++this.modCount;
    }

    protected Entry<E> addBefore(E o, Entry<E> e) {
        Entry<E> newEntry = this.createEntry(o);
        newEntry.previous = e.previous;
        newEntry.next = e;
        newEntry.previous.next = newEntry;
        newEntry.next.previous = newEntry;
        ++this.size;
        ++this.modCount;
        return newEntry;
    }

    protected Entry<E> createEntry(E e) {
        return new Entry<E>(e);
    }

    protected E remove(Entry<E> entry) {
        if (entry == this.header) {
            throw new NoSuchElementException();
        }
        Object result = entry.element;
        entry.remove();
        --this.size;
        ++this.modCount;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    implements ListIterator<E> {
        private Entry<E> lastReturned;
        private Entry<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.lastReturned = SimpleDeque.this.header;
            this.expectedModCount = SimpleDeque.this.modCount;
            if (index < 0 || index > SimpleDeque.this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + SimpleDeque.this.size);
            }
            if (index < SimpleDeque.this.size >> 1) {
                this.next = SimpleDeque.this.header.next;
                this.nextIndex = 0;
                while (this.nextIndex < index) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = SimpleDeque.this.header;
                this.nextIndex = SimpleDeque.this.size;
                while (this.nextIndex > index) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != SimpleDeque.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (this.nextIndex == SimpleDeque.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.element;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        @Override
        public E previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.next = this.next.previous;
            this.lastReturned = this.next;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.element;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            Entry lastNext = this.lastReturned.next;
            try {
                SimpleDeque.this.remove(this.lastReturned);
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException();
            }
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = SimpleDeque.this.header;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == SimpleDeque.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.element = e;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = SimpleDeque.this.header;
            SimpleDeque.this.addBefore(e, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (SimpleDeque.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<E> {
        protected E element;
        Entry<E> previous;
        Entry<E> next;

        protected Entry(E element) {
            this.element = element;
        }

        protected void remove() {
            this.previous.next = this.next;
            this.next.previous = this.previous;
            this.previous = null;
            this.next = null;
            this.element = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DescendingIterator
    implements Iterator {
        final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(SimpleDeque.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }
}

