/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.Comparator;
import jeus.util.HashMap;
import jeus.util.LinkedHashMap;
import jeus.util.Sortable;
import jeus.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private final Sortable sortable;
    private final TreeMap<Comparable, Bucket> buckets;

    public SortableLinkedHashMap(final Sortable sortable) {
        this.sortable = sortable;
        this.buckets = new TreeMap(new Comparator<Comparable>(){

            @Override
            public int compare(Comparable o1, Comparable o2) {
                int result = o1.compareTo(o2);
                return sortable.isAscending() ? result : -result;
            }
        });
    }

    @Override
    public void clear() {
        super.clear();
        this.buckets.clear();
    }

    @Override
    public V remove(Object key) {
        LinkedHashMap.Entry e = (LinkedHashMap.Entry)this.removeEntryForKey(key);
        if (e == null) {
            return null;
        }
        Object result = e.value;
        if (!this.sortable.accept(result)) {
            return (V)result;
        }
        Comparable index = this.sortable.getIndex(result);
        if (index == null || !this.checkType(index)) {
            return (V)result;
        }
        Bucket bucket = this.buckets.get(index);
        if (e == bucket.head && e == bucket.tail) {
            this.buckets.remove(index);
        } else if (e == bucket.head) {
            LinkedHashMap.Entry pivot = e.after;
            while (!index.equals(this.sortable.getIndex(pivot.value))) {
                pivot = pivot.after;
            }
            bucket.head = pivot;
        } else if (e == bucket.tail) {
            LinkedHashMap.Entry pivot = e.before;
            while (!index.equals(this.sortable.getIndex(pivot.value))) {
                pivot = pivot.before;
            }
            bucket.tail = pivot;
        }
        return (V)result;
    }

    @Override
    public V put(K key, V value) {
        if (this.sortable.accept(value) && this.checkType(this.sortable.getIndex(value))) {
            if (key == null) {
                return this.putForNullKey(value);
            }
            int hash = SortableLinkedHashMap.hash(key.hashCode());
            int i = SortableLinkedHashMap.indexFor(hash, this.table.length);
            HashMap.Entry e = this.table[i];
            while (e != null) {
                if (e.hash == hash && SortableLinkedHashMap.eq(key, e.key)) {
                    this.remove(key);
                    this.put(key, value);
                }
                e = e.next;
            }
            ++this.modCount;
            this.addEntry(hash, key, value, i);
            return null;
        }
        return super.put(key, value);
    }

    @Override
    protected V putAsEldest(K key, V value) {
        if (this.sortable.accept(value) && this.checkType(this.sortable.getIndex(value))) {
            LinkedHashMap.Entry<K, V> e;
            if (key == null) {
                return this.putForNullKey(value);
            }
            int hash = SortableLinkedHashMap.hash(key.hashCode());
            int i = SortableLinkedHashMap.indexFor(hash, this.table.length);
            HashMap.Entry e2 = this.table[i];
            while (e2 != null) {
                if (e2.hash == hash && SortableLinkedHashMap.eq(key, e2.key)) {
                    this.remove(key);
                    this.putAsEldest(key, value);
                }
                e2 = e2.next;
            }
            Comparable index = this.sortable.getIndex(value);
            ++this.modCount;
            this.table[i] = e = new LinkedHashMap.Entry<K, V>(hash, key, value, this.table[i]);
            if (index == null) {
                e.addAfter(this.header);
            } else {
                this.addEntryAsEldest(e, index);
            }
            ++this.size;
            if (this.size >= this.threshold) {
                this.resize(2 * this.table.length);
            }
            return null;
        }
        return super.putAsEldest(key, value);
    }

    @Override
    void createEntry(int hash, K key, V value, int bucketIndex) {
        LinkedHashMap.Entry<K, V> e;
        Comparable index = this.sortable.getIndex(value);
        if (index == null || !this.checkType(index)) {
            super.createEntry(hash, key, value, bucketIndex);
            return;
        }
        this.table[bucketIndex] = e = new LinkedHashMap.Entry<K, V>(hash, key, value, this.table[bucketIndex]);
        this.addEntry(e, index);
        ++this.size;
    }

    private void addEntry(LinkedHashMap.Entry<K, V> entry, Comparable index) {
        Bucket bucket = this.buckets.get(index);
        if (bucket == null) {
            this.buckets.put(index, new Bucket(entry));
        } else {
            bucket.tail = entry;
        }
        TreeMap.Entry<Comparable, Bucket> sEntry = TreeMap.successor(this.buckets.getEntry(index));
        entry.addBefore(sEntry == null ? this.header : sEntry.getValue().head);
    }

    private void addEntryAsEldest(LinkedHashMap.Entry<K, V> entry, Comparable index) {
        Bucket bucket = this.buckets.get(index);
        if (bucket == null) {
            this.buckets.put(index, new Bucket(entry));
        } else {
            bucket.head = entry;
        }
        TreeMap.Entry<Comparable, Bucket> pEntry = TreeMap.predecessor(this.buckets.getEntry(index));
        entry.addAfter(pEntry == null ? this.header : pEntry.getValue().tail);
    }

    private boolean checkType(Object object) {
        return this.sortable.getType().equalsIgnoreCase("Boolean") && object instanceof Boolean || this.sortable.getType().equalsIgnoreCase("Byte") && object instanceof Byte || this.sortable.getType().equalsIgnoreCase("Float") && object instanceof Float || this.sortable.getType().equalsIgnoreCase("Integer") && object instanceof Integer || this.sortable.getType().equalsIgnoreCase("Double") && object instanceof Double || this.sortable.getType().equalsIgnoreCase("String") && object instanceof String;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Bucket {
        LinkedHashMap.Entry<K, V> head;
        LinkedHashMap.Entry<K, V> tail;

        private Bucket(LinkedHashMap.Entry<K, V> newEntry) {
            this.head = newEntry;
            this.tail = newEntry;
        }
    }
}

