/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import jeus.util.ThreadPoolThreadFactory;

public class StatisticThreadPoolThreadFactory
extends ThreadPoolThreadFactory {
    public StatisticThreadPoolThreadFactory(String namePrefix, boolean isDaemon) {
        super(namePrefix, isDaemon);
    }

    public Thread newThread(final Runnable r) {
        Thread t = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                StatisticThread t = new StatisticThread(r, StatisticThreadPoolThreadFactory.this.namePrefix + "-" + StatisticThreadPoolThreadFactory.this.threadNumber.getAndIncrement());
                t.setDaemon(StatisticThreadPoolThreadFactory.this.isDaemon);
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                t.setContextClassLoader(ThreadPoolThreadFactory.class.getClassLoader());
                return t;
            }
        });
        return t;
    }

    public static class StatisticThread
    extends Thread {
        public static final long UNSPECIFIED_TIME = -1L;
        private long recentWaitingStartTime = -1L;
        private long recentRunningStartTime = -1L;

        public StatisticThread(Runnable command, String s) {
            super(command, s);
        }

        public void beforeGettingTask(long currentTime) {
            this.recentWaitingStartTime = currentTime;
        }

        public void beforeRunningTask(long currentTime) {
            this.recentRunningStartTime = currentTime;
        }

        public long getRecentWaitingStartTime() {
            return this.recentWaitingStartTime;
        }

        public long getRecentRunningStartTime() {
            return this.recentRunningStartTime;
        }

        public void resetTime() {
            this.recentWaitingStartTime = -1L;
            this.recentRunningStartTime = -1L;
        }
    }
}

