/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JeusBootstrapPropertyValues;

public class StringUtil {
    public static final String lineSeparator = JeusBootstrapPropertyValues.lineSeparator;

    public static String getNodeNameFromContainerName(String containerName) throws IllegalJeusSystemNameException {
        int index = containerName.lastIndexOf(95);
        if (index == -1) {
            throw new IllegalJeusSystemNameException(containerName + " is not container name");
        }
        return containerName.substring(0, index);
    }

    public static String getEngineContainerNameFromContainerName(String containerName) {
        return containerName.substring(containerName.lastIndexOf(95) + 1);
    }

    public static String getStringFromInputStream(InputStream input) throws IOException {
        StringBuffer strBuffer = new StringBuffer();
        byte[] buffer = new byte[51200];
        int len;
        while ((len = input.read(buffer)) != -1) {
            String msg = new String(buffer, 0, len);
            strBuffer.append(msg);
        }
        return strBuffer.toString();
    }

    public static boolean isDefaultContainerName(String containerName) {
        return containerName.endsWith("_default");
    }

    public static String getNodeNameFromEngineName(String engineName) throws IllegalJeusSystemNameException {
        int index = engineName.lastIndexOf(95);
        if (index < 0) {
            throw new IllegalJeusSystemNameException(engineName + " is not engine name");
        }
        String temp = engineName.substring(0, index);
        if ((index = temp.lastIndexOf(95)) < 0) {
            throw new IllegalJeusSystemNameException(engineName + " is not engine name");
        }
        return temp.substring(0, index);
    }

    public static String getJMXManagerValue(String containerName) throws IllegalJeusSystemNameException {
        if (StringUtil.isDefaultContainerName(containerName)) {
            return StringUtil.getNodeNameFromContainerName(containerName);
        }
        return containerName;
    }

    public static String getParentDirectory(String filePath) {
        int sepIndex = filePath.lastIndexOf(File.separator);
        if (sepIndex < 0) {
            sepIndex = filePath.lastIndexOf("/");
        }
        if (sepIndex >= 0) {
            filePath = filePath.substring(0, sepIndex + 1);
        }
        return filePath;
    }

    public static String[] mergeStringArray(String[][] strings) {
        ArrayList<String> mergedList = new ArrayList<String>();
        for (int i = 0; i < strings.length; ++i) {
            String[] string = strings[i];
            for (int j = 0; j < string.length; ++j) {
                mergedList.add(string[j]);
            }
        }
        return mergedList.toArray(new String[mergedList.size()]);
    }

    public static boolean isSameFilePath(String memberFile, String runtimeDDPath) {
        String aFile = memberFile.replace(File.separatorChar, '/');
        String bFile = runtimeDDPath.replace(File.separatorChar, '/');
        return aFile.equals(bFile);
    }

    public static String removePrefix(String permissionGrantStmt, String s) {
        int prefixIndex = permissionGrantStmt.indexOf(s);
        if (prefixIndex >= 0) {
            permissionGrantStmt = permissionGrantStmt.substring(prefixIndex + 1);
        }
        return permissionGrantStmt;
    }

    public static boolean isMemberOf(String a, String[] b, int lastIndex) {
        for (int i = 0; i < lastIndex; ++i) {
            if (!a.equals(b[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isMemberOf(String a, String[] b) {
        return StringUtil.isMemberOf(a, b, b.length);
    }

    public static String cutPackagePart(String s) {
        int index = s.lastIndexOf(46);
        if (index == -1) {
            return s;
        }
        return s.substring(index + 1);
    }

    public static String getTypeDeclaration(Class cls) {
        String array = "";
        while (cls.isArray()) {
            cls = cls.getComponentType();
            array = array + "[]";
        }
        return cls.getName().replace('$', '.') + array;
    }

    public static String getUpperLeadString(String target) {
        if (target.length() > 0) {
            char[] temp = target.toCharArray();
            temp[0] = Character.toUpperCase(temp[0]);
            return new String(temp);
        }
        return target;
    }

    public static String getLowerLeadString(String target) {
        if (target.length() > 0) {
            char[] temp = target.toCharArray();
            temp[0] = Character.toLowerCase(temp[0]);
            return new String(temp);
        }
        return target;
    }

    public static String getLastString(String[] args, int startIndex, int lastIndex) {
        StringBuffer strBuffer = new StringBuffer();
        if (args == null || startIndex < 0 || lastIndex != -1 && startIndex > lastIndex || args.length - 1 < startIndex) {
            throw new IllegalArgumentException();
        }
        if (lastIndex == -1) {
            lastIndex = args.length - 1;
        }
        for (int i = startIndex; i < lastIndex; ++i) {
            strBuffer.append(args[i]);
            if (i + 1 >= lastIndex) continue;
            strBuffer.append(" ");
        }
        return strBuffer.toString();
    }

    public static boolean isAbsolutePath(String ejbDDPath) {
        File f = new File(ejbDDPath);
        return f.isAbsolute();
    }

    public static String removePackageName(String s) {
        return s.substring(s.lastIndexOf(".") + 1);
    }

    public static String getClassName(String ejbBeanClassName) {
        int index = ejbBeanClassName.lastIndexOf(46);
        return ejbBeanClassName.substring(index + 1);
    }

    public static String getFileNameFromClassName(String className) {
        return className.replace('.', File.separatorChar);
    }

    public static Class getClassFromString(String s, ClassLoader loader) throws ClassNotFoundException {
        boolean isArray;
        String className;
        StringBuffer classString = new StringBuffer();
        int nameIndex = s.indexOf(91);
        if (nameIndex >= 0) {
            className = s.substring(0, nameIndex);
            isArray = true;
        } else {
            className = s;
            isArray = false;
        }
        int index = -2;
        while ((index = s.indexOf("[]", index + 2)) != -1) {
            classString.append('[');
        }
        if (className.equals("boolean")) {
            if (!isArray) {
                return Boolean.TYPE;
            }
            classString.append('Z');
            className = classString.toString();
        } else if (className.equals("byte")) {
            if (!isArray) {
                return Byte.TYPE;
            }
            classString.append('B');
            className = classString.toString();
        } else if (className.equals("char")) {
            if (!isArray) {
                return Character.TYPE;
            }
            classString.append('C');
            className = classString.toString();
        } else if (className.equals("short")) {
            if (!isArray) {
                return Short.TYPE;
            }
            classString.append('S');
            className = classString.toString();
        } else if (className.equals("int")) {
            if (!isArray) {
                return Integer.TYPE;
            }
            classString.append('I');
            className = classString.toString();
        } else if (className.equals("long")) {
            if (!isArray) {
                return Long.TYPE;
            }
            classString.append('J');
            className = classString.toString();
        } else if (className.equals("float")) {
            if (!isArray) {
                return Float.TYPE;
            }
            classString.append('F');
            className = classString.toString();
        } else if (className.equals("double")) {
            if (!isArray) {
                return Double.TYPE;
            }
            classString.append('D');
            className = classString.toString();
        } else if (isArray) {
            className = classString.append('L').append(className).append(';').toString();
        }
        return loader.loadClass(className);
    }

    public static String getJMXManagerValueFromEngineName(String engineName) {
        String temp = engineName.substring(0, engineName.lastIndexOf(95));
        return temp.substring(0, temp.lastIndexOf(95));
    }

    public static String[] concatStringArrays(String[] commonArgs, String sourceFileNames) {
        if (sourceFileNames.indexOf(32) < 0) {
            String[] result = new String[commonArgs.length + 1];
            System.arraycopy(commonArgs, 0, result, 0, commonArgs.length);
            result[commonArgs.length] = sourceFileNames;
            return result;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < commonArgs.length; ++i) {
            list.add(commonArgs[i]);
        }
        StringTokenizer tokenizer = new StringTokenizer(sourceFileNames, " ");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] concatStringArrays(String[] commonArgs, String[] appendArgs) {
        String[] result = new String[commonArgs.length + appendArgs.length];
        System.arraycopy(commonArgs, 0, result, 0, commonArgs.length);
        System.arraycopy(appendArgs, 0, result, commonArgs.length, appendArgs.length);
        return result;
    }

    public static String[] getTokenizedStringArray(String content) {
        ArrayList<String> list = new ArrayList<String>();
        if (content != null) {
            StringTokenizer tokenizer = new StringTokenizer(content, " ");
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getPackageAndClassName(String aClass) {
        int packageIndex = aClass.lastIndexOf(".");
        if (packageIndex < 0) {
            return new String[]{"", aClass};
        }
        String className = aClass.substring(packageIndex + 1);
        String packageName = aClass.substring(0, packageIndex);
        return new String[]{packageName, className};
    }

    public static String getMethodNameFromFullMethodName(String aMethod) {
        int packageIndex = aMethod.lastIndexOf(".");
        if (packageIndex < 0) {
            return aMethod;
        }
        return aMethod.substring(packageIndex + 1);
    }

    public static String[] removeDuplicateElement(String[] array) {
        if (array == null) {
            throw new IllegalArgumentException("String[] array is null");
        }
        HashSet<String> list = new HashSet<String>();
        for (int i = 0; i < array.length; ++i) {
            String element = array[i];
            if (list.contains(element)) continue;
            list.add(array[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getEngineTypeFromEngineName(String name) {
        String temp = name.substring(0, name.lastIndexOf(95));
        return temp.substring(temp.lastIndexOf(95) + 1);
    }

    public static boolean isStartWith(String property, String[] replicatePropertyPrefix) {
        for (int i = 0; i < replicatePropertyPrefix.length; ++i) {
            if (!property.startsWith(replicatePropertyPrefix[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] makeArrayFromString(String separatedString, String delimiter, String[] addArray) {
        StringTokenizer tokenizer = new StringTokenizer(separatedString, delimiter);
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        if (addArray != null) {
            for (int i = 0; i < addArray.length; ++i) {
                String s = addArray[i];
                list.add(s);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] makeArrayFromCommaString(String commaSeparatedString, String[] addArray) {
        return StringUtil.makeArrayFromString(commaSeparatedString, ",", addArray);
    }

    public static String[] makeArrayFromCommaString(String commaSeparatedString) {
        return StringUtil.makeArrayFromCommaString(commaSeparatedString, null);
    }

    public static void setPropertiesToMap(String propertyString, Map map) {
        StringTokenizer tokenizer = new StringTokenizer(propertyString, ",");
        String key = null;
        String value = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int tokenIndex = token.indexOf(61);
            if (tokenIndex < 0) {
                if (key != null && value != null) {
                    value = value + "," + token;
                    token = tokenizer.nextToken();
                    map.put(key, value);
                    break;
                }
                throw new IllegalArgumentException("The property is not correct : " + token);
            }
            key = token.substring(0, tokenIndex).trim();
            value = token.substring(tokenIndex + 1).trim();
            map.put(key, value);
        }
    }

    public static Object[] getEncodingAndXmlDecl(byte[] b) {
        String encoding = StringUtil.getEncodingAndXmlDeclInternal(new String(b));
        if (encoding != null) {
            return new Object[]{encoding, Boolean.FALSE};
        }
        Boolean hasXmlDecl = Boolean.FALSE;
        int b0 = b[0] & 0xFF;
        int b1 = b[1] & 0xFF;
        int b2 = b[2] & 0xFF;
        int b3 = b[3] & 0xFF;
        int b4 = b[4] & 0xFF;
        int b5 = b[5] & 0xFF;
        if (b0 == 60 && b1 == 63) {
            return new Object[]{"UTF-8", Boolean.TRUE};
        }
        if (b0 == 254 && b1 == 255) {
            if (b2 == 0 && b3 == 60 && b4 == 0 && b5 == 63) {
                hasXmlDecl = Boolean.TRUE;
            }
            return new Object[]{"UTF-16", hasXmlDecl};
        }
        if (b0 == 255 && b1 == 254) {
            if (b2 == 60 && b3 == 0 && b4 == 63 && b5 == 0) {
                hasXmlDecl = Boolean.TRUE;
            }
            return new Object[]{"UTF-16", hasXmlDecl};
        }
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            if (b3 == 60 && b4 == 63) {
                hasXmlDecl = Boolean.TRUE;
            }
            return new Object[]{"UTF-8", hasXmlDecl};
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return new Object[]{"UTF-16", Boolean.TRUE};
        }
        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return new Object[]{"UTF-16", Boolean.TRUE};
        }
        return new Object[]{null, null};
    }

    public static String getEncodingAndXmlDecl(String descriptorString) {
        String encoding = StringUtil.getEncodingAndXmlDeclInternal(descriptorString);
        if (encoding == null) {
            return System.getProperty("file.encoding");
        }
        return encoding;
    }

    public static String getEncodingAndXmlDeclInternal(String descriptorString) {
        int start = descriptorString.indexOf("encoding");
        if (start < 0) {
            return null;
        }
        int encodingBegin = descriptorString.indexOf(34, start);
        int encodingEnd = descriptorString.indexOf(34, encodingBegin + 1);
        return descriptorString.substring(encodingBegin + 1, encodingEnd);
    }

    public static String normalizeFileSeparator(String path) {
        path = File.separator.equals("/") ? path.replace('\\', File.separatorChar) : path.replace('/', File.separatorChar);
        return path;
    }

    public static void writeString(DataOutputStream output, String content, String encoding) throws IOException {
        byte[] bytes = content.getBytes(encoding);
        output.writeInt(bytes.length);
        output.write(bytes);
    }

    public static String readString(DataInputStream input, String encoding) throws IOException {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readFully(bytes);
        return new String(bytes, encoding);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    public static Object[] getNormalizedClassName(String className) {
        int index = className.lastIndexOf(91);
        if (index >= 0) {
            int numArray = index + 1;
            switch (className.charAt(numArray)) {
                case 'Z': {
                    return new Object[]{"boolean", new Integer(numArray)};
                }
                case 'B': {
                    return new Object[]{"byte", new Integer(numArray)};
                }
                case 'C': {
                    return new Object[]{"char", new Integer(numArray)};
                }
                case 'L': {
                    return new Object[]{className.substring(numArray + 1, className.length() - 1), new Integer(numArray)};
                }
                case 'D': {
                    return new Object[]{"double", new Integer(numArray)};
                }
                case 'F': {
                    return new Object[]{"float", new Integer(numArray)};
                }
                case 'I': {
                    return new Object[]{"int", new Integer(numArray)};
                }
                case 'J': {
                    return new Object[]{"long", new Integer(numArray)};
                }
                case 'S': {
                    return new Object[]{"short", new Integer(numArray)};
                }
            }
            throw new RuntimeException("Invalid class name : " + className);
        }
        return null;
    }

    public static String replaceToValidClassName(String className) {
        return className.replace('.', '_').replace('-', '_');
    }

    public static void writeStringBuffer(StringBuffer buffer, int level, String string) {
        for (int i = 0; i < level; ++i) {
            buffer.append('\t');
        }
        buffer.append(string);
        buffer.append(lineSeparator);
    }

    public static String getFileNameFromPath(String path) {
        int index = path.lastIndexOf(File.separator);
        if (index < 0) {
            return path;
        }
        return path.substring(index + 1);
    }

    public static String getFileNameFromPathExceptExtension(String path) {
        String fileName = StringUtil.getFileNameFromPath(path);
        File f = new File(path);
        if (f.isDirectory()) {
            return fileName;
        }
        int index = fileName.lastIndexOf(46);
        if (index >= 0) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public static String replaceAll(String target, String changeLine, String replaceString) {
        int index;
        String result = "";
        int lastIndex = 0;
        while ((index = target.indexOf(changeLine, lastIndex)) >= 0) {
            result = result + target.substring(lastIndex, index);
            result = result + replaceString;
            lastIndex = index + changeLine.length();
        }
        result = result + target.substring(lastIndex);
        return result;
    }

    public static Object[] getNodeAndPort(String nodeName) {
        int index = nodeName.lastIndexOf(":");
        if (index < 0) {
            return new Object[]{nodeName, null};
        }
        return new Object[]{nodeName.substring(0, index), new Integer(Integer.parseInt(nodeName.substring(index + 1)))};
    }
}

