/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ThreadInfo
implements Serializable {
    static final long serialVersionUID = 60564974255440504L;
    private static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];
    private final String threadName;
    private final long threadId;
    private final Thread.State threadState;
    private final boolean isDaemon;
    private final boolean isAlive;
    private final boolean isInterrupted;
    private final int priority;
    private final boolean isActive;
    private long waitedTime;
    private long runTime;
    private final StackTraceElement[] stackTrace;
    private final boolean inNative;
    private final String lockName;
    private final long lockOwnerId;
    private final String lockOwnerName;

    public ThreadInfo(Thread t, boolean isActive, long waitedTime, long runTime, Object lockObj, Thread lockOwner) {
        this(t, isActive, waitedTime, runTime, lockObj, lockOwner, NO_STACK_TRACE);
    }

    public ThreadInfo(final Thread t, boolean isActive, long waitedTime, long runTime, Object lockObj, Thread lockOwner, StackTraceElement[] stackTrace) {
        this.threadName = t.getName();
        this.threadId = t.getId();
        this.threadState = t.getState();
        this.isDaemon = t.isDaemon();
        this.isAlive = t.isAlive();
        this.isInterrupted = t.isInterrupted();
        this.priority = t.getPriority();
        this.isActive = isActive;
        this.waitedTime = waitedTime;
        this.runTime = runTime;
        this.lockName = lockObj == null ? null : lockObj.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(lockObj));
        if (lockOwner == null) {
            this.lockOwnerId = -1L;
            this.lockOwnerName = null;
        } else {
            this.lockOwnerId = lockOwner.getId();
            this.lockOwnerName = lockOwner.getName();
        }
        this.stackTrace = stackTrace == null ? AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

            @Override
            public StackTraceElement[] run() {
                return t.getStackTrace();
            }
        }) : stackTrace;
        this.inNative = this.stackTrace != null && this.stackTrace.length > 0 ? this.stackTrace[0].isNativeMethod() : false;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public Thread.State getThreadState() {
        return this.threadState;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isInterrupted() {
        return this.isInterrupted;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public String getLockName() {
        return this.lockName;
    }

    public long getLockOwnerId() {
        return this.lockOwnerId;
    }

    public String getLockOwnerName() {
        return this.lockOwnerName;
    }

    public boolean isInNative() {
        return this.inNative;
    }
}

