/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import jeus.util.RejectedExecutionHandler;
import jeus.util.StatisticThreadPoolThreadFactory;
import jeus.util.ThreadInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final HashSet<Worker> workers = new HashSet();
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();
    private final AtomicInteger approximateActiveCount = new AtomicInteger(0);
    private static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || threadFactory == null || handler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    @Override
    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        Runnable wrappedCommand = this.wrapCommandBeforeExecution(command);
        if (this.poolSize >= this.corePoolSize || !this.addIfUnderCorePoolSize(wrappedCommand)) {
            if (this.runState == 0 && this.workQueue.offer(wrappedCommand)) {
                if (this.runState != 0 || this.poolSize == 0) {
                    this.ensureQueuedTaskHandled(wrappedCommand);
                } else if (this.runState != 0 || this.poolSize < this.maximumPoolSize && !this.hasIdleWorkersApproximately()) {
                    this.addIfUnderMaximumPoolSizeWithQueueing(wrappedCommand);
                }
            } else if (this.runState == 0 && this.poolSize < this.maximumPoolSize) {
                if (!this.addIfUnderMaximumPoolSize(wrappedCommand)) {
                    this.reject(wrappedCommand);
                }
            } else {
                this.reject(wrappedCommand);
            }
        }
    }

    private boolean hasIdleWorkersApproximately() {
        return this.poolSize > this.approximateActiveCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIfUnderMaximumPoolSizeWithQueueing(Runnable command) {
        Thread t = null;
        boolean reject = false;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int state = this.runState;
            if (state != 0 && this.workQueue.remove(command)) {
                reject = true;
            } else if (state == 0 && this.poolSize < this.maximumPoolSize && !this.workQueue.isEmpty()) {
                t = this.addThread(null);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (reject) {
            this.reject(command);
        } else if (t != null) {
            t.start();
        }
    }

    private Thread addThread(Runnable firstTask) {
        Worker w = new Worker(firstTask);
        Thread t = this.threadFactory.newThread(w);
        if (t != null) {
            w.thread = t;
            this.workers.add(w);
            int nt = ++this.poolSize;
            if (nt > this.largestPoolSize) {
                this.largestPoolSize = nt;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfUnderCorePoolSize(Runnable firstTask) {
        Thread t = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.corePoolSize && this.runState == 0) {
                t = this.addThread(firstTask);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (t == null) {
            return false;
        }
        t.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIfUnderMaximumPoolSize(Runnable firstTask) {
        Thread t = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.maximumPoolSize && this.runState == 0) {
                t = this.addThread(firstTask);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (t == null) {
            return false;
        }
        t.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureQueuedTaskHandled(Runnable command) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        boolean reject = false;
        Thread t = null;
        try {
            int state = this.runState;
            if (state != 0 && this.workQueue.remove(command)) {
                reject = true;
            } else if (state < 2 && this.poolSize < Math.max(this.corePoolSize, 1) && !this.workQueue.isEmpty()) {
                t = this.addThread(null);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (reject) {
            this.reject(command);
        } else if (t != null) {
            t.start();
        }
    }

    protected void reject(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    Runnable getTask() {
        while (true) {
            try {
                do {
                    int state;
                    if ((state = this.runState) > 1) {
                        return null;
                    }
                    Runnable r = state == 1 ? (Runnable)this.workQueue.poll() : (this.poolSize > this.corePoolSize || this.allowCoreThreadTimeOut ? this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : this.workQueue.take());
                    if (r == null) continue;
                    return r;
                } while (!this.workerCanExit());
                if (this.runState >= 1) {
                    this.interruptIdleWorkers();
                }
                return null;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean workerCanExit() {
        boolean canExit;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            canExit = this.runState >= 2 || this.workQueue.isEmpty() || this.allowCoreThreadTimeOut && this.poolSize > Math.max(1, this.corePoolSize);
        }
        finally {
            mainLock.unlock();
        }
        return canExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIdleWorkers() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                w.interruptIfIdle();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerDone(Worker w) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.completedTaskCount += w.completedTasks;
            this.workers.remove(w);
            if (--this.poolSize == 0) {
                this.tryTerminate();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    private void tryTerminate() {
        if (this.poolSize == 0) {
            int state = this.runState;
            if (state < 2 && !this.workQueue.isEmpty()) {
                state = 0;
                Thread t = this.addThread(null);
                if (t != null) {
                    t.start();
                }
            }
            if (state == 2 || state == 1) {
                this.runState = 3;
                this.termination.signalAll();
                this.terminated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(shutdownPerm);
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int state;
            if (security != null) {
                for (Worker w : this.workers) {
                    security.checkAccess(w.thread);
                }
            }
            if ((state = this.runState) < 1) {
                this.runState = 1;
            }
            try {
                for (Worker w : this.workers) {
                    w.interruptIfIdle();
                }
            }
            catch (SecurityException se) {
                this.runState = state;
                throw se;
            }
            this.tryTerminate();
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(shutdownPerm);
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int state;
            if (security != null) {
                for (Worker w : this.workers) {
                    security.checkAccess(w.thread);
                }
            }
            if ((state = this.runState) < 2) {
                this.runState = 2;
            }
            try {
                for (Worker w : this.workers) {
                    w.interruptNow();
                }
            }
            catch (SecurityException se) {
                this.runState = state;
                throw se;
            }
            List<Runnable> tasks = this.drainQueue();
            this.tryTerminate();
            List<Runnable> list = tasks;
            return list;
        }
        finally {
            mainLock.unlock();
        }
    }

    private List<Runnable> drainQueue() {
        ArrayList<Runnable> taskList = new ArrayList<Runnable>();
        this.workQueue.drainTo(taskList);
        while (!this.workQueue.isEmpty()) {
            Iterator it = this.workQueue.iterator();
            try {
                Runnable r;
                if (!it.hasNext() || !this.workQueue.remove(r = (Runnable)it.next())) continue;
                taskList.add(r);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        return taskList;
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    public boolean isTerminating() {
        int state = this.runState;
        return state == 1 || state == 2;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            while (true) {
                if (this.runState == 3) {
                    boolean bl = true;
                    return bl;
                }
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int corePoolSize) {
        block9: {
            if (corePoolSize < 0) {
                throw new IllegalArgumentException();
            }
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                int extra = this.corePoolSize - corePoolSize;
                this.corePoolSize = corePoolSize;
                if (extra < 0) {
                    Thread t;
                    int n = this.workQueue.size();
                    while (extra++ < 0 && n-- > 0 && this.poolSize < corePoolSize && (t = this.addThread(null)) != null) {
                        t.start();
                    }
                    break block9;
                }
                if (extra <= 0 || this.poolSize <= corePoolSize) break block9;
                try {
                    Iterator<Worker> it = this.workers.iterator();
                    while (it.hasNext() && extra-- > 0 && this.poolSize > corePoolSize && this.workQueue.remainingCapacity() == 0) {
                        it.next().interruptIfIdle();
                    }
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean value) {
        if (value && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.allowCoreThreadTimeOut = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int maximumPoolSize) {
        block7: {
            if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
                throw new IllegalArgumentException();
            }
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                int extra;
                this.maximumPoolSize = maximumPoolSize;
                if (extra <= 0 || this.poolSize <= maximumPoolSize) break block7;
                try {
                    Iterator<Worker> it = this.workers.iterator();
                    for (extra = this.maximumPoolSize - maximumPoolSize; it.hasNext() && extra > 0 && this.poolSize > maximumPoolSize; --extra) {
                        it.next().interruptIfIdle();
                    }
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        if (time == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.keepAliveTime = unit.toNanos(time);
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable task) {
        return this.getQueue().remove(task);
    }

    public void purge() {
        try {
            Iterator it = this.getQueue().iterator();
            while (it.hasNext()) {
                Future c;
                Runnable r = (Runnable)it.next();
                if (!(r instanceof Future) || !(c = (Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException ex) {
            return;
        }
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            for (Worker w : this.workers) {
                if (!w.isActive()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLargestPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += w.completedTasks;
                if (!w.isActive()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += w.completedTasks;
            }
            long l = n;
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    public List<ThreadInfo> getThreadInfoList() {
        return this.getThreadInfoList(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ThreadInfo> getThreadInfoList(boolean withStackTrace) {
        Vector<ThreadInfo> threadInfos = new Vector<ThreadInfo>();
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                Thread t = w.thread;
                boolean active = w.isActive();
                long waitedTime = -1L;
                long runTime = -1L;
                if (t instanceof StatisticThreadPoolThreadFactory.StatisticThread) {
                    StatisticThreadPoolThreadFactory.StatisticThread statisticThread = (StatisticThreadPoolThreadFactory.StatisticThread)t;
                    long waitingStartTime = statisticThread.getRecentWaitingStartTime();
                    long runningStartTime = statisticThread.getRecentRunningStartTime();
                    long currentTime = System.currentTimeMillis();
                    if (waitingStartTime != -1L && runningStartTime != -1L) {
                        waitedTime = runningStartTime - waitingStartTime;
                        runTime = currentTime - runningStartTime;
                    } else if (waitingStartTime != -1L) {
                        waitedTime = currentTime - waitingStartTime;
                        runTime = -1L;
                    } else {
                        waitedTime = -1L;
                        runTime = -1L;
                    }
                }
                if (active && withStackTrace) {
                    threadInfos.add(new ThreadInfo(t, active, waitedTime, runTime, null, null, null));
                    continue;
                }
                threadInfos.add(new ThreadInfo(t, active, waitedTime, runTime, null, null));
            }
        }
        finally {
            mainLock.unlock();
        }
        return threadInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptWorker(long tid, boolean forcefully) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                Thread t = w.thread;
                if (t.getId() != tid) continue;
                if (forcefully) {
                    w.interruptNow();
                } else {
                    w.interruptIfIdle();
                }
                break;
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTraceElement[] getStackTrace(long tid) {
        StackTraceElement[] stackTrace = NO_STACK_TRACE;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                final Thread t = w.thread;
                if (t.getId() != tid) continue;
                stackTrace = AccessController.doPrivileged(new PrivilegedAction<StackTraceElement[]>(){

                    @Override
                    public StackTraceElement[] run() {
                        return t.getStackTrace();
                    }
                });
                break;
            }
        }
        finally {
            mainLock.unlock();
        }
        return stackTrace;
    }

    protected Runnable wrapCommandBeforeExecution(Runnable command) {
        return command;
    }

    protected void beforeGettingTask(Thread t) {
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void terminated() {
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }

    private final class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        private Runnable firstTask;
        volatile long completedTasks;
        Thread thread;

        Worker(Runnable firstTask) {
            this.firstTask = firstTask;
        }

        boolean isActive() {
            return this.runLock.isLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptIfIdle() {
            ReentrantLock runLock = this.runLock;
            if (runLock.tryLock()) {
                try {
                    if (this.thread != Thread.currentThread()) {
                        this.thread.interrupt();
                    }
                }
                finally {
                    runLock.unlock();
                }
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask(Runnable task) {
            ReentrantLock runLock = this.runLock;
            runLock.lock();
            try {
                ThreadPoolExecutor.this.approximateActiveCount.incrementAndGet();
                if (ThreadPoolExecutor.this.runState < 2 && Thread.interrupted() && ThreadPoolExecutor.this.runState >= 2) {
                    this.thread.interrupt();
                }
                boolean ran = false;
                ThreadPoolExecutor.this.beforeExecute(this.thread, task);
                try {
                    task.run();
                    ran = true;
                    ThreadPoolExecutor.this.afterExecute(task, null);
                    ++this.completedTasks;
                }
                catch (RuntimeException ex) {
                    if (!ran) {
                        ThreadPoolExecutor.this.afterExecute(task, ex);
                    }
                    throw ex;
                }
            }
            finally {
                ThreadPoolExecutor.this.approximateActiveCount.decrementAndGet();
                runLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runnable task = this.firstTask;
                this.firstTask = null;
                while (true) {
                    ThreadPoolExecutor.this.beforeGettingTask(this.thread);
                    if (task == null) {
                        task = ThreadPoolExecutor.this.getTask();
                    }
                    if (task != null) {
                        this.runTask(task);
                        task = null;
                        continue;
                    }
                    break;
                }
            }
            finally {
                ThreadPoolExecutor.this.workerDone(this);
            }
        }
    }
}

