/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import jeus.net.impl.NodeInfo;
import jeus.server.JeusServerException;
import jeus.server.NodeControllerStub;
import jeus.util.JeusPort;
import jeus.util.JeusProperties;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.net.IPAddressFormat;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusPropertyValues;

public class VirtualDNS {
    protected static Boolean enabledBySystemProperty;
    protected static boolean enabled;
    private static long lastModified;
    private static long vhostFileCheckTime;
    private static final long vhostFileCheckPeriod = 300000L;
    private static final File propertiesFile;
    static Hashtable<String, NodeInfo> nodeInfoMap;
    static Hashtable<InetSocketAddress, String> revers_dns;
    protected static final JeusLogger logger;
    public static String LOCAL_VIRTUALNAME;
    static boolean useDifferentPorts;
    private static VirtualDNS vhostLoader;

    public static void printVirtualHostInformation() {
        if (logger.isLoggable(JeusMessage_Manager._5_LEVEL)) {
            logger.log(JeusMessage_Manager._5_LEVEL, JeusMessage_Manager._5, new Object[]{revers_dns, enabled});
        }
        logger.log(JeusMessage_Manager._6_LEVEL, JeusMessage_Manager._6, (Object)LOCAL_VIRTUALNAME);
    }

    public static String getVirtualHostName(String host) {
        VirtualDNS.reload();
        String result = revers_dns.get(VirtualDNS.convertToSocketAddress(host));
        if (result == null) {
            String port;
            String hostName;
            int index = host.lastIndexOf(":");
            if (index > 0) {
                hostName = host.substring(0, index);
                port = host.substring(index + 1);
            } else {
                hostName = host;
                port = Integer.toString(JeusPort.JeusBase);
            }
            try {
                host = JeusNetPropertyValues.getByName(hostName).getHostAddress() + ":" + port;
                result = revers_dns.get(VirtualDNS.convertToSocketAddress(host));
                return result != null ? result : hostName;
            }
            catch (UnknownHostException e) {
                logger.log(Level.FINE, "ignored exception", (Throwable)e);
                return hostName;
            }
        }
        return result;
    }

    public static String getVirtualHostName(String host, int port) {
        String result;
        VirtualDNS.reload();
        if (port <= 0) {
            port = JeusPort.JeusBase;
        }
        return (result = revers_dns.get(new InetSocketAddress(host, port))) != null ? result : host;
    }

    public static String getRealNodeName(String host) {
        return VirtualDNS.getRealNodeName(host, JeusPort.JeusBase);
    }

    public static String getRealNodeName(String host, int defaultPort) {
        VirtualDNS.reload();
        NodeInfo real_host = nodeInfoMap.get(host);
        if (real_host != null) {
            return real_host.getRealNodeName();
        }
        return host + ":" + defaultPort;
    }

    public static NodeInfo getNodeInfo(String host) {
        VirtualDNS.reload();
        NodeInfo real = nodeInfoMap.get(host);
        return real != null ? real : new NodeInfo(host, JeusPort.JeusBase);
    }

    public static String getHostName(String nodeName) {
        VirtualDNS.reload();
        NodeInfo real_host = nodeInfoMap.get(nodeName);
        return real_host != null ? real_host.getHost() : nodeName;
    }

    public static String getVirtualNameFromServer(String real_node) {
        NodeControllerStub stub = new NodeControllerStub();
        try {
            stub.connectTo(real_node);
            String string = stub.getHostName();
            Object var4_4 = null;
            stub.disconnect();
            return string;
        }
        catch (JeusServerException e) {
            try {
                throw new JeusRuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                stub.disconnect();
                throw throwable;
            }
        }
    }

    public static void setLocalNode(String node) {
        NodeInfo nodeInfo = VirtualDNS.getNodeInfo(node);
        JeusPort.setBasePort(nodeInfo.getBasePort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        long currentTime = System.currentTimeMillis();
        if (vhostFileCheckTime == 0L) {
            vhostFileCheckTime = currentTime;
        }
        if (currentTime < vhostFileCheckTime) {
            return;
        }
        vhostFileCheckTime = currentTime + 300000L;
        Boolean bl = enabledBySystemProperty = JeusProperties.VHOST_ENABLED == null ? null : Boolean.valueOf(JeusProperties.VHOST_ENABLED);
        if (enabledBySystemProperty != null && !enabledBySystemProperty.booleanValue()) {
            return;
        }
        if (propertiesFile.exists()) {
            long modified = propertiesFile.lastModified();
            if (modified > lastModified) {
                lastModified = modified;
                Properties properties = new Properties();
                FileInputStream in = new FileInputStream(propertiesFile);
                try {
                    properties.load(in);
                    Object var8_5 = null;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    in.close();
                    throw throwable;
                }
                in.close();
                revers_dns.clear();
                nodeInfoMap.clear();
                try {
                    enabled = enabledBySystemProperty != null ? enabledBySystemProperty : Boolean.valueOf(properties.getProperty("jeus.vhost.enabled", "false"));
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "", (Throwable)ex);
                }
                if (enabled) {
                    Enumeration<?> keys = properties.propertyNames();
                    while (keys.hasMoreElements()) {
                        String key = ((String)keys.nextElement()).trim();
                        if (key.startsWith("jeus.vhost.")) continue;
                        this.addNode(properties.getProperty(key).trim(), key);
                    }
                }
            }
        } else {
            this.loadFromVhostXML();
        }
    }

    private static void reload() {
        try {
            vhostLoader.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addNode(String realNode, String virtualNode) throws UnknownHostException {
        NodeInfo nodeInfo = VirtualDNS.convertToNodeInfo(realNode);
        if (nodeInfo.getBasePort() != JeusPort.JeusBase) {
            useDifferentPorts = true;
        }
        revers_dns.put(new InetSocketAddress(nodeInfo.getHost(), nodeInfo.getBasePort()), virtualNode);
        nodeInfoMap.put(virtualNode, nodeInfo);
    }

    protected void loadFromVhostXML() throws Exception {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NodeInfo convertToNodeInfo(String host) {
        int idx;
        String node;
        if (host.charAt(0) == '[') {
            if (!host.contains("]")) throw new IllegalArgumentException("Invalid ipv6 address expression");
            int bracketIndex = host.indexOf("]");
            node = host.substring(1, bracketIndex);
            idx = host.indexOf(":", bracketIndex);
        } else {
            idx = host.indexOf(":");
            node = host.substring(0, idx);
        }
        int port = idx == -1 ? JeusPort.JeusBase : Integer.parseInt(host.substring(idx + 1));
        return new NodeInfo(node, port);
    }

    private static InetSocketAddress convertToSocketAddress(String host) {
        NodeInfo nodeInfo = VirtualDNS.convertToNodeInfo(host);
        return new InetSocketAddress(nodeInfo.getHost(), nodeInfo.getBasePort());
    }

    public static NodeInfo parseAddress(String address) {
        return VirtualDNS.parseAddress(address, JeusPort.JeusBase);
    }

    public static NodeInfo parseAddress(String address, int baseport) {
        return VirtualDNS.parseAddress(address, baseport, -1);
    }

    public static NodeInfo parseAddress(String address, int baseport, int type) {
        return VirtualDNS.parseAddress(address, baseport, null, type);
    }

    public static NodeInfo parseAddress(String address, String virtualID) {
        return VirtualDNS.parseAddress(address, virtualID, -1);
    }

    public static NodeInfo parseAddress(String address, String virtualID, int type) {
        return VirtualDNS.parseAddress(address, JeusPort.JeusBase, virtualID, type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NodeInfo parseAddress(String address, int baseport, String virtualID, int type) {
        int port;
        String host;
        if (address.contains("[")) {
            if (!address.contains("]")) throw new IllegalArgumentException("Invalid ipv6 expression");
            int idx = address.indexOf("]");
            host = address.substring(address.indexOf("[") + 1, idx);
            if (!IPAddressFormat.isIPv6LiteralAddress(host)) {
                throw new IllegalArgumentException("Invalid ipv6 expression");
            }
            port = address.indexOf(":", idx + 1) >= 0 ? Integer.parseInt(address.substring(address.lastIndexOf(":") + 1)) : baseport;
            return new NodeInfo(host, port, virtualID, type);
        }
        if (address.contains(":")) {
            int idx = address.indexOf(":");
            host = address.substring(0, idx);
            if (!IPAddressFormat.isIPv4LiteralAddress(host)) {
                try {
                    host = InetAddress.getByName(host).getHostAddress();
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            port = Integer.parseInt(address.substring(idx + 1));
            return new NodeInfo(host, port, virtualID, type);
        }
        VirtualDNS.reload();
        NodeInfo real = nodeInfoMap.get(address);
        if (real != null) {
            host = real.getHost();
            port = real.getBasePort();
            return new NodeInfo(host, port, virtualID, type);
        } else {
            if (!IPAddressFormat.isIPv4LiteralAddress(address)) {
                try {
                    host = InetAddress.getByName(address).getHostAddress();
                }
                catch (UnknownHostException e) {
                    host = address;
                }
            } else {
                host = address;
            }
            port = baseport;
        }
        return new NodeInfo(host, port, virtualID, type);
    }

    static {
        vhostFileCheckTime = 0L;
        propertiesFile = new File(JeusProperties.VHOST_PROPERTIES_PATH);
        nodeInfoMap = new Hashtable();
        revers_dns = new Hashtable();
        logger = (JeusLogger)JeusLogger.getLogger("jeus");
        try {
            Class<?> c = VirtualDNS.class.getClassLoader().loadClass("jeus.util.ServerVirtualDNS");
            vhostLoader = (VirtualDNS)c.newInstance();
        }
        catch (Exception e) {
            vhostLoader = new VirtualDNS();
        }
        try {
            vhostLoader.load();
            LOCAL_VIRTUALNAME = revers_dns.get(new InetSocketAddress(InetAddress.getByName(JeusNetPropertyValues.LOCAL_HOSTNAME), JeusPort.JeusBase));
            if (LOCAL_VIRTUALNAME == null && (LOCAL_VIRTUALNAME = revers_dns.get(new InetSocketAddress(InetAddress.getByName(JeusNetPropertyValues.LOCAL_HOSTADDRESS), JeusPort.JeusBase))) == null && (LOCAL_VIRTUALNAME = revers_dns.get(new InetSocketAddress(InetAddress.getByName(JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS), JeusPort.JeusBase))) == null) {
                if (JeusPropertyValues.JEUS_CATEGORY != 0) {
                    if (nodeInfoMap.get(JeusNetPropertyValues.LOCAL_HOSTNAME) != null) {
                        throw new JeusRuntimeException("may be configuration format error; please confirm that vhost.properties is written properly");
                    }
                    if (useDifferentPorts) {
                        throw new JeusRuntimeException("can't find the matching host information[" + JeusNetPropertyValues.LOCAL_HOSTNAME + ":" + JeusPort.JeusBase + "] from vhost.properties");
                    }
                }
                LOCAL_VIRTUALNAME = JeusNetPropertyValues.LOCAL_HOSTNAME;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new JeusRuntimeException(ex);
        }
    }
}

