/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.cnet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import jeus.util.ByteUtil;
import jeus.util.JeusSocket;
import jeus.util.cnet.DestinationNotFoundException;
import jeus.util.cnet.SockPassConstants;

public class SocketProxy
implements SockPassConstants {
    public static Socket getConnection(String host, int port, String virtualPort, int connectionTimeout, boolean isJavaChannel) throws IOException {
        return SocketProxy.getConnection(host, port, null, 0, virtualPort, connectionTimeout, isJavaChannel, (SSLSocketFactory)null, 20000);
    }

    public static Socket getConnection(String host, int port, String localHost, int localPort, String virtualPort, int connectionTimeout, boolean isJavaChannel, int connectionSoTimeout) throws IOException {
        return SocketProxy.getConnection(host, port, localHost, localPort, virtualPort, connectionTimeout, isJavaChannel, (SSLSocketFactory)null, connectionSoTimeout);
    }

    public static Socket getConnection(String host, int port, String localHost, int localPort, String virtualPort, int connectionTimeout, boolean isJavaChannel, SSLContext sslContext, int connectionSoTimeout) throws IOException {
        return SocketProxy.getConnection(host, port, localHost, localPort, virtualPort, connectionTimeout, isJavaChannel, sslContext != null ? sslContext.getSocketFactory() : null, connectionSoTimeout);
    }

    public static Socket getConnection(String host, int port, String localHost, int localPort, String virtualPort, int connectionTimeout, boolean isJavaChannel, SSLSocketFactory sslSocketFactory, int connectionSoTimeout) throws IOException {
        Socket socket = null;
        try {
            socket = JeusSocket.getConnection(host, port, localHost, localPort, connectionTimeout, isJavaChannel, sslSocketFactory);
            if (connectionSoTimeout <= 0) {
                connectionSoTimeout = 20000;
            }
            int beforeSoTimeout = socket.getSoTimeout();
            socket.setSoTimeout(connectionSoTimeout);
            OutputStream out = socket.getOutputStream();
            byte[] buf = SocketProxy.makePacket((byte)100, virtualPort);
            out.write(buf);
            out.flush();
            InputStream in = socket.getInputStream();
            int status = in.read();
            switch (status) {
                case 1: {
                    socket.setSoTimeout(beforeSoTimeout);
                    return socket;
                }
                case 2: {
                    throw new DestinationNotFoundException("destination not found. host = " + host + ", port = " + port + ", id = " + virtualPort);
                }
            }
            throw new IOException("connection failed. host = " + host + ", port = " + port + ", id = " + virtualPort);
        }
        catch (IOException ie) {
            SocketProxy.closeSocket(socket);
            throw ie;
        }
    }

    private static void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.shutdownInput();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            socket.shutdownOutput();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] makePacket(byte opcode, String body) {
        byte[] bodybuf = body.getBytes();
        int bodylen = bodybuf.length;
        byte[] buf = new byte[12 + bodylen];
        System.arraycopy(MAGIC, 0, buf, 0, 7);
        buf[7] = opcode;
        ByteUtil.putInt(buf, 8, bodylen);
        System.arraycopy(bodybuf, 0, buf, 12, bodylen);
        return buf;
    }
}

