/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.cnet.classftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Map;
import jeus.util.cnet.SocketProxy;
import jeus.util.cnet.classftp.ClassFTPProtocol;

public class ClassFTPConnection
extends URLConnection
implements ClassFTPProtocol {
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private boolean connected;
    private Hashtable headers = new Hashtable();

    public ClassFTPConnection(URL url) {
        super(url);
    }

    public synchronized void connect() throws IOException {
        URL u = this.getURL();
        this.socket = SocketProxy.getConnection(u.getHost(), u.getPort() - 3, "" + u.getPort(), -1, false);
        this.connected = true;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.out != null) {
            return this.out;
        }
        if (!this.connected) {
            this.connect();
        }
        String path = this.url.getFile();
        byte[] request = path.getBytes();
        int len = request.length;
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
        DataOutputStream dout = new DataOutputStream(this.out);
        dout.writeInt(69402625);
        dout.writeInt(len);
        dout.write(request);
        dout.flush();
        return this.out;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.in != null) {
            return this.in;
        }
        if (!this.connected) {
            this.connect();
        }
        this.getOutputStream();
        this.in = new BufferedInputStream(this.socket.getInputStream());
        DataInputStream din = new DataInputStream(this.in);
        int opcode = din.readInt();
        if (opcode != 69402881) {
            this.close();
            throw new IOException("invalid response code : " + opcode);
        }
        int length = din.readInt();
        this.headers.put("content-length", "" + length);
        this.headers.put("content-type", "text/plain");
        return this.in;
    }

    public String getHeaderField(String name) {
        if (name == null) {
            return null;
        }
        return (String)this.headers.get(name);
    }

    public Map getHeaderFields() {
        return this.headers;
    }

    private synchronized void close() {
        if (this.connected) {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.socket != null) {
                this.closeSocket();
            }
            this.connected = false;
            this.socket = null;
            this.in = null;
        }
    }

    private void closeSocket() {
        try {
            this.socket.shutdownInput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

