/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent50;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import jeus.util.concurrent50.concurrent.ThreadFactory;

public class ThreadPoolThreadFactory
implements ThreadFactory {
    protected final String namePrefix;
    protected final AtomicInteger threadNumber = new AtomicInteger(1);
    protected final boolean isDaemon;

    public ThreadPoolThreadFactory(String namePrefix, boolean isDaemon) {
        this.namePrefix = namePrefix;
        this.isDaemon = isDaemon;
    }

    public Thread newThread(final Runnable r) {
        Thread t = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread t = new Thread(r, ThreadPoolThreadFactory.this.namePrefix + "-" + ThreadPoolThreadFactory.this.threadNumber.getAndIncrement());
                t.setDaemon(ThreadPoolThreadFactory.this.isDaemon);
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                t.setContextClassLoader(ThreadPoolThreadFactory.class.getClassLoader());
                return t;
            }
        });
        return t;
    }
}

