/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.config;

import java.util.Map;
import java.util.Properties;

public abstract class Config
extends Properties {
    public void load(Properties props) {
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String name = (String)e.getKey();
            if (!this.accept(name)) continue;
            this.setProperty(name, (String)e.getValue());
        }
    }

    protected abstract boolean accept(String var1);

    public synchronized Object setProperty(String key, String value) {
        if (value == null) {
            return null;
        }
        return super.setProperty(key, value);
    }

    public void setBooleanProperty(String name, boolean value) {
        super.setProperty(name, String.valueOf(value));
    }

    public void setShortProperty(String name, short value) {
        super.setProperty(name, String.valueOf(value));
    }

    public void setIntProperty(String name, int value) {
        super.setProperty(name, String.valueOf(value));
    }

    public void setLongProperty(String name, long value) {
        super.setProperty(name, String.valueOf(value));
    }

    public void setFloatProperty(String name, float value) {
        super.setProperty(name, String.valueOf(value));
    }

    public void setDoubleProperty(String name, double value) {
        super.setProperty(name, String.valueOf(value));
    }

    public String getProperty(String key) {
        String value = super.getProperty(key);
        if (value != null) {
            return value.trim();
        }
        return value;
    }

    public boolean getBooleanProperty(String name) {
        String value = this.getProperty(name);
        return Boolean.valueOf(value);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public short getShortProperty(String name) {
        return this.getShortProperty(name, (short)0);
    }

    public short getShortProperty(String name, short defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Short.parseShort(value);
    }

    public int getIntProperty(String name) {
        return this.getIntProperty(name, 0);
    }

    public int getIntProperty(String name, int defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public long getLongProperty(String name) {
        String value = this.getProperty(name);
        return Long.parseLong(value);
    }

    public long getLongProperty(String name, long defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public float getFloatProperty(String name) {
        String value = this.getProperty(name);
        return Float.parseFloat(value);
    }

    public float getFloatProperty(String name, float defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Float.parseFloat(value);
    }

    public double getDoubleProperty(String name) {
        String value = this.getProperty(name);
        return Double.parseDouble(value);
    }
}

