/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileCompare {
    private static final int MAX_BYTES = 2048;

    private FileCompare() {
    }

    public static boolean equals(String filename, String dir1, String dir2) throws IOException {
        return FileCompare.equals(new File(new File(dir1), filename), new File(new File(dir2), filename));
    }

    public static boolean equals(String file1, String file2) throws IOException {
        return FileCompare.equals(new File(file1), new File(file2));
    }

    public static boolean equals(File f1, File f2) throws IOException {
        String filenames = "[" + f1.getPath() + "], [" + f2.getPath() + "]";
        if (f1 == null || f2 == null || !f1.exists() || !f2.exists()) {
            throw new IllegalArgumentException("One or both files doesn't exist: " + filenames);
        }
        if (!f1.isFile() || !f2.isFile()) {
            throw new IllegalArgumentException("One or both files isn't a normal file: " + filenames);
        }
        if (f1.length() != f2.length()) {
            return false;
        }
        return FileCompare.equals(new FileInputStream(f1), new FileInputStream(f2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(InputStream s1, InputStream s2) throws IOException {
        boolean bl3;
        block7: {
            boolean bl2;
            block6: {
                boolean bl;
                block5: {
                    if (s1.available() != s2.available()) {
                        return false;
                    }
                    byte[] b1 = new byte[2048];
                    byte[] b2 = new byte[2048];
                    try {
                        int num1;
                        do {
                            int num2;
                            if ((num1 = s1.read(b1)) != (num2 = s2.read(b2))) {
                                bl = false;
                                Object var8_9 = null;
                                break block5;
                            }
                            if (num1 > 0) continue;
                            bl2 = true;
                            break block6;
                        } while (FileCompare.equals(num1, b1, b2));
                        bl3 = false;
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        s1.close();
                        s2.close();
                        b1 = null;
                        b2 = null;
                        throw throwable;
                    }
                }
                s1.close();
                s2.close();
                return bl;
            }
            Object var8_10 = null;
            s1.close();
            s2.close();
            return bl2;
        }
        Object var8_11 = null;
        s1.close();
        s2.close();
        return bl3;
    }

    private static boolean equals(int num, byte[] b1, byte[] b2) {
        for (int i = 0; i < num; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            boolean same = false;
            same = args.length == 2 ? FileCompare.equals(args[0], args[1]) : FileCompare.equals(args[0], args[1], args[2]);
            if (same) {
                System.out.println("Files are equal");
            } else {
                System.out.println("Files are NOT equal");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

