/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.util.OS;
import jeus.util.StringUtil;
import jeus.util.file.FileListerRelative;
import jeus.util.file.NativeResults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private static String FS = File.separator;
    private static String EXTRACT_DIR_SEPARATOR = "___";
    private static final int BUFFER_SIZE = 65536;
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{':', '*', '?', '\"', '<', '>', '|'};
    private static final String ILLEGAL_FILENAME_STRING = "\\/:*?\"<>|";
    private static final char REPLACEMENT_CHAR = '_';
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static String TMPFILENAME = "scratch";

    public static native int recursiveChownNative(String var0, String var1);

    public static native int recursiveChownNative(String var0);

    public static native int recursiveChmodNative(String var0, String var1);

    private FileUtils() {
    }

    public static boolean safeIsDirectory(File f) {
        return f != null && f.exists() && f.isDirectory();
    }

    public static boolean safeIsRealDirectory(String s) {
        return FileUtils.safeIsRealDirectory(new File(s));
    }

    public static boolean safeIsRealDirectory(File f) {
        String absolute;
        if (!FileUtils.safeIsDirectory(f)) {
            return false;
        }
        String canonical = FileUtils.safeGetCanonicalPath(f);
        if (canonical.equals(absolute = f.getAbsolutePath())) {
            return true;
        }
        return OS.isWindows() && canonical.equalsIgnoreCase(absolute);
    }

    public static boolean safeIsDirectory(String s) {
        return FileUtils.safeIsDirectory(new File(s));
    }

    public static String safeGetCanonicalPath(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public static File safeGetCanonicalFile(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    public static boolean isEar(String filename) {
        return FileUtils.hasExtension(filename, ".ear");
    }

    public static boolean isJar(String filename) {
        return FileUtils.hasExtension(filename, ".jar");
    }

    public static boolean isZip(String filename) {
        return FileUtils.hasExtensionIgnoreCase(filename, ".zip");
    }

    public static boolean isArchive(String filename) {
        return FileUtils.isWar(filename) || FileUtils.isRar(filename) || FileUtils.isJar(filename) || FileUtils.isZip(filename) || FileUtils.isEar(filename);
    }

    public static boolean isArchive(File f) {
        return FileUtils.isWar(f) || FileUtils.isRar(f) || FileUtils.isJar(f) || FileUtils.isZip(f) || FileUtils.isEar(f);
    }

    public static boolean isWar(String filename) {
        return FileUtils.hasExtension(filename, ".war");
    }

    public static boolean isRar(String filename) {
        return FileUtils.hasExtension(filename, ".rar");
    }

    public static boolean isEar(File f) {
        return FileUtils.hasExtension(f, ".ear");
    }

    public static boolean isJar(File f) {
        return FileUtils.hasExtension(f, ".jar");
    }

    public static boolean isZip(File f) {
        return FileUtils.hasExtensionIgnoreCase(f, ".zip");
    }

    public static boolean isWar(File f) {
        return FileUtils.hasExtension(f, ".war");
    }

    public static boolean isRar(File f) {
        return FileUtils.hasExtension(f, ".rar");
    }

    public static boolean hasExtension(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.endsWith(ext);
    }

    public static boolean hasExtension(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().endsWith(ext);
    }

    public static boolean hasExtensionIgnoreCase(String filename, String ext) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        return filename.toLowerCase().endsWith(ext.toLowerCase());
    }

    public static boolean hasExtensionIgnoreCase(File f, String ext) {
        if (f == null || !f.exists()) {
            return false;
        }
        return f.getName().toLowerCase().endsWith(ext.toLowerCase());
    }

    public static boolean isLegalFilename(String filename) {
        if (!FileUtils.isValidString(filename)) {
            return false;
        }
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFriendlyFilename(String filename) {
        if (!FileUtils.isValidString(filename)) {
            return false;
        }
        if (filename.indexOf(32) >= 0 || filename.indexOf(46) >= 0) {
            return false;
        }
        return FileUtils.isLegalFilename(filename);
    }

    public static String makeLegalFilename(String filename) {
        if (FileUtils.isLegalFilename(filename)) {
            return filename;
        }
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            filename = filename.replace(ILLEGAL_FILENAME_CHARS[i], '_');
        }
        return filename;
    }

    public static String makeFriendlyFileName(String filename) {
        return FileUtils.makeFriendlyFilename(filename);
    }

    public static String makeFriendlyFilename(String filename) {
        if (FileUtils.isFriendlyFilename(filename)) {
            return filename;
        }
        String ret = FileUtils.makeLegalFilename(filename).replace(' ', '_');
        ret = ret.replace('.', '_');
        return ret;
    }

    public static String makeFriendlyFilenameNoExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index > 0) {
            filename = filename.substring(0, index);
        }
        return FileUtils.makeFriendlyFilename(filename);
    }

    public static String makeFriendlyFileNameNoExtension(String filename) {
        return FileUtils.makeFriendlyFilenameNoExtension(filename);
    }

    public static void liquidate(File parent) {
        FileUtils.whack(parent);
    }

    public static void whack(File parent) {
        if (FileUtils.safeIsRealDirectory(parent)) {
            File[] kids = parent.listFiles();
            for (int i = 0; i < kids.length; ++i) {
                File f = kids[i];
                if (f.isDirectory()) {
                    FileUtils.whack(f);
                }
                if (f.delete()) continue;
                f.deleteOnExit();
            }
        }
        parent.delete();
    }

    public static File getDirectory(File f) {
        String filename = f.getAbsolutePath();
        return new File(new File(filename).getParent());
    }

    public static File createTempFile(File directory) {
        File f = null;
        try {
            f = File.createTempFile(TMPFILENAME, "jar", directory);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        f.deleteOnExit();
        return f;
    }

    public static File[] listAllFiles(File dirName, String ext) {
        File[] target = null;
        List list = FileUtils.searchDir(dirName, ext);
        if (list != null && list.size() > 0) {
            target = new File[list.size()];
            target = list.toArray(target);
        }
        return target;
    }

    public static List searchDir(File dirName, String ext) {
        ArrayList<File> targetList = null;
        if (dirName.isDirectory()) {
            targetList = new ArrayList<File>();
            File[] list = dirName.listFiles();
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    targetList.addAll(FileUtils.searchDir(list[i], ext));
                    continue;
                }
                String name = list[i].toString();
                if (!FileUtils.hasExtension(name, ext)) continue;
                targetList.add(list[i]);
            }
        }
        return targetList;
    }

    public static void copy(String from, String to) throws IOException {
        if (from == null || to == null) {
            throw new IllegalArgumentException("null or empty filename argument");
        }
        File fin = new File(from);
        File fout = new File(to);
        FileUtils.copy(fin, fout);
    }

    public static void copy(File fin, File fout) throws IOException {
        if (FileUtils.safeIsDirectory(fin)) {
            FileUtils.copyTree(fin, fout);
            return;
        }
        if (!fin.exists()) {
            throw new IllegalArgumentException("File source doesn't exist");
        }
        if (fout.getParentFile() == null) {
            throw new IllegalArgumentException("File destination doesn't exist");
        }
        if (!FileUtils.safeIsDirectory(fout.getParentFile())) {
            fout.getParentFile().mkdirs();
        }
        try {
            FileUtils.copy(new FileInputStream(fin), new FileOutputStream(fout));
        }
        catch (FileNotFoundException fe) {
            throw new IllegalArgumentException("File source or destination doesn't exist");
        }
    }

    public static void copyTree(File din, File dout) throws IOException {
        if (!FileUtils.safeIsDirectory(din)) {
            throw new IllegalArgumentException("Source isn't a directory");
        }
        dout.mkdirs();
        if (!FileUtils.safeIsDirectory(dout)) {
            throw new IllegalArgumentException("Can't create destination directory");
        }
        FileListerRelative flr = new FileListerRelative(din);
        String[] files = flr.getFiles();
        for (int i = 0; i < files.length; ++i) {
            File fin = new File(din, files[i]);
            File fout = new File(dout, files[i]);
            FileUtils.copy(fin, fout);
        }
    }

    public static void copy(InputStream inStream, OutputStream outStream) throws IOException {
        FileUtils.copyWithoutClose(inStream, outStream);
        inStream.close();
        outStream.close();
    }

    public static void copyWithoutClose(InputStream inStream, OutputStream outStream) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(inStream, 65536);
        BufferedOutputStream bos = new BufferedOutputStream(outStream, 65536);
        byte[] buf = new byte[65536];
        int len = 0;
        while (len != -1) {
            try {
                len = bis.read(buf, 0, buf.length);
            }
            catch (EOFException eof) {
                break;
            }
            if (len == -1) continue;
            bos.write(buf, 0, len);
        }
        bos.flush();
    }

    public static String makeForwardSlashes(String inputStr) {
        if (inputStr == null) {
            throw new IllegalArgumentException("null String FileUtils.makeForwardSlashes");
        }
        return inputStr.replace('\\', '/');
    }

    public static String getIllegalFilenameCharacters() {
        return ILLEGAL_FILENAME_STRING;
    }

    public static String recursiveChown(File dirOrFile) throws IOException {
        return FileUtils.recursiveChown(dirOrFile, null);
    }

    public static String recursiveChown(File dirOrFile, String user) throws IOException {
        if (dirOrFile == null || !dirOrFile.exists()) {
            throw new IOException("File doesn't exist: " + dirOrFile);
        }
        String fname = dirOrFile.getAbsolutePath();
        int ret = 0;
        ret = !FileUtils.isValidString(user) ? FileUtils.recursiveChownNative(fname) : FileUtils.recursiveChownNative(fname, user);
        NativeResults nr = new NativeResults(ret);
        IOException ne = nr.getResultException();
        if (ne == null) {
            return nr.getResultString();
        }
        throw ne;
    }

    public static String recursiveChmod(File dirOrFile, String permissions) throws IOException {
        if (dirOrFile == null || !dirOrFile.exists()) {
            throw new IOException("File doesn't exist: " + dirOrFile);
        }
        if (permissions == null) {
            throw new IOException("null permissions string.");
        }
        permissions = permissions.toLowerCase();
        FileUtils.verifyPermissions(permissions);
        int ret = FileUtils.recursiveChmodNative(dirOrFile.getAbsolutePath(), permissions);
        NativeResults nr = new NativeResults(ret);
        IOException ne = nr.getResultException();
        if (ne == null) {
            return nr.getResultString();
        }
        throw ne;
    }

    static boolean isValidString(String s) {
        return s != null && s.length() != 0;
    }

    public static File smartRename(File original) throws IOException {
        if (original == null) {
            throw new IllegalArgumentException("null argument");
        }
        String originalName = original.getAbsolutePath();
        if (!FileUtils.safeIsDirectory(original)) {
            throw new IOException("Directory doesn't exist: " + originalName);
        }
        String renamedName = originalName + "_old";
        File renamed = new File(renamedName);
        if (renamed.exists()) {
            FileUtils.whack(renamed);
            if (renamed.exists()) {
                for (int i = 0; i < 1000; ++i) {
                    String name = renamedName + i;
                    renamed = new File(name);
                    try {
                        FileUtils.whack(renamed);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (renamed.exists()) continue;
                    renamedName = name;
                    break;
                }
                if (renamed.exists()) {
                    throw new IOException("Tried 1000 possible rename directory names.  None worked!");
                }
            }
        }
        if (original.renameTo(renamed)) {
            return renamed;
        }
        FileUtils.copyTree(original, renamed);
        FileUtils.whack(original);
        return renamed;
    }

    private static void verifyPermissions(String per) throws IOException {
        if (per == null) {
            throw new IOException("null permissions string.");
        }
        if (per.length() != 9) {
            throw new IOException("permissions string must be exactly 9 characters long.  It is " + per.length() + " characters long.");
        }
        String err1 = "permissions string has a bad character ('";
        String err2 = "') at position #";
        String err3 = ".  Expected '-' or '";
        String err4 = "'";
        for (int i = 0; i < 9; ++i) {
            char c = per.charAt(i);
            int pos = i % 3;
            if (pos == 0) {
                if (c == 'r' || c == '-') continue;
                throw new IOException(err1 + c + err2 + (i + 1) + err3 + 'r' + err4);
            }
            if (pos == 1) {
                if (c == 'w' || c == '-') continue;
                throw new IOException(err1 + c + err2 + (i + 1) + err3 + 'w' + err4);
            }
            if (pos != 2 || c == 'x' || c == '-') continue;
            throw new IOException(err1 + c + err2 + (i + 1) + err3 + 'x' + err4);
        }
    }

    public static void appendText(String fileName, String line) throws RuntimeException {
        RandomAccessFile file = null;
        try {
            String MODE = "rw";
            file = new RandomAccessFile(fileName, "rw");
            file.seek(file.getFilePointer() + file.length());
            file.writeBytes(line);
        }
        catch (Exception e) {
            throw new RuntimeException("FileUtils.appendText()", e);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static void appendText(String fileName, StringBuffer buffer) {
        FileUtils.appendText(fileName, buffer.toString());
    }

    public static void main(String[] args) {
        try {
            System.out.println(FileUtils.smartRename(new File("C:/temp/test")));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        FileUtils.appendText("empty.txt", "text line");
    }

    public static boolean isDirectory(ZipEntry entry) {
        return entry.getName().endsWith("/") || entry.getName().endsWith(FS);
    }

    public static void copyFile(String source, String target, byte[] buffer) throws IOException {
        int len;
        File file = new File(target);
        if (file.getParent() != null) {
            new File(file.getParent()).mkdirs();
        }
        FileOutputStream outstr = new FileOutputStream(file);
        FileInputStream instr = new FileInputStream(new File(source));
        while ((len = ((InputStream)instr).read(buffer)) > 0) {
            ((OutputStream)outstr).write(buffer, 0, len);
        }
        ((InputStream)instr).close();
        ((OutputStream)outstr).close();
    }

    public static void checkUsingFile(String path) {
        File f1;
        File f = new File(path);
        if (f.exists()) {
            f1 = new File(path + ".bak");
            if (!f.renameTo(f1)) {
                throw new RuntimeException("The file is still used : " + f.getAbsolutePath());
            }
        } else {
            throw new RuntimeException("The NOT-existing file name : " + f.getAbsolutePath());
        }
        f1.renameTo(f);
    }

    public static void copyDirectory(String sourceRootDirName, String targetRootDirName) throws IOException {
        File sourceRootDirecoty = new File(sourceRootDirName);
        File targetRootDirectory = new File(targetRootDirName);
        FileUtils.copyDirectory(sourceRootDirecoty, targetRootDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(File sourceRootDirecoty, File targetRootDirectory) throws IOException {
        File[] fileList = sourceRootDirecoty.listFiles();
        if (!targetRootDirectory.exists()) {
            targetRootDirectory.mkdirs();
        }
        if (fileList == null) {
            Logger logger = Logger.getLogger("jeus.deploy");
            logger.log(Level.WARNING, sourceRootDirecoty.getAbsoluteFile() + " doesn't exist. cannot copy.");
        } else {
            for (int i = 0; i < fileList.length; ++i) {
                File file = fileList[i];
                if (file.isFile()) {
                    FileInputStream in = null;
                    FileOutputStream os = null;
                    try {
                        in = new FileInputStream(file.getAbsolutePath());
                        os = new FileOutputStream(targetRootDirectory + FS + file.getName());
                        ArchiveHelper.copy((InputStream)in, os);
                    }
                    catch (FileNotFoundException e) {
                    }
                    finally {
                        if (in != null) {
                            in.close();
                            in = null;
                        }
                        if (os != null) {
                            os.close();
                            os = null;
                        }
                    }
                    File f = new File(targetRootDirectory + FS + file.getName());
                    long lastModified = fileList[i].lastModified();
                    if (lastModified == -1L || f == null) continue;
                    f.setLastModified(lastModified);
                    continue;
                }
                File target = new File(targetRootDirectory + FS + file.getName());
                FileUtils.copyDirectory(file, target);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectoryExceptSpecifiedFiles(String sourceRootDirName, String targetRootDirName, ArrayList<String> exceptedFiles) throws IOException {
        File sourceRootDirecoty = new File(sourceRootDirName);
        File targetRootDirectory = new File(targetRootDirName);
        File[] fileList = sourceRootDirecoty.listFiles();
        if (!targetRootDirectory.exists()) {
            targetRootDirectory.mkdirs();
        }
        if (fileList == null) {
            Logger logger = Logger.getLogger("jeus.deploy");
            logger.log(Level.INFO, "[WARNING] " + sourceRootDirecoty.getAbsoluteFile() + " is not exist. cannot copy.");
        } else {
            for (int i = 0; i < fileList.length; ++i) {
                File file = fileList[i];
                boolean isExceptedFile = false;
                for (String anExceptedFile : exceptedFiles) {
                    if (!file.getName().trim().equals(anExceptedFile)) continue;
                    isExceptedFile = true;
                    break;
                }
                if (isExceptedFile) continue;
                if (file.isFile()) {
                    FileInputStream in = null;
                    FileOutputStream os = null;
                    try {
                        in = new FileInputStream(file.getAbsolutePath());
                        os = new FileOutputStream(targetRootDirectory + FS + file.getName());
                        ArchiveHelper.copy((InputStream)in, os);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        continue;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                            in = null;
                        }
                        if (os != null) {
                            os.close();
                            os = null;
                        }
                    }
                }
                File target = new File(targetRootDirectory + FS + file.getName());
                FileUtils.copyDirectory(file, target);
            }
        }
    }

    public static void copyDirectoryWithExtension(String sourceRootDirName, String targetRootDirName, String ext) throws IOException {
        File sourceRootDirecoty = new File(sourceRootDirName);
        File targetRootDirectory = new File(targetRootDirName);
        FileUtils.copyDirectoryWithExtension(sourceRootDirecoty, targetRootDirectory, ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectoryWithExtension(File sourceRootDirecoty, File targetRootDirectory, String ext) throws IOException {
        File[] fileList = sourceRootDirecoty.listFiles();
        if (!targetRootDirectory.exists()) {
            targetRootDirectory.mkdir();
        }
        if (fileList == null) {
            Logger logger = Logger.getLogger("jeus.deploy");
            logger.log(Level.INFO, "[WARNING] " + sourceRootDirecoty.getAbsoluteFile() + " is not exist. cannot copy.");
        } else {
            for (int i = 0; i < fileList.length; ++i) {
                File file = fileList[i];
                if (file.isFile() && file.getPath().endsWith(ext)) {
                    FileInputStream in = null;
                    FileOutputStream os = null;
                    try {
                        in = new FileInputStream(file.getAbsolutePath());
                        os = new FileOutputStream(targetRootDirectory + FS + file.getName());
                        ArchiveHelper.copy((InputStream)in, os);
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (in != null) {
                            in.close();
                            in = null;
                        }
                        if (os != null) {
                            os.close();
                            os = null;
                        }
                    }
                    long lastModifiedTime = file.lastModified();
                    File targetFile = new File(targetRootDirectory + FS + file.getName());
                    targetFile.setLastModified(lastModifiedTime);
                    continue;
                }
                if (!file.isDirectory()) continue;
                File target = new File(targetRootDirectory + FS + file.getName());
                FileUtils.copyDirectoryWithExtension(file, target, ext);
            }
        }
    }

    public static boolean deleteDirectoryRecursively(String directoryPath) throws IOException {
        return FileUtils.deleteDirectoryRecursively(new File(directoryPath));
    }

    public static boolean deleteDirectoryRecursively(File directory) throws IOException {
        FileUtils.deleteSubDirectories(directory);
        return directory.delete();
    }

    public static boolean deleteSubDirectories(File directory) throws IOException {
        if (!directory.isDirectory()) {
            throw new FileNotFoundException(directory.getPath());
        }
        File[] entries = directory.listFiles();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].isDirectory()) {
                FileUtils.deleteDirectoryRecursively(entries[i]);
                continue;
            }
            entries[i].delete();
        }
        return true;
    }

    public static String getPathWithoutExtension(String modulePath, String ext) {
        int index = modulePath.lastIndexOf(ext);
        if (index < 0) {
            return modulePath;
        }
        return modulePath.substring(0, index);
    }

    public static String getFileNameWithoutExtension(String filePath) {
        int pointIndex;
        int sepIndex = (filePath = StringUtil.normalizeFileSeparator(filePath)).lastIndexOf(FS);
        if (sepIndex >= 0) {
            filePath = filePath.substring(sepIndex + 1);
        }
        if ((pointIndex = filePath.lastIndexOf(".")) >= 0 && pointIndex < filePath.length() - 1) {
            filePath = filePath.substring(0, pointIndex);
        }
        return filePath;
    }

    public static String getFileNameWithoutExtension(String filePath, String ext) {
        int pointIndex;
        int sepIndex = (filePath = StringUtil.normalizeFileSeparator(filePath)).lastIndexOf(FS);
        if (sepIndex >= 0) {
            filePath = filePath.substring(sepIndex + 1);
        }
        if ((pointIndex = filePath.lastIndexOf(ext)) == filePath.length() - ext.length()) {
            filePath = filePath.substring(0, pointIndex);
        }
        return filePath;
    }

    public static String getPathWithExtension(String modulePath, String ext) {
        int index = modulePath.lastIndexOf(ext);
        if (index < 0) {
            return modulePath + ext;
        }
        return modulePath;
    }

    public static String getFileNameWithExtension(String filePath) {
        int sepIndex = (filePath = StringUtil.normalizeFileSeparator(filePath)).lastIndexOf(FS);
        if (sepIndex >= 0) {
            filePath = filePath.substring(sepIndex + 1);
        }
        return filePath;
    }

    public static String getFileNameFromPath(String modulePath) {
        int index = (modulePath = StringUtil.normalizeFileSeparator(modulePath)).lastIndexOf(FS);
        if (index > 0) {
            return modulePath.substring(index + 1);
        }
        return modulePath;
    }

    public static boolean isExploded(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return !FileUtils.isArchive(path);
        }
        return file.isDirectory();
    }

    public static boolean isExploded(String parentDir, String fileName) {
        return FileUtils.isExploded(parentDir + FS + fileName);
    }

    public static String[] separatePath(String path) {
        String[] temp = new String[2];
        int sepIndex = path.lastIndexOf(FS);
        if (sepIndex < 0) {
            temp[0] = ".";
            temp[1] = path;
        } else {
            temp[0] = path.substring(0, sepIndex);
            temp[1] = path.substring(sepIndex + 1);
        }
        return temp;
    }

    public static String[] separateDirAndFile(String path) {
        String[] temp = new String[2];
        File file = new File(path);
        String absolutePath = file.getAbsolutePath();
        int sepIndex = absolutePath.lastIndexOf(FS);
        if (sepIndex != -1) {
            temp[0] = absolutePath.substring(0, sepIndex);
            temp[1] = absolutePath.substring(sepIndex + 1);
        } else {
            File parentDir = new File(".");
            temp[0] = parentDir.getAbsolutePath();
            temp[1] = path;
        }
        return temp;
    }

    public static String getAbsolutePath(String path) {
        File file = new File(path);
        return file.getAbsolutePath();
    }

    public static String getExtractDirectoryName(String fileName) {
        return FileUtils.makeFriendlyFileName(FileUtils.getFileNameFromPath(fileName)) + EXTRACT_DIR_SEPARATOR;
    }

    public static String getExtractDirName(String fileName) {
        return FileUtils.makeFriendlyFileName(FileUtils.getFileNameFromPath(fileName));
    }

    public static String getExtractDirFromArchiveName(String archiveName) {
        return FileUtils.makeFriendlyFileName(FileUtils.getFileNameWithoutExtension(archiveName));
    }

    public static String getPathIncludedArchiveName(String pathIncludedExtractDirName, String ext) {
        String pathIncludecArchiveName = pathIncludedExtractDirName;
        int index = pathIncludedExtractDirName.lastIndexOf(EXTRACT_DIR_SEPARATOR);
        if (index >= 0) {
            pathIncludecArchiveName = pathIncludedExtractDirName.substring(0, index - 4);
        }
        if (!pathIncludecArchiveName.endsWith(ext)) {
            return pathIncludecArchiveName + ext;
        }
        return pathIncludecArchiveName;
    }

    public static void makeDirectories(File directory) {
        String path = directory.getAbsolutePath();
        path = path.substring(0, path.lastIndexOf(FS));
        File newDir = new File(path);
        newDir.mkdirs();
    }
}

