/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.file;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class Tee
extends PrintStream {
    static OutputStream logfile;
    static PrintStream oldStdout;
    static PrintStream oldStderr;

    private Tee(PrintStream ps) {
        super(ps);
    }

    public static void start(String f) throws IOException {
        oldStdout = System.out;
        oldStderr = System.err;
        logfile = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)));
        System.setOut(new Tee(System.out));
        System.setErr(new Tee(System.err));
    }

    public static void stop() {
        System.setOut(oldStdout);
        System.setErr(oldStderr);
        try {
            logfile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void write(int b) {
        try {
            logfile.write(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError();
        }
        super.write(b);
    }

    public void write(byte[] buf, int off, int len) {
        try {
            logfile.write(buf, off, len);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setError();
        }
        super.write(buf, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        try {
            try {
                Tee.start("log.txt");
                System.out.println("Here's is some stuff to stdout.");
                System.err.println("Here's is some stuff to stderr.");
                System.out.println("Let's throw an exception...");
                new Exception().printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var3_2 = null;
                Tee.stop();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Tee.stop();
            throw throwable;
        }
        Tee.stop();
    }
}

