/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.finder;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class FactoryFinder {
    private final String path;
    private final ConcurrentHashMap<String, Class> classMap = new ConcurrentHashMap();

    public FactoryFinder(String path) {
        this.path = path;
    }

    public Object newInstance(String key) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        return this.newInstance(key, null);
    }

    public Object newInstance(String key, String propertyPrefix) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException {
        Class clazz;
        if (propertyPrefix == null) {
            propertyPrefix = "";
        }
        if ((clazz = this.classMap.get(propertyPrefix + key)) == null) {
            clazz = this.newInstance(this.doFindFactoryProperies(key), propertyPrefix);
            this.classMap.put(propertyPrefix + key, clazz);
        }
        return clazz.newInstance();
    }

    private Class newInstance(Properties properties, String propertyPrefix) throws ClassNotFoundException, IOException {
        Class<?> clazz;
        String className = properties.getProperty(propertyPrefix + "class");
        if (className == null) {
            throw new IOException("Expected property is missing: " + propertyPrefix + "class");
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            clazz = FactoryFinder.class.getClassLoader().loadClass(className);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties doFindFactoryProperies(String key) throws IOException {
        InputStream in;
        String uri = this.path + key;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((in = classLoader.getResourceAsStream(uri)) == null && (in = FactoryFinder.class.getClassLoader().getResourceAsStream(uri)) == null) {
            throw new IOException("unable to find factory class for resource: " + uri);
        }
        BufferedInputStream reader = null;
        try {
            reader = new BufferedInputStream(in);
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

