/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.logging.ErrorManager;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import jeus.util.logging.LogFileRotator;
import jeus.util.logging.StreamHandler;

public class FileHandler
extends StreamHandler {
    private static final String DEFAULT_FORMAT = "yyyyMMdd";
    private static final int DEFAULT_BUFFER = 1024;
    private String dateFormat = "yyyyMMdd";
    private boolean append;
    private String pattern;
    private int bufferSize;
    private long nextChangeTime = Long.MAX_VALUE;
    private long fileExistenceCheckTime = Long.MAX_VALUE;
    private static final long checkPeriod = 600000L;
    private String name = this.getClass().getName() + "@" + this.hashCode();
    private File file;
    private int validHour;
    private int validDay;
    private int validSize;
    private String fileName;
    private long logFileLastModifiedTime;
    private boolean enableRotation;
    private int rotationCount;
    private String rotationDir;
    private LogFileRotator rotator;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getValidHour() {
        return this.validHour;
    }

    public int getValidDay() {
        return this.validDay;
    }

    public int getValidSize() {
        return this.validSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isEnableRotation() {
        return this.enableRotation;
    }

    public int getRotationCount() {
        return this.rotationCount;
    }

    public String getRotationDir() {
        return this.rotationDir;
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getFilePattern() {
        return this.pattern;
    }

    private void openFile() throws IOException {
        LogManager manager = LogManager.getLogManager();
        manager.checkAccess();
        InitializationErrorManager em = new InitializationErrorManager();
        this.setErrorManager(em);
        this.fileExistenceCheckTime = System.currentTimeMillis() + 600000L;
        this.open();
        Exception ex = em.lastException;
        if (ex != null) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof SecurityException) {
                throw (SecurityException)ex;
            }
            throw new IOException("Exception: " + ex);
        }
        this.setErrorManager(new ErrorManager());
    }

    protected void open() throws FileNotFoundException {
        Calendar currentCal = Calendar.getInstance();
        this.file = new File(this.fileName);
        this.logFileLastModifiedTime = this.rotator.setFile(this.file);
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
        }
        Calendar currentCalForRotation = (Calendar)currentCal.clone();
        this.nextChangeTime = this.rotator.getNextRotationTime(currentCalForRotation);
        if (this.enableRotation) {
            this.rotator.generate(currentCalForRotation);
        } else {
            this.file = this.getPatternedTime(this.pattern, currentCal);
        }
        FileOutputStream fout = new FileOutputStream(this.file.getAbsolutePath(), this.append);
        this.setOutputStream(fout, this.bufferSize < 0 ? 0 : this.bufferSize);
    }

    public File getPatternedTime(String pattern, Calendar currentCal) {
        File file = null;
        int previousCreateHourFraction = -1;
        String word = "";
        int ix = 0;
        boolean isCalendarUsed = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File(word) : new File(file, word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 'd') {
                    if (isCalendarUsed) {
                        throw new IllegalArgumentException("The %d should be at most one");
                    }
                    String parameter = this.getParamter(ix, pattern, ch2);
                    this.validDay = Integer.parseInt(parameter);
                    isCalendarUsed = true;
                    SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
                    String date = this.enableRotation ? format.format(new Date(this.logFileLastModifiedTime)) : format.format(currentCal.getTime());
                    word = word + date;
                    ix += parameter.length() + 3;
                    continue;
                }
                if (ch2 == 'h') {
                    if (previousCreateHourFraction >= 0) {
                        throw new IllegalArgumentException("The %h should be at most one");
                    }
                    String paramter = this.getParamter(ix, pattern, ch2);
                    this.validHour = Integer.parseInt(paramter);
                    int hour = this.validHour % 24;
                    if (24 % hour > 0) {
                        throw new IllegalArgumentException("The parameter of %h should be one of divisors for 24");
                    }
                    if (this.enableRotation) {
                        Calendar cal = (Calendar)currentCal.clone();
                        cal.setTimeInMillis(this.logFileLastModifiedTime);
                        previousCreateHourFraction = cal.get(11) / hour * hour;
                    } else {
                        previousCreateHourFraction = this.getCurrentTimeFraction(hour);
                    }
                    DecimalFormat formatter = new DecimalFormat("00");
                    String hourFractionString = formatter.format(previousCreateHourFraction);
                    word = word + hourFractionString;
                    ix += paramter.length() + 3;
                    continue;
                }
                if (ch2 == '%') {
                    word = word + "%";
                    ++ix;
                    continue;
                }
            }
            word = word + ch;
        }
        if (!isCalendarUsed && previousCreateHourFraction >= 0) {
            throw new IllegalArgumentException("The %h needs %d option");
        }
        if (word.length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    public int getCurrentTimeFraction(int hour) {
        Calendar cal = Calendar.getInstance();
        return cal.get(11) / hour * hour;
    }

    private String getParamter(int ix, String pattern, char option) {
        if (++ix >= pattern.length()) {
            throw new IllegalArgumentException("'{' should follow %" + option);
        }
        char ch2 = Character.toLowerCase(pattern.charAt(ix));
        if (ch2 != '{') {
            throw new IllegalArgumentException("'{' should follow %" + option);
        }
        StringBuffer simpleDataFormat = new StringBuffer();
        if (++ix < pattern.length()) {
            ch2 = Character.toLowerCase(pattern.charAt(ix));
        } else {
            throw new IllegalArgumentException("%" + option + "{} is not completed");
        }
        while (ch2 != '}') {
            simpleDataFormat.append(ch2);
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
                continue;
            }
            throw new IllegalArgumentException("%" + option + "{} is not completed");
        }
        return simpleDataFormat.toString();
    }

    public void setProperty(Map propertyMap) throws IOException {
        this.fileName = (String)propertyMap.get("fileName");
        this.pattern = (String)propertyMap.get("pattern");
        Object value = propertyMap.get("enableRotation");
        this.enableRotation = value == null ? false : (value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean((String)value));
        this.rotationDir = (String)propertyMap.get("rotationDir");
        if (this.enableRotation) {
            int index = this.pattern.lastIndexOf(File.separator);
            this.pattern = index < 0 ? this.rotationDir + this.pattern : this.rotationDir + this.pattern.substring(index);
        }
        this.rotationCount = (value = propertyMap.get("rotationCount")) == null ? 0 : (value instanceof Integer ? (Integer)value : Integer.parseInt((String)value));
        value = propertyMap.get("bufferSize");
        this.bufferSize = value == null ? 1024 : (value instanceof Integer ? (Integer)value : Integer.parseInt((String)value));
        value = propertyMap.get("validDay");
        this.validDay = value == null ? 0 : (value instanceof Integer ? (Integer)value : Integer.parseInt((String)value));
        value = propertyMap.get("validHour");
        this.validHour = value == null ? 0 : (value instanceof Integer ? (Integer)value : Integer.parseInt((String)value));
        value = propertyMap.get("validSize");
        this.validSize = value == null ? 0 : (value instanceof Integer ? (Integer)value : Integer.parseInt((String)value));
        value = propertyMap.get("append");
        this.append = value instanceof Boolean ? (Boolean)value : Boolean.valueOf((String)value);
        this.rotator = new LogFileRotator();
        this.rotator.initialize(this);
        this.openFile();
    }

    protected void makeLogFile() {
        if (!this.file.exists()) {
            try {
                this.close();
                this.open();
            }
            catch (FileNotFoundException e) {
                this.getErrorManager().error("Exception occured during creating log file", e, 4);
            }
            catch (IOException e) {
                this.getErrorManager().error("Exception occurred during close file output stream", e, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFileExist(long writtenByte, LogRecord record) throws FileNotFoundException {
        Calendar currentCal = Calendar.getInstance();
        long currentTime = System.currentTimeMillis();
        long logRecordTime = record.getMillis();
        this.rotator.increaseFileSize(writtenByte);
        if (currentTime > this.fileExistenceCheckTime) {
            this.fileExistenceCheckTime = currentTime + 600000L;
            this.makeLogFile();
        }
        if (logRecordTime > this.nextChangeTime) {
            FileHandler fileHandler = this;
            synchronized (fileHandler) {
                if (logRecordTime > this.nextChangeTime) {
                    this.open();
                }
            }
        } else if (this.enableRotation && this.validSize > 0 && this.rotator.isRotateBySize()) {
            this.rotator.generate(currentCal);
            FileOutputStream fout = new FileOutputStream(this.file.getAbsolutePath(), this.append);
            this.setOutputStream(fout, this.bufferSize);
        }
    }

    private class InitializationErrorManager
    extends ErrorManager {
        private Exception lastException;

        private InitializationErrorManager() {
        }

        public void error(String msg, Exception ex, int code) {
            this.lastException = ex;
        }
    }
}

