/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class JeusLogManager
extends LogManager {
    private static boolean disableReset = false;
    private Properties additionalProps = new Properties();

    public JeusLogManager() {
        try {
            Properties p = System.getProperties();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                if (propertyName.startsWith("jeus") || !propertyName.endsWith("log.level")) continue;
                this.additionalProps.setProperty(propertyName, System.getProperty(propertyName));
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void readConfiguration() throws IOException, SecurityException {
        if (disableReset) {
            throw new SecurityException();
        }
        super.readConfiguration();
    }

    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        if (disableReset) {
            throw new SecurityException();
        }
        super.readConfiguration(ins);
    }

    public void reset() throws SecurityException {
    }

    public void jeusReset() {
        super.reset();
    }

    public static void disableReset() {
        if (!JeusLogManager.checkLogManager()) {
            return;
        }
        disableReset = true;
    }

    public static void enableReset() {
        if (!JeusLogManager.checkLogManager()) {
            return;
        }
        disableReset = false;
    }

    private static boolean checkLogManager() {
        LogManager logManager = LogManager.getLogManager();
        return logManager instanceof JeusLogManager;
    }

    public void addJeusLoggingFileProperties(Properties addProperties) {
        this.additionalProps.putAll((Map<?, ?>)addProperties);
    }

    public synchronized boolean addLogger(Logger logger) {
        boolean add = super.addLogger(logger);
        if (add && !logger.getName().startsWith("jeus")) {
            this.setPredefinedLoggerLevel(logger);
        }
        return add;
    }

    private void setPredefinedLoggerLevel(Logger logger) {
        int ix;
        String loggerName = logger.getName();
        Level loggerLevel = this.getPredefinedLoggerLevel(loggerName);
        if (loggerLevel != null) {
            logger.setLevel(loggerLevel);
            return;
        }
        while ((ix = loggerName.lastIndexOf(".")) >= 0) {
            loggerLevel = this.getPredefinedLoggerLevel(loggerName = loggerName.substring(0, ix));
            if (loggerLevel == null) continue;
            Logger.getLogger(loggerName);
            break;
        }
    }

    private Level getPredefinedLoggerLevel(String loggerName) {
        if (this.additionalProps.isEmpty() || loggerName == null || loggerName.equals("")) {
            return null;
        }
        String logLevel = this.additionalProps.getProperty(loggerName + ".log.level");
        if (logLevel != null) {
            return Level.parse(logLevel);
        }
        logLevel = this.additionalProps.getProperty(loggerName + ".level");
        if (logLevel != null) {
            return Level.parse(logLevel);
        }
        return null;
    }

    private class Cleaner
    extends Thread {
        private Cleaner() {
        }

        public void run() {
        }
    }
}

