/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JeusLogRecord
extends LogRecord {
    protected static final ArrayList keys = new ArrayList();
    public static String JVM_ID = "client";
    private static ThreadLocal<Long> realThreadIds = new ThreadLocal();
    private long realThreadID;
    protected String jvmId = JVM_ID;
    private String formattedMessage;

    public JeusLogRecord(Level level, String msg) {
        super(level, msg);
        if (realThreadIds.get() == null) {
            realThreadIds.set(Thread.currentThread().getId());
            this.setThreadName();
        }
        this.realThreadID = realThreadIds.get();
    }

    private void setThreadName() {
        Thread t = Thread.currentThread();
        String name = t.getName() + " [" + JVM_ID + "-" + realThreadIds.get() + "]";
        t.setName(name);
    }

    public Map getLogInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("level", this.getLevel());
        map.put("message", this.getMessage());
        map.put("millis", new Long(this.getMillis()));
        map.put("loggerName", this.getLoggerName());
        map.put("threadID", this.getRealThreadID());
        return map;
    }

    public String getJvmId() {
        return this.jvmId;
    }

    public String getFormattedMessage(String formatter_id) {
        return this.formattedMessage;
    }

    public void setFormattedMessage(String formatter_id, String formattedMessage) {
        this.formattedMessage = formattedMessage;
    }

    public long getRealThreadID() {
        return this.realThreadID;
    }

    static {
        keys.add("level");
        keys.add("message");
        keys.add("millis");
        keys.add("loggerName");
        keys.add("threadID");
    }
}

