/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import jeus.util.JeusProperties;
import jeus.util.JeusRootClassLoader;
import jeus.util.StringUtil;
import jeus.util.VirtualDNS;
import jeus.util.logging.ConsoleHandler;
import jeus.util.logging.ErrorHandlerFactory;
import jeus.util.logging.FileHandler;
import jeus.util.logging.HandlerFactory;
import jeus.util.logging.JeusFormatter;
import jeus.util.logging.JeusHandler;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.SimpleFormatter;
import jeus.util.logging.SmtpHandler;
import jeus.util.logging.SocketHandler;
import jeus.util.properties.JeusManagerPropertyValues;
import jeus.util.properties.JeusPropertyValues;
import jeus.xml.binding.jeusDD.CommonHandlerType;
import jeus.xml.binding.jeusDD.ConsoleHandlerType;
import jeus.xml.binding.jeusDD.FileHandlerType;
import jeus.xml.binding.jeusDD.HandlerPropertySetType;
import jeus.xml.binding.jeusDD.HandlerType;
import jeus.xml.binding.jeusDD.LoggingLevelType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.PropertyType;
import jeus.xml.binding.jeusDD.SmtpHandlerType;
import jeus.xml.binding.jeusDD.SocketHandlerType;
import jeus.xml.binding.jeusDD.SystemLoggingType;
import jeus.xml.binding.jeusDD.UserHandlerType;

public class JeusLoggerConfiguration {
    public static final HashMap<String, String[]> defaultLoggerSetting = new HashMap();

    public static void setDefaultFilePath() {
        if (JeusPropertyValues.JEUS_CATEGORY == 1) {
            defaultLoggerSetting.put("jeus", new String[]{"JeusServer", VirtualDNS.LOCAL_VIRTUALNAME});
            defaultLoggerSetting.put("jeus.ejb", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE" + File.separator + "ejb"});
            defaultLoggerSetting.put("jeus.servlet", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE" + File.separator + "servlet" + File.separator + "errorlog"});
            defaultLoggerSetting.put("jeus.jms", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE" + File.separator + "jms"});
            defaultLoggerSetting.put("jeus.jms.access", new String[]{"access", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "jms"});
            defaultLoggerSetting.put("jeus.systemuser", new String[]{"UserLog", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE"});
            defaultLoggerSetting.put("jeus.webaccess", new String[]{"access", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE" + File.separator + "servlet" + File.separator + "accesslog"});
            defaultLoggerSetting.put("jeus.systemuser.webuser", new String[]{"user", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + "SYSTEM_ENGINE" + File.separator + "servlet" + File.separator + "userlog"});
        } else if (JeusPropertyValues.JEUS_CATEGORY == 2) {
            defaultLoggerSetting.put("jeus", new String[]{JeusManagerPropertyValues.containerName, VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName});
            defaultLoggerSetting.put("jeus.ejb", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "ejb"});
            defaultLoggerSetting.put("jeus.servlet", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "servlet" + File.separator + "errorlog"});
            defaultLoggerSetting.put("jeus.jms", new String[]{"error", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "jms"});
            defaultLoggerSetting.put("jeus.jms.access", new String[]{"access", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "jms"});
            defaultLoggerSetting.put("jeus.systemuser", new String[]{"UserLog", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName});
            defaultLoggerSetting.put("jeus.webaccess", new String[]{"access", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "servlet" + File.separator + "accesslog"});
            defaultLoggerSetting.put("jeus.systemuser.webuser", new String[]{"user", VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName + File.separator + "servlet" + File.separator + "userlog"});
        }
    }

    public static void setDefaultFilePath(String loggerName, String[] path) {
        defaultLoggerSetting.put(loggerName, path);
    }

    public static void setDefaultConsoleHandler(SystemLoggingType logging) throws JAXBException {
        HandlerType handlers = logging.getHandler();
        if (handlers == null) {
            ConsoleHandlerType handler = new ObjectFactory().createConsoleHandlerType();
            handler.setName("ConsoleHandler");
            handler.setLevel(LoggingLevelType.valueOf((String)Level.ALL.getName()));
            handlers = new ObjectFactory().createHandlerType();
            handlers.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(handler);
            logging.setHandler(handlers);
        }
    }

    public static void configLogger(Logger logger, SystemLoggingType logging) throws Throwable {
        JeusLoggerConfiguration.configLogger(logger, logging, new SimpleFormatter(), ErrorHandlerFactory.handlerFactory);
    }

    public static synchronized void configLogger(Logger logger, SystemLoggingType loggingType, JeusFormatter formatter, HandlerFactory factory) throws Throwable {
        int step = 0;
        boolean originUseParentHandlers = logger.getUseParentHandlers();
        Filter originFilter = logger.getFilter();
        Handler[] originHandlers = logger.getHandlers();
        Level originLevel = logger.getLevel();
        boolean setLevel = false;
        try {
            step = 1;
            SystemLoggingType cloneLoggingType = (SystemLoggingType)loggingType.cloneType();
            Boolean useParentHandler = cloneLoggingType.isUseParentHandlers();
            String loggerName = logger.getName();
            if (loggerName.equals("jeus")) {
                useParentHandler = false;
            }
            logger.setUseParentHandlers(useParentHandler);
            step = 2;
            ClassLoader loader = JeusRootClassLoader.loader;
            String filter = cloneLoggingType.getFilterClass();
            if (filter != null) {
                logger.setFilter((Filter)loader.loadClass(filter).newInstance());
            }
            step = 3;
            HandlerType handlerType = cloneLoggingType.getHandler();
            Level defaultLoggerLevel = Level.SEVERE;
            if (handlerType == null) {
                if (loggerName.equals("jeus")) {
                    ConsoleHandlerType handler = new ObjectFactory().createConsoleHandlerType();
                    handler.setName("ConsoleHandler");
                    handler.setLevel(LoggingLevelType.valueOf((String)Level.ALL.getName()));
                    JeusLoggerConfiguration.addConsoleHandler(logger, handler, formatter);
                }
            } else {
                List loggingHandlers = handlerType.getConsoleHandlerOrFileHandlerOrSmtpHandler();
                ArrayList<String> handlerNames = new ArrayList<String>();
                for (int i = 0; i < loggingHandlers.size(); ++i) {
                    CommonHandlerType loggingHandlerType = (CommonHandlerType)loggingHandlers.get(i);
                    String handlerName = loggingHandlerType.getName();
                    if (handlerName == null || handlerName.equals("") || handlerNames.contains(handlerName)) {
                        String className = handlerType.getClass().getName();
                        handlerName = className.substring(className.lastIndexOf(46) + 1) + "-" + i;
                        loggingHandlerType.setName(handlerName);
                    }
                    handlerNames.add(handlerName);
                    if (loggingHandlerType instanceof ConsoleHandlerType) {
                        JeusLoggerConfiguration.addConsoleHandler(logger, (ConsoleHandlerType)loggingHandlerType, formatter);
                    } else if (loggingHandlerType instanceof FileHandlerType) {
                        JeusLoggerConfiguration.addFileHandler(logger, (FileHandlerType)loggingHandlerType, null, null, formatter, factory);
                    } else if (loggingHandlerType instanceof SmtpHandlerType) {
                        JeusLoggerConfiguration.addSmtpHandler(logger, (SmtpHandlerType)loggingHandlerType, formatter);
                    } else if (loggingHandlerType instanceof SocketHandlerType) {
                        JeusLoggerConfiguration.addSocketHandler(logger, (SocketHandlerType)loggingHandlerType, formatter);
                    } else if (loggingHandlerType instanceof UserHandlerType) {
                        JeusLoggerConfiguration.addUserHandler(logger, (UserHandlerType)loggingHandlerType);
                    }
                    Level level = JeusLevel.parse(loggingHandlerType.getLevel().value());
                    if (level.intValue() >= defaultLoggerLevel.intValue()) continue;
                    defaultLoggerLevel = level;
                }
            }
            step = 4;
            if (originHandlers != null) {
                for (Handler originHandler : originHandlers) {
                    logger.removeHandler(originHandler);
                }
            }
            step = 5;
            if (JeusLogger.getPredefinedLevel(loggerName) == null) {
                JeusLoggerConfiguration.setConfiguredLevel(cloneLoggingType, logger);
                setLevel = true;
            }
            step = 6;
        }
        catch (Throwable t) {
            t.printStackTrace();
            switch (step) {
                case 5: 
                case 6: {
                    if (setLevel && originLevel != null) {
                        try {
                            logger.setLevel(originLevel);
                        }
                        catch (Throwable t1) {
                            // empty catch block
                        }
                    }
                }
                case 3: 
                case 4: {
                    Handler[] currentHandlers = logger.getHandlers();
                    if (currentHandlers != null) {
                        for (Handler currentHandler : currentHandlers) {
                            try {
                                logger.removeHandler(currentHandler);
                            }
                            catch (Throwable t1) {
                                // empty catch block
                            }
                        }
                    }
                    if (originHandlers != null) {
                        for (Handler originHandler : originHandlers) {
                            try {
                                logger.addHandler(originHandler);
                            }
                            catch (Throwable t1) {
                                // empty catch block
                            }
                        }
                    }
                }
                case 2: {
                    try {
                        logger.setFilter(originFilter);
                    }
                    catch (Throwable t1) {
                        // empty catch block
                    }
                }
                case 1: {
                    try {
                        logger.setUseParentHandlers(originUseParentHandlers);
                        break;
                    }
                    catch (Throwable t1) {
                        // empty catch block
                    }
                }
            }
            throw t;
        }
    }

    private static void setConfiguredLevel(SystemLoggingType loggingType, Logger logger) {
        String levelString = loggingType.getLevel().value();
        if (levelString != null && !"".equals(levelString)) {
            logger.setLevel(JeusLevel.parse(levelString));
        }
    }

    public static void addSmtpHandler(Logger logger, SmtpHandlerType smtpHandler, JeusFormatter formatter) throws Exception {
        SmtpHandler handler = new SmtpHandler();
        JeusLoggerConfiguration.setSmtpHandler(smtpHandler, handler, formatter);
        if (smtpHandler.isSetSendForAllMessages() && smtpHandler.isSendForAllMessages().booleanValue()) {
            logger.addHandler(handler);
        } else if (logger instanceof JeusLogger) {
            ((JeusLogger)logger).setSmtpHandler(handler);
        }
    }

    public static void setSmtpHandler(SmtpHandlerType handlerType, Handler handler, JeusFormatter formatter) throws Exception {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("mail.smtp.host", handlerType.getSmtpHostAddress());
        propertyMap.put("mail.from.address", handlerType.getFromAddress());
        propertyMap.put("mail.to.recipients", handlerType.getToAddress());
        propertyMap.put("mail.to.ccrecipients", handlerType.getCcAddress());
        propertyMap.put("mail.to.bccrecipients", handlerType.getBccAddress());
        Map formatterPropertyMap = Collections.EMPTY_MAP;
        JeusLoggerConfiguration.setCommonHandler((CommonHandlerType)handlerType, handler, propertyMap, formatter, formatterPropertyMap);
    }

    public static void addSocketHandler(Logger logger, SocketHandlerType socketHandler, JeusFormatter formatter) throws Exception {
        SocketHandler handler = new SocketHandler();
        JeusLoggerConfiguration.setSocketHandler(socketHandler, handler, formatter);
        logger.addHandler(handler);
    }

    public static void setSocketHandler(SocketHandlerType handlerType, Handler handler, JeusFormatter formatter) throws Exception {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("socket.host.addr", handlerType.getAddress());
        propertyMap.put("socket.host.port", handlerType.getPort());
        Map formatterPropertyMap = Collections.EMPTY_MAP;
        JeusLoggerConfiguration.setCommonHandler((CommonHandlerType)handlerType, handler, propertyMap, formatter, formatterPropertyMap);
    }

    private static void setHandlerSetting(Handler handler, Map propertyMap, JeusFormatter formatter, Map formatterPropertyMap, String level, String filter, String encoding) throws Exception {
        ((JeusHandler)handler).setProperty(propertyMap);
        formatter.setProperty(formatterPropertyMap);
        handler.setFormatter(formatter);
        if (level != null) {
            handler.setLevel(JeusLevel.parse(level));
        }
        if (filter != null) {
            handler.setFilter((Filter)JeusRootClassLoader.loader.loadClass(filter).newInstance());
        }
        if (encoding != null) {
            handler.setEncoding(encoding);
        }
    }

    public static void addConsoleHandler(Logger logger, ConsoleHandlerType handlerType, JeusFormatter formatter) throws Exception {
        ConsoleHandler handler = new ConsoleHandler();
        JeusLoggerConfiguration.setConsoleHandler(handlerType, handler, formatter);
        logger.addHandler(handler);
    }

    public static void setConsoleHandler(ConsoleHandlerType handlerType, Handler handler, JeusFormatter formatter) throws Exception {
        Map propertyMap = Collections.EMPTY_MAP;
        Map formatterPropertyMap = Collections.EMPTY_MAP;
        JeusLoggerConfiguration.setCommonHandler((CommonHandlerType)handlerType, handler, propertyMap, formatter, formatterPropertyMap);
    }

    private static void setCommonHandler(CommonHandlerType handlerType, Handler handler, Map propertyMap, JeusFormatter formatter, Map formatterPropertyMap) throws Exception {
        String level = null;
        String filter = null;
        String encoding = null;
        if (handlerType != null) {
            if (handlerType.getName() != null) {
                ((JeusHandler)handler).setName(handlerType.getName());
            }
            if (handlerType.getLevel() != null) {
                level = handlerType.getLevel().value();
            }
            filter = handlerType.getFilterClass();
            encoding = handlerType.getEncoding();
        }
        JeusLoggerConfiguration.setHandlerSetting(handler, propertyMap, formatter, formatterPropertyMap, level, filter, encoding);
    }

    public static void addFileHandler(Logger logger, FileHandlerType handlerType, String defaultDirectory, String defaultFileName, JeusFormatter formatter, HandlerFactory factory) throws Exception {
        String[] settings = defaultLoggerSetting.get(logger.getName());
        if (defaultDirectory == null) {
            defaultDirectory = settings != null ? settings[1] : (JeusManagerPropertyValues.containerName != null ? VirtualDNS.LOCAL_VIRTUALNAME + File.separator + JeusManagerPropertyValues.containerName : VirtualDNS.LOCAL_VIRTUALNAME);
        }
        if (defaultFileName == null) {
            defaultFileName = settings != null ? settings[0] : logger.getName();
        }
        FileHandler handler = factory.createFileHandler(formatter);
        JeusLoggerConfiguration.setFileHandler(handlerType, defaultDirectory, defaultFileName, handler, formatter);
        logger.addHandler(handler);
    }

    public static void setFileHandler(FileHandlerType handlerType, String defaultDirectory, String defaultFileName, Handler handler, JeusFormatter formatter) throws Exception {
        File dir;
        int day = handlerType.getValidDay() == null ? 0 : handlerType.getValidDay();
        int hour = handlerType.getValidHour() == null ? 0 : handlerType.getValidHour();
        int size = handlerType.getValidSize() == null ? 0 : handlerType.getValidSize();
        String fileName = handlerType.getFileName();
        String pattern = "";
        if (fileName == null) {
            int index;
            if (defaultDirectory != null && defaultFileName != null) {
                fileName = JeusProperties.JEUS_LOG_HOME + File.separator + defaultDirectory + File.separator + defaultFileName + ".log";
            }
            if ((index = fileName.lastIndexOf(".")) < 0) {
                index = fileName.length();
            }
            pattern = JeusLoggerConfiguration.attachTimePattern(day, fileName.substring(0, index), hour) + fileName.substring(index);
        } else if (fileName.indexOf("%d") < 0) {
            int index;
            File f = new File(fileName);
            if (!f.isAbsolute()) {
                fileName = JeusProperties.JEUS_LOG_HOME + File.separator + defaultDirectory + File.separator + fileName;
            }
            if ((index = fileName.lastIndexOf(".")) < 0) {
                index = fileName.length();
            }
            pattern = JeusLoggerConfiguration.attachTimePattern(day, fileName.substring(0, index), hour) + fileName.substring(index);
        }
        int rotationCount = handlerType.getRotationCount() == null ? 0 : handlerType.getRotationCount();
        String rotationDir = handlerType.getRotationDir();
        File file = new File(fileName);
        if (rotationDir == null) {
            rotationDir = file.getParent();
        }
        if (!(dir = new File(rotationDir)).isAbsolute()) {
            rotationDir = file.getParent() + File.separator + rotationDir;
        }
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        propertyMap.put("enableRotation", handlerType.isEnableRotation());
        propertyMap.put("rotationDir", rotationDir);
        propertyMap.put("rotationCount", rotationCount);
        propertyMap.put("fileName", fileName);
        propertyMap.put("pattern", pattern);
        propertyMap.put("bufferSize", handlerType.getBufferSize());
        propertyMap.put("append", handlerType.isAppend());
        if (day > 0) {
            propertyMap.put("validDay", day);
        } else if (hour > 0) {
            propertyMap.put("validHour", hour);
        } else if (size > 0) {
            propertyMap.put("validSize", size);
        }
        Map formatterPropertyMap = Collections.EMPTY_MAP;
        JeusLoggerConfiguration.setCommonHandler((CommonHandlerType)handlerType, handler, propertyMap, formatter, formatterPropertyMap);
    }

    private static String attachTimePattern(int day, String fileName, int hour) {
        if (day > 0) {
            fileName = fileName + "_%d{" + day + "}";
        } else if (hour > 0) {
            fileName = fileName + "_%d{1}_%h{" + hour + "}";
        }
        return fileName;
    }

    public static String detachTimePattern(int day, String fileName, int hour) {
        if (day > 0 || hour > 0) {
            int index = fileName.indexOf("_%d");
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public static void addUserHandler(Logger logger, UserHandlerType handlerType) throws Exception {
        String className = handlerType.getHandlerClass();
        Handler handler = (Handler)JeusRootClassLoader.loader.loadClass(className).newInstance();
        JeusLoggerConfiguration.setUserHandler(handlerType, handler);
        logger.addHandler(handler);
    }

    public static void setUserHandler(UserHandlerType handlerType, Handler handler) throws Exception {
        Map propertyMap = JeusLoggerConfiguration.makePropertyMap(handlerType.getHandlerProperty());
        Map formatterPropertyMap = JeusLoggerConfiguration.makePropertyMap(handlerType.getFormatterProperty());
        String formatterClass = handlerType.isSetFormatterClass() ? handlerType.getFormatterClass() : handlerType.getDefaultFormatterClass();
        JeusFormatter formatter = (JeusFormatter)JeusRootClassLoader.loader.loadClass(formatterClass).newInstance();
        JeusLoggerConfiguration.setCommonHandler((CommonHandlerType)handlerType, handler, propertyMap, formatter, formatterPropertyMap);
    }

    public static Map makePropertyMap(HandlerPropertySetType propertySet) {
        if (propertySet == null) {
            return Collections.EMPTY_MAP;
        }
        List property = propertySet.getProperty();
        HashMap<String, String> map = new HashMap<String, String>();
        for (PropertyType propertyType : property) {
            map.put(propertyType.getKey(), propertyType.getValue());
        }
        return map;
    }

    public static void replaceHandlers(Logger target, Logger source) {
        Handler[] oldHandlers = target.getHandlers();
        for (int i = 0; i < oldHandlers.length; ++i) {
            Handler oldHandler = oldHandlers[i];
            target.removeHandler(oldHandler);
        }
        Handler[] handlers = source.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            target.addHandler(handler);
        }
    }

    public static void printLoggerInformation(Logger logger) {
        StringBuffer buffer = new StringBuffer("***** logger name : ").append(logger.getName()).append(StringUtil.lineSeparator);
        buffer.append("\t logger level : ").append(logger.getLevel()).append(StringUtil.lineSeparator);
        Handler[] handlers = logger.getHandlers();
        buffer.append("\t logger handlers : ").append(handlers.length).append(StringUtil.lineSeparator);
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            buffer.append("\t\t handler toString() : ").append(handler).append(StringUtil.lineSeparator);
            buffer.append("\t\t handler class : ").append(handler.getClass()).append(StringUtil.lineSeparator);
            buffer.append("\t\t handler level : ").append(handler.getLevel()).append(StringUtil.lineSeparator);
        }
        buffer.append("\t use parent handler : ").append(logger.getUseParentHandlers()).append(StringUtil.lineSeparator);
        Logger parent = logger.getParent();
        buffer.append("\t parent logger : ").append(parent == null ? "null" : parent.getName()).append(StringUtil.lineSeparator);
        if (logger.getUseParentHandlers() && parent != null) {
            JeusLoggerConfiguration.printLoggerInformation(parent);
        }
    }
}

