/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import jeus.util.file.FileUtils;
import jeus.util.logging.FileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogFileRotator {
    private File file;
    private String fileName;
    private String pattern;
    private long logFileLastModifiedTime;
    private long nextChangeTime = Long.MAX_VALUE;
    private long fileSize;
    private int rotationCount;
    private String rotationDir;
    private int validHour;
    private int validDay;
    private int validSize;
    private boolean append;
    private FileHandler fileHandler;

    public void initialize(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
        this.fileName = fileHandler.getFileName();
        this.pattern = fileHandler.getFilePattern();
        this.rotationDir = fileHandler.getRotationDir();
        this.rotationCount = fileHandler.getRotationCount();
        this.validDay = fileHandler.getValidDay();
        this.validHour = fileHandler.getValidHour();
        this.validSize = fileHandler.getValidSize();
        this.append = fileHandler.isAppend();
    }

    public long setFile(File file) {
        this.file = file;
        if (file.exists()) {
            this.logFileLastModifiedTime = file.lastModified();
            this.fileSize = file.length();
        }
        return this.logFileLastModifiedTime;
    }

    public void generate(Calendar currentCal) throws FileNotFoundException {
        if (this.file.exists()) {
            this.fileHandler.close();
            if (this.validSize > 0) {
                this.rotateBySize();
            } else {
                this.rotateByDate(currentCal);
            }
        }
    }

    private void rotateBySize() {
        if (this.fileSize >= (long)(this.validSize * 1024) || !this.append) {
            File newFile = new File(this.rotationDir + File.separator + this.file.getName() + new DecimalFormat("00000").format(1L));
            this.rotate(newFile);
        }
    }

    private void rotateByDate(Calendar currentCal) {
        long period = 0L;
        period = this.validHour > 0 ? (long)(3600000 * this.validHour) : (long)(86400000 * this.validDay);
        if (this.nextChangeTime - this.logFileLastModifiedTime >= period || !this.append) {
            File newFile = this.fileHandler.getPatternedTime(this.pattern, currentCal);
            this.rotate(newFile);
        }
    }

    private void rotate(File newFile) {
        String newFileName = newFile.getName();
        if (!newFile.exists()) {
            newFile.getParentFile().mkdirs();
        }
        if (this.rotationDir.indexOf(this.file.getParent()) == 0) {
            File tempFile = this.makeBackupFile(this.file, newFile, true);
            if (!tempFile.exists()) {
                File rotationFile = new File(this.rotationDir + File.separator + newFileName);
                Thread copyFileThread = new Thread(new CopyLogFile(newFile, rotationFile, true));
                copyFileThread.start();
            }
        } else {
            File tempFile = new File(this.file.getParent() + File.separator + newFileName);
            if (tempFile.exists()) {
                tempFile.delete();
            }
            tempFile = this.makeBackupFile(this.file, tempFile, false);
            File rotationFile = new File(this.rotationDir + File.separator + tempFile.getName());
            Thread copyFileThread = new Thread(new CopyLogFile(tempFile, rotationFile, false));
            copyFileThread.start();
        }
    }

    private File makeBackupFile(File file, File newFile, boolean sameDir) {
        int i;
        SortedSet<File> sortedFileSet = this.getBackupFileList();
        ArrayList<File> sortedFileList = new ArrayList<File>();
        sortedFileList.addAll(sortedFileSet);
        String fileName = this.validSize > 0 ? file.getName() : newFile.getName();
        int index = 0;
        for (i = 1; i <= sortedFileList.size(); ++i) {
            String lastFileName = ((File)sortedFileList.get(sortedFileList.size() - i)).getName();
            String lastFileNameExceptIndex = lastFileName.substring(0, lastFileName.length() - 5);
            if (lastFileName.length() == fileName.length() + 5 && lastFileNameExceptIndex.equals(fileName)) {
                String indexStr = lastFileName.substring(lastFileName.length() - 5);
                try {
                    index = Integer.parseInt(indexStr) + 1;
                    break;
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            if (!fileName.equals(lastFileName)) continue;
            index = 1;
            break;
        }
        for (i = index; i <= 100000; ++i) {
            if (index > 0) {
                if (i == 100000) {
                    i = 1;
                }
                newFile = new File(newFile.getParent() + File.separator + fileName + new DecimalFormat("00000").format(i));
                if (index == 100000 && newFile.exists()) {
                    if (sortedFileSet.size() < 99999) continue;
                    newFile.delete();
                }
            }
            if (!sameDir) {
                File fileInRotationDir = new File(this.rotationDir + File.separator + fileName + new DecimalFormat("00000").format(i));
                if (fileInRotationDir.exists()) {
                    if (index != 100000 || sortedFileSet.size() < 99999) continue;
                    fileInRotationDir.delete();
                } else if (newFile.exists()) {
                    newFile.delete();
                }
            }
            if (!file.renameTo(newFile)) continue;
            if (sameDir) {
                sortedFileSet.add(newFile);
                while (this.rotationCount > 0 && sortedFileSet.size() > this.rotationCount) {
                    sortedFileSet.first().delete();
                    sortedFileSet.remove(sortedFileSet.first());
                }
            }
            this.resetLogFile();
            break;
        }
        return newFile;
    }

    public long getNextRotationTime(Calendar currentCal) {
        long currentTime = currentCal.getTimeInMillis();
        if (this.validSize > 0) {
            return this.nextChangeTime;
        }
        int previousCreateHourFraction = -1;
        if (this.validHour > 0) {
            previousCreateHourFraction = this.fileHandler.getCurrentTimeFraction(this.validHour % 24);
        }
        if (previousCreateHourFraction >= 0) {
            currentCal.set(currentCal.get(1), currentCal.get(2), currentCal.get(5), previousCreateHourFraction + this.validHour, 0, 0);
        } else {
            currentCal.set(currentCal.get(1), currentCal.get(2), currentCal.get(5) + this.validDay, 0, 0, 0);
        }
        currentCal.set(14, 0);
        long changeTime = currentCal.getTime().getTime();
        if (currentTime < changeTime) {
            this.nextChangeTime = changeTime;
        }
        return this.nextChangeTime;
    }

    private SortedSet<File> getBackupFileList() {
        TreeSet<File> fileSet = new TreeSet<File>(new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                long lastFileModifiedTime = file1.lastModified() - file2.lastModified();
                if (lastFileModifiedTime == 0L) {
                    return file1.equals(file2) ? 0 : 1;
                }
                return lastFileModifiedTime <= 0L ? -1 : 1;
            }
        });
        File dir = new File(this.rotationDir);
        if (dir.isDirectory()) {
            File[] files;
            for (File backupFile : files = dir.listFiles()) {
                fileSet.add(backupFile);
                if (backupFile.isDirectory() || backupFile.getName().equals(this.file.getName()) || backupFile.getName().equals(this.fileName + "_metainfo") || backupFile.getName().length() < this.file.getName().length()) {
                    fileSet.remove(backupFile);
                    continue;
                }
                String fileName = this.file.getName();
                String backupFileName = backupFile.getName();
                if (this.file.getName().indexOf(".") >= 0) {
                    fileName = fileName.substring(0, this.file.getName().lastIndexOf("."));
                }
                if (fileName.equals(backupFileName = backupFileName.substring(0, fileName.length()))) continue;
                fileSet.remove(backupFile);
            }
        }
        return fileSet;
    }

    public void increaseFileSize(long writtenByte) {
        if (this.validSize > 0) {
            this.fileSize += writtenByte;
        }
    }

    public boolean isRotateBySize() {
        return this.fileSize >= (long)(this.validSize * 1024);
    }

    private void resetLogFile() {
        this.fileSize = 0L;
    }

    private class CopyLogFile
    implements Runnable {
        private File tempFile;
        private File rotationFile;
        private boolean sameDir;

        public CopyLogFile(File tempFile, File rotationFile, boolean sameDir) {
            this.tempFile = tempFile;
            this.rotationFile = rotationFile;
            this.sameDir = sameDir;
        }

        public void run() {
            if (!this.sameDir) {
                if (!this.tempFile.renameTo(this.rotationFile)) {
                    try {
                        FileUtils.copy(this.tempFile, this.rotationFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    FileUtils.copy(this.tempFile, this.rotationFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.tempFile.exists()) {
                this.tempFile.delete();
            }
            SortedSet sortedFileSet = LogFileRotator.this.getBackupFileList();
            while (LogFileRotator.this.rotationCount > 0 && sortedFileSet.size() > LogFileRotator.this.rotationCount) {
                ((File)sortedFileSet.first()).delete();
                sortedFileSet.remove(sortedFileSet.first());
            }
        }
    }
}

