/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.SimpleLogDateFormat;
import jeus.util.StringUtil;
import jeus.util.logging.ErrorLogRecord;
import jeus.util.logging.JeusFormatter;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogRecord;
import jeus.util.logging.SystemOutRecord;

public class SimpleFormatter
extends JeusFormatter {
    private static final String dateFormat = "yyyy.MM.dd HH:mm:ss";
    protected static SimpleLogDateFormat logformat = new SimpleLogDateFormat("yyyy.MM.dd HH:mm:ss");
    protected static SimpleDateFormat dateformat;
    private static Object[] noArgs;
    protected static String lineSeparator;
    protected boolean forcedNonLocalized = true;
    private static boolean logStdoutToRawFormat;
    private static Class oracleError;
    private static Method oracleErrorMethod;
    protected static String FORMATTER_ID_PREFIX;
    protected String FORMATTER_ID;
    protected HashMap levelMap;
    protected boolean isJavaLevel;
    protected boolean printLoggerName;
    public static final String LEVEL_TYPE_KEY = "levelType";
    public static final String NUMBER_LEVEL_TYPE = "NUMBER_LEVEL";
    public static final String JEUS_LEVEL_TYPE = "JEUS_LEVEL";
    public static final String JAVA_LEVEL_TYPE = "JAVA_LEVEL";
    public static final String LOCALIZED_LEVEL_TYPE = "LOCALIZED_LEVEL";
    public static final String LOGGER_NAME_KEY = "loggerName";
    public static final String stackTrPrefix = "<<__Exception__>>";
    public static final String stackTrPostfix = "<<__!Exception__>>";
    protected Map propertyMap;
    public static String BUILD_VERSION;

    public SimpleFormatter() {
    }

    public SimpleFormatter(Map properties) {
        this.setProperty(properties);
    }

    public String format(LogRecord r) {
        String message;
        long threadId;
        String jvmId;
        JeusLogRecord record;
        String formattedMessage;
        if (r instanceof SystemOutRecord && logStdoutToRawFormat) {
            return r.getMessage();
        }
        StringBuffer text = new StringBuffer();
        if (r instanceof JeusLogRecord && (formattedMessage = (record = (JeusLogRecord)r).getFormattedMessage(this.FORMATTER_ID)) != null) {
            return formattedMessage;
        }
        Date dat = new Date(r.getMillis());
        text.append('[');
        text.append(logformat.format(dat));
        text.append(']');
        Level level = r.getLevel();
        String levelName = this.levelMap != null ? (String)this.levelMap.get(level) : (this.isJavaLevel ? level.getName() : level.getLocalizedName());
        text.append('[').append(levelName).append("][").append(BUILD_VERSION).append("] ");
        if (r instanceof JeusLogRecord) {
            jvmId = ((JeusLogRecord)r).getJvmId();
            threadId = ((JeusLogRecord)r).getRealThreadID();
        } else {
            jvmId = JeusLogRecord.JVM_ID;
            threadId = Thread.currentThread().getId();
        }
        if (jvmId != null) {
            text.append('[').append(jvmId).append('-').append(threadId).append("] ");
        }
        if (this.printLoggerName) {
            text.append('[').append(r.getLoggerName()).append("] ");
        }
        if (r instanceof ErrorLogRecord) {
            String appName;
            ErrorLogRecord errRecord = (ErrorLogRecord)r;
            int messageNumber = errRecord.getMessageNumber();
            if (messageNumber != -1) {
                text.append('[').append(errRecord.getSourceModuleName()).append('-').append(this.formatNumber(messageNumber)).append("] ");
            }
            if ((appName = errRecord.getAppName()) != null && !appName.equals("")) {
                text.append('[').append(appName).append("] ");
            }
            String message2 = errRecord.getLocalizedString();
            text.append(message2);
            text.append(lineSeparator);
        } else if (r instanceof SystemOutRecord) {
            if (r.getLoggerName() == null) {
                text.append("[Unknown] ");
            } else if (r.getLoggerName().equals("jeus.system.out")) {
                text.append("[STDOUT] ");
            } else if (r.getLoggerName().equals("jeus.system.err")) {
                text.append("[STDERR] ");
            }
            message = r.getMessage();
            text.append(message);
        } else {
            message = this.formatMessage(r);
            text.append(message);
            text.append(lineSeparator);
        }
        if (r.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                text.append(stackTrPrefix).append(StringUtil.lineSeparator);
                SimpleFormatter.printStackTraces(r.getThrown(), pw);
                pw.close();
                text.append(sw.toString());
                text.append(stackTrPostfix).append(StringUtil.lineSeparator);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        formattedMessage = text.toString();
        if (r instanceof JeusLogRecord) {
            ((JeusLogRecord)r).setFormattedMessage(this.FORMATTER_ID, formattedMessage);
        }
        return formattedMessage;
    }

    public static String formatLogRecord(Formatter formatter, LogRecord r, Map levelMap, boolean isJavaLevel) {
        Date dat = new Date(r.getMillis());
        StringBuffer text = new StringBuffer();
        text.append('[');
        text.append(logformat.format(dat));
        text.append(']');
        String message = formatter.formatMessage(r);
        String levelName = levelMap != null ? (String)levelMap.get(r.getLevel()) : (isJavaLevel ? r.getLevel().getName() : r.getLevel().getLocalizedName());
        text.append('[').append(levelName).append("][").append(BUILD_VERSION).append("] ");
        long threadId = r instanceof JeusLogRecord ? ((JeusLogRecord)r).getRealThreadID() : Thread.currentThread().getId();
        text.append('[').append(JeusLogRecord.JVM_ID).append('-').append(threadId).append("] ");
        text.append(message);
        text.append(lineSeparator);
        if (r.getThrown() != null) {
            try {
                text.append(stackTrPrefix).append(StringUtil.lineSeparator);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                SimpleFormatter.printStackTraces(r.getThrown(), pw);
                pw.close();
                text.append(sw.toString());
                text.append(stackTrPostfix).append(StringUtil.lineSeparator);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return text.toString();
    }

    protected String formatNumber(int messageNumber) {
        String format = String.valueOf(messageNumber);
        int len = format.length();
        switch (len) {
            case 3: {
                format = "0" + format;
                break;
            }
            case 2: {
                format = "00" + format;
                break;
            }
            case 1: {
                format = "000" + format;
            }
        }
        return format;
    }

    protected static void printStackTraces(Throwable t, PrintWriter pw) {
        if (oracleError != null && oracleError.isInstance(t)) {
            try {
                pw.println("[ORA - " + oracleErrorMethod.invoke((Object)t, noArgs) + "] : " + t.getMessage());
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        t.printStackTrace(pw);
        Throwable rootCause = SimpleFormatter.getCauseException(t);
        if (t != rootCause) {
            pw.println("Root Exception stack trace : ");
            rootCause.printStackTrace(pw);
        }
    }

    public static Throwable getCauseException(Throwable t) {
        while (true) {
            Throwable nextT;
            Exception e;
            if (t instanceof RemoteException) {
                e = (RemoteException)t;
                nextT = ((RemoteException)e).detail;
            } else if (t instanceof SQLException) {
                e = (SQLException)t;
                nextT = ((SQLException)e).getNextException();
            } else if (t instanceof NamingException) {
                e = (NamingException)t;
                nextT = ((NamingException)e).getRootCause();
            } else if (t instanceof ServletException) {
                e = (ServletException)t;
                nextT = ((ServletException)e).getRootCause();
            } else if (t instanceof JspException) {
                e = (JspException)t;
                nextT = ((JspException)e).getRootCause();
            } else if (t instanceof JMSException) {
                e = (JMSException)t;
                nextT = ((JMSException)e).getLinkedException();
            } else {
                nextT = !JeusBootstrapPropertyValues.isUpperJDK4() ? null : t.getCause();
            }
            if (nextT == null) {
                return t;
            }
            t = nextT;
        }
    }

    public void setProperty(Map propertyMap) {
        this.propertyMap = propertyMap;
        String levelType = (String)propertyMap.get(LEVEL_TYPE_KEY);
        if (levelType == null) {
            levelType = NUMBER_LEVEL_TYPE;
        }
        if (levelType.equals(JEUS_LEVEL_TYPE)) {
            this.levelMap = new HashMap();
            this.levelMap.put(Level.SEVERE, "FATAL");
            this.levelMap.put(Level.WARNING, "NOTICE");
            this.levelMap.put(Level.INFO, Level.INFO.getName());
            this.levelMap.put(Level.CONFIG, "DEBUG");
            this.levelMap.put(Level.FINE, Level.FINE.getName());
            this.levelMap.put(Level.FINER, Level.FINER.getName());
            this.levelMap.put(Level.FINEST, Level.FINEST.getName());
        } else if (levelType.equals(JAVA_LEVEL_TYPE)) {
            this.isJavaLevel = true;
        } else if (!levelType.equals(LOCALIZED_LEVEL_TYPE)) {
            this.levelMap = new HashMap();
            this.levelMap.put(Level.SEVERE, "0");
            this.levelMap.put(Level.WARNING, "1");
            this.levelMap.put(Level.INFO, "2");
            this.levelMap.put(Level.CONFIG, "3");
            this.levelMap.put(Level.FINE, "4");
            this.levelMap.put(Level.FINER, "5");
            this.levelMap.put(Level.FINEST, "6");
            this.levelMap.put(JeusLevel.DEV, "7");
        }
        String loggerName = (String)propertyMap.get(LOGGER_NAME_KEY);
        this.printLoggerName = loggerName == null ? false : Boolean.valueOf(loggerName);
        this.FORMATTER_ID = FORMATTER_ID_PREFIX + "_" + levelType + "_" + this.printLoggerName;
    }

    public Map getProperty() {
        return this.propertyMap;
    }

    public Map getLogRecord(String message) throws ParseException {
        Level levelObject;
        if (dateformat == null) {
            dateformat = new SimpleDateFormat(dateFormat);
        }
        int openIndex = message.indexOf(91);
        int closeIndex = message.indexOf(93, openIndex);
        String date = message.substring(openIndex + 1, closeIndex);
        Date dat = dateformat.parse(date);
        openIndex = message.indexOf(91, closeIndex);
        closeIndex = message.indexOf(93, openIndex);
        String level = message.substring(openIndex + 1, closeIndex);
        try {
            levelObject = JeusLevel.parse(level);
        }
        catch (IllegalArgumentException ex) {
            int levelType = Integer.parseInt(level);
            levelObject = ErrorMsgManager.levels[levelType];
        }
        openIndex = message.indexOf(91, closeIndex);
        String jvmId = null;
        String threadId = null;
        String loggerName = null;
        String sourceModule = null;
        String number = null;
        String appName = null;
        if (openIndex >= 0) {
            closeIndex = message.indexOf(93, openIndex);
            String executionId = message.substring(openIndex + 1, closeIndex);
            int index = executionId.indexOf(45);
            if (index < 0) {
                loggerName = executionId;
                openIndex = message.indexOf(91, closeIndex);
                closeIndex = message.indexOf(93, openIndex);
                executionId = message.substring(openIndex + 1, closeIndex);
                index = executionId.indexOf(45);
            }
            jvmId = executionId.substring(0, index);
            threadId = executionId.substring(index + 1);
            openIndex = message.indexOf(91, closeIndex);
            closeIndex = message.indexOf(93, openIndex);
            String messageNumber = message.substring(openIndex + 1, closeIndex);
            index = messageNumber.indexOf(45);
            sourceModule = messageNumber.substring(0, index);
            number = messageNumber.substring(index + 1);
            openIndex = message.indexOf(91, closeIndex);
            if (openIndex >= 0 && openIndex - closeIndex == 2) {
                closeIndex = message.indexOf(93, openIndex);
                appName = message.substring(openIndex + 1, closeIndex);
            }
        }
        message = message.substring(closeIndex + 2);
        ErrorLogRecord record = new ErrorLogRecord(sourceModule, Integer.parseInt(number), jvmId, Integer.parseInt(threadId), dat, levelObject, message, appName, loggerName);
        Map map = record.getLogInfo();
        map.put("dateFormat", dateFormat);
        return map;
    }

    public static void setLogStdoutToRawFormat(boolean logStdoutToRawFormat) {
        SimpleFormatter.logStdoutToRawFormat = logStdoutToRawFormat;
    }

    static {
        noArgs = new Object[0];
        lineSeparator = StringUtil.lineSeparator;
        logStdoutToRawFormat = true;
        FORMATTER_ID_PREFIX = "JEUS_SIMPLE_FORMATTER";
        BUILD_VERSION = "";
        try {
            oracleError = SimpleFormatter.class.getClassLoader().loadClass("oracle.jdbc.xa.OracleXAException");
            oracleErrorMethod = oracleError.getMethod("getOracleError", new Class[0]);
        }
        catch (ClassNotFoundException ex) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

