/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.util.Map;
import java.util.Properties;
import java.util.logging.LogRecord;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jeus.util.logging.ErrorLogRecord;
import jeus.util.logging.JeusHandler;

public class SmtpHandler
extends JeusHandler {
    public static final String SMTP_HOST_PROPERTY_KEY = "mail.smtp.host";
    public static final String FROM_ADDRESS_PROPERTY_KEY = "mail.from.address";
    public static final String TO_ADDRESS_PROPERTY_KEY = "mail.to.recipients";
    public static final String CC_ADDRESS_PROPERTY_KEY = "mail.to.ccrecipients";
    public static final String BCC_ADDRESS_PROPERTY_KEY = "mail.to.bccrecipients";
    private Session session;
    private MimeMessage message;
    private String name = this.getClass().getName() + "@" + this.hashCode();
    private String smtpHostAddress;
    private String fromAddress;
    private String toAddress;
    private String ccAddress;
    private String bccAddress;

    public void setProperty(Map propertyMap) {
        try {
            this.smtpHostAddress = (String)propertyMap.get(SMTP_HOST_PROPERTY_KEY);
            Properties prop = System.getProperties();
            prop.put(SMTP_HOST_PROPERTY_KEY, this.smtpHostAddress);
            this.session = Session.getInstance(prop, null);
            this.message = new MimeMessage(this.session);
            this.fromAddress = (String)propertyMap.get(FROM_ADDRESS_PROPERTY_KEY);
            InternetAddress fromAddr = new InternetAddress(this.fromAddress);
            this.message.setFrom(fromAddr);
            this.toAddress = (String)propertyMap.get(TO_ADDRESS_PROPERTY_KEY);
            if (this.toAddress != null) {
                Address[] toAddr = InternetAddress.parse(this.toAddress);
                this.message.setRecipients(Message.RecipientType.TO, toAddr);
            }
            this.ccAddress = (String)propertyMap.get(CC_ADDRESS_PROPERTY_KEY);
            if (this.ccAddress != null) {
                Address[] ccAddr = InternetAddress.parse(this.ccAddress);
                this.message.setRecipients(Message.RecipientType.CC, ccAddr);
            }
            this.bccAddress = (String)propertyMap.get(BCC_ADDRESS_PROPERTY_KEY);
            if (this.bccAddress != null) {
                Address[] bccAddr = InternetAddress.parse(this.bccAddress);
                this.message.setRecipients(Message.RecipientType.BCC, bccAddr);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public void publish(LogRecord record) {
        if (this.message == null) {
            return;
        }
        try {
            String subject;
            String msg = this.getFormatter().format(record);
            int newLineIndex = msg.indexOf(10);
            String subjectMsg = newLineIndex > 0 ? msg.substring(0, newLineIndex) : msg;
            if (record instanceof ErrorLogRecord) {
                ErrorLogRecord errRecord = (ErrorLogRecord)record;
                subject = errRecord.getSubject();
                if (subject == null) {
                    subject = record.getLoggerName() + " : " + subjectMsg;
                }
            } else {
                subject = record.getLoggerName() + " : " + subjectMsg;
            }
            this.message.setSubject(subject);
            this.message.setText(msg);
            Transport.send(this.message);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSmtpHostAddress() {
        return this.smtpHostAddress;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public String getCcAddress() {
        return this.ccAddress;
    }

    public String getBccAddress() {
        return this.bccAddress;
    }

    public void flush() {
    }

    public synchronized void close() throws SecurityException {
    }
}

