/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.util.concurrent.Executor;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.net.ActiveDispatcher;
import jeus.util.net.ActiveReceiverTable;
import jeus.util.net.BlockingActiveDispatcher;
import jeus.util.net.DispatcherRequestHandlerFactory;
import jeus.util.net.JNBBuffer;
import jeus.util.net.JeusNetUtil;
import jeus.util.net.ReceiverTable;
import jeus.util.net.SocketDispatcher;
import jeus.util.net.SocketDispatcherListener;

public abstract class AbstractActiveDispatcher
extends SocketDispatcher {
    protected int backlog = 128;
    protected boolean enableSSL;
    protected int sslPort;
    protected boolean running;
    private boolean pipeSupported;
    DispatcherRequestHandlerFactory handlerFactory;

    AbstractActiveDispatcher(Executor executor, int listenport, int backlog, boolean enableSSL, int sslPort, SocketDispatcherListener listener) throws IOException {
        super(executor, listenport, listener);
        this.receiverTable = new ActiveReceiverTable(this.getDispatcherName());
        this.enableSSL = enableSSL;
        this.sslPort = sslPort;
        this.backlog = backlog;
        this.pipeSupported = JeusNetUtil.pipeSupported;
        this.handlerFactory = DispatcherRequestHandlerFactory.getInstance(this);
        this.initSocket();
        this.running = true;
        this.thread = new Thread(this);
        this.thread.setName("ActiveDispatcher-" + listenport);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = dispatcherGlobalSynch;
        synchronized (object) {
            this.running = false;
            this.destroyInternal();
        }
    }

    protected abstract void destroyInternal();

    protected abstract void initSocket() throws IOException;

    protected abstract Executor getExecutor();

    public abstract int getPort();

    public abstract String getHostAddress();

    abstract void removeListenerById(Object[] var1, JNBBuffer var2);

    public ReceiverTable getReceiverTable() {
        return this.receiverTable;
    }

    public boolean pipeSupported() {
        return this.pipeSupported;
    }

    public static SocketDispatcher createActiveDispatcher(Executor executor, int listenport, int backlog, boolean enableSSL, int sslPort, SocketDispatcherListener listener) throws IOException {
        String blocking = JeusBootstrapPropertyValues.getSystemProperty("jeus.dispatcher.blocking", "false");
        if (blocking.equalsIgnoreCase("true")) {
            return new BlockingActiveDispatcher(executor, listenport, backlog, enableSSL, sslPort, listener);
        }
        return new ActiveDispatcher(executor, listenport, backlog, enableSSL, sslPort, listener);
    }
}

