/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import jeus.util.cnet.SockPassConstants;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.net.SocketEventSender;
import jeus.util.net.VirtualListener;

final class Dispatcher
implements Runnable {
    private VirtualListener listener;
    private Socket socket;
    private SocketChannel socketChannel;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.netutil");

    public Dispatcher(VirtualListener vl, Socket socket) throws IOException {
        this.listener = vl;
        this.socket = socket;
        if (socket == null) {
            throw new IllegalStateException("socket is null");
        }
        SocketChannel socketchannel = socket.getChannel();
        if (socketchannel != null) {
            socketchannel.configureBlocking(true);
        }
        if (!(this.listener instanceof SocketEventSender)) {
            if (socketchannel == null) {
                OutputStream out = socket.getOutputStream();
                out.write(1);
                out.flush();
            } else {
                ByteBuffer b = ByteBuffer.wrap(SockPassConstants.SOCKPASS_SUCCESS_BYTES);
                socketchannel.write(b);
            }
        }
    }

    public Dispatcher(VirtualListener vl, SocketChannel channel) throws IOException {
        this.listener = vl;
        this.socketChannel = channel;
        if (channel == null) {
            throw new IllegalStateException("socket is null");
        }
        this.socket = channel.socket();
        channel.configureBlocking(true);
        if (!(this.listener instanceof SocketEventSender)) {
            ByteBuffer b = ByteBuffer.wrap(SockPassConstants.SOCKPASS_SUCCESS_BYTES);
            channel.write(b);
        }
    }

    public void run() {
        try {
            this.listener.onSocket(this.socket);
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_Network._1014_LEVEL)) {
                logger.log(JeusMessage_Network._1014_LEVEL, JeusMessage_Network._1014, this.listener.getId(), (Throwable)ioe);
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void abort() {
        if (this.socketChannel != null) {
            if (logger.isLoggable(JeusMessage_Network._1013_LEVEL)) {
                logger.log(JeusMessage_Network._1013_LEVEL, JeusMessage_Network._1013, new Object[]{this.socketChannel, this.listener.getId()});
            }
            try {
                this.socketChannel.close();
            }
            catch (Exception e) {}
        } else if (this.socket != null) {
            if (logger.isLoggable(JeusMessage_Network._1012_LEVEL)) {
                logger.log(JeusMessage_Network._1012_LEVEL, JeusMessage_Network._1012, new Object[]{this.socket, this.listener.getId()});
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

