/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import jeus.util.cnet.SockPassConstants;
import jeus.util.net.AbstractActiveDispatcher;
import jeus.util.net.ConRequestHandler;
import jeus.util.net.DispatcherRequestHandler;
import jeus.util.net.RegRequestHandler;
import jeus.util.net.SockTransRegRequestHandler;
import jeus.util.net.UnregRequestHandler;

public class DispatcherRequestHandlerFactory
implements SockPassConstants {
    private static ConRequestHandler conHandler;
    private static RegRequestHandler regHandler;
    private static UnregRequestHandler unregHandler;
    private static SockTransRegRequestHandler socktransHandler;
    private static DispatcherRequestHandlerFactory instance;

    public static DispatcherRequestHandlerFactory getInstance(AbstractActiveDispatcher activeDispatcher) {
        String dispatcherName = activeDispatcher.getDispatcherName();
        conHandler = new ConRequestHandler(activeDispatcher.getExecutor(), activeDispatcher.getReceiverTable(), dispatcherName);
        regHandler = new RegRequestHandler(activeDispatcher.getReceiverTable(), dispatcherName);
        unregHandler = new UnregRequestHandler(activeDispatcher.getReceiverTable(), dispatcherName);
        socktransHandler = new SockTransRegRequestHandler(activeDispatcher.pipeSupported(), dispatcherName);
        return instance;
    }

    private DispatcherRequestHandlerFactory() {
    }

    DispatcherRequestHandler getHandler(int opcode) {
        switch (opcode) {
            case 100: {
                return conHandler;
            }
            case 98: {
                return regHandler;
            }
            case 99: {
                return unregHandler;
            }
            case 97: {
                return socktransHandler;
            }
        }
        return null;
    }

    static {
        instance = new DispatcherRequestHandlerFactory();
    }
}

