/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusSocket;
import jeus.util.net.PipeSocket;
import jeus.util.net.PipeSocketImpl;
import jeus.util.net.WebtobPipeSocket;
import jeus.util.net.WinIPCSocket;
import jeus.util.properties.JeusNetPropertyValues;

public class JeusNetUtil {
    public static boolean pipeSupported;
    public static String jeusPipePath;
    public static File jeusPipePathDir;
    private static String webtobPipePath;
    private static boolean isWindows;
    private static DecimalFormat webtobPathFormat;

    public static Socket getSocket(String addr, int port) throws UnknownHostException, IOException {
        return JeusNetUtil.getSocket(addr, port, -1);
    }

    public static Socket getSocket(String addr, int port, int timeout) throws UnknownHostException, IOException {
        return JeusNetUtil.getSocket(addr, port, timeout, false);
    }

    public static Socket getSocket(String addr, int port, int timeout, boolean nopipe) throws UnknownHostException, IOException {
        String addr3;
        String addr2;
        String addr1;
        if (!pipeSupported || nopipe) {
            return new Socket(addr, port);
        }
        try {
            InetAddress localAddr = JeusNetPropertyValues.getLocalInetAddress();
            addr1 = localAddr.getHostAddress();
            addr2 = localAddr.getHostName();
            int pos = addr2.indexOf(".");
            addr3 = pos > 0 ? addr2.substring(0, pos) : addr2;
        }
        catch (Exception e) {
            addr1 = "";
            addr2 = "";
            addr3 = "";
        }
        if (addr.equals(JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS) || addr.equals("localhost") || addr.equals(addr1) || addr.equals(addr2) || addr.equals(addr3)) {
            String path = jeusPipePath + Integer.toString(port);
            return new PipeSocket(path, port);
        }
        if (timeout > 0) {
            return JeusSocket.getConnection(addr, port, timeout);
        }
        return new Socket(addr, port);
    }

    public static Socket getWebtobSocket(String customWebtobPipePath, String addr, int port, int hthno, boolean disablePipe) throws UnknownHostException, IOException {
        return JeusNetUtil.getWebtobSocket(customWebtobPipePath, addr, port, hthno, disablePipe, -1);
    }

    public static Socket getWebtobSocket(String customWebtobPipePath, String addr, int port, int hthno, boolean disablePipe, int ipcbase) throws UnknownHostException, IOException {
        String addr2;
        String addr1;
        try {
            InetAddress localAddr = JeusNetPropertyValues.getLocalInetAddress();
            addr1 = localAddr.getHostAddress();
            addr2 = localAddr.getHostName();
        }
        catch (Exception e) {
            addr1 = "";
            addr2 = "";
        }
        if (!pipeSupported || disablePipe) {
            if (!pipeSupported) {
                if (isWindows && ipcbase > 0 && (addr.equals(JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS) || addr.equals("localhost") || addr.equals(addr1) || addr.equals(addr2))) {
                    return new WinIPCSocket(JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS, ipcbase + 4 + hthno);
                }
                return new Socket(addr, port);
            }
            return new Socket(addr, port);
        }
        if (addr.equals(JeusNetPropertyValues.LOCAL_LOOPBACK_ADDRESS) || addr.equals("localhost") || addr.equals(addr1) || addr.equals(addr2)) {
            if (webtobPipePath == null) {
                return new Socket(addr, port);
            }
            String webtobpathdir = webtobPipePath;
            if (customWebtobPipePath != null) {
                webtobpathdir = customWebtobPipePath;
            }
            String path = webtobPathFormat.format(hthno);
            return new WebtobPipeSocket(webtobpathdir + path, port, hthno);
        }
        return new Socket(addr, port);
    }

    static {
        try {
            System.loadLibrary("JeusNet");
        }
        catch (UnsatisfiedLinkError ex) {
            System.out.println("Do not support pipe socket (No JeusNet library)");
        }
        jeusPipePath = null;
        webtobPipePath = null;
        isWindows = false;
        webtobPathFormat = new DecimalFormat("'hthd'000");
        if (System.getProperty("os.name").startsWith("Windows")) {
            pipeSupported = false;
            isWindows = true;
        } else {
            pipeSupported = true;
        }
        String disable = System.getProperty("jeus.pipe.enable");
        if (disable != null && disable.equalsIgnoreCase("false")) {
            pipeSupported = false;
        }
        if (pipeSupported) {
            String path = System.getProperty("jeus.pipe.path");
            if (path != null) {
                if (path.endsWith(File.separator)) {
                    path = path.substring(0, path.length() - 1);
                }
                try {
                    jeusPipePath = path + File.separator + "path" + File.separator;
                    jeusPipePathDir = new File(jeusPipePath);
                    if (!jeusPipePathDir.exists()) {
                        jeusPipePathDir.mkdirs();
                    }
                }
                catch (Exception e) {
                    path = null;
                }
            }
            if (path == null) {
                String jeusHome = JeusBootstrapProperties.JEUS_HOME;
                try {
                    if (jeusHome != null && !(jeusPipePathDir = new File(jeusPipePath = jeusHome + File.separator + "path" + File.separator)).exists()) {
                        jeusPipePathDir.mkdirs();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String webtobHome = null;
            try {
                File webtobPipePathDir;
                if (pipeSupported && (webtobHome = PipeSocketImpl.getenv("JEUS_WSDIR")) == null) {
                    webtobHome = PipeSocketImpl.getenv("WEBTOBDIR");
                }
                if (webtobHome != null && webtobHome.length() > 0 && !(webtobPipePathDir = new File(webtobPipePath = webtobHome.endsWith(File.separator) ? webtobHome + "path" + File.separator : webtobHome + File.separator + "path" + File.separator)).exists()) {
                    webtobPipePathDir.mkdirs();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

