/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.net.ConnectException;
import jeus.util.JeusRuntimeException;
import jeus.util.PooledExecutorFactory;
import jeus.util.ThreadPoolExecutor;
import jeus.util.cnet.SockPassConstants;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.net.AbstractActiveDispatcher;
import jeus.util.net.JeusSocketDispatcherListener;
import jeus.util.net.PassiveDispatcher;
import jeus.util.net.SocketDispatcher;
import jeus.util.net.SocketEventSender;
import jeus.util.net.VirtualListener;

public class JeusSocketDispatcher
implements SockPassConstants {
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.netutil");
    protected static int listenport;
    protected static int backlog;
    protected static boolean enableSSL;
    protected static int sslPort;
    private static final int MAX_POOL_SIZE = 10;
    private static final int MIN_POOL_SIZE = 1;
    private static int minPoolSize;
    private static int maxPoolSize;
    private static long keepAliveTime;
    protected static ThreadPoolExecutor executor;
    public static SocketDispatcher instance;
    protected Thread thread;
    private static boolean startCalled;
    protected static final Object dispatcherGlobalSynch;
    private static boolean useActiveDispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(boolean useActiveDispatcher) throws IOException {
        if (!startCalled) {
            Object object = dispatcherGlobalSynch;
            synchronized (object) {
                if (!startCalled) {
                    startCalled = true;
                    JeusSocketDispatcher.useActiveDispatcher = useActiveDispatcher;
                    JeusSocketDispatcher.initExecutor();
                    JeusSocketDispatcher.initSocketDispatcher();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initSocketDispatcher() throws IOException {
        Object object = dispatcherGlobalSynch;
        synchronized (object) {
            instance = null;
            while (instance == null) {
                if (useActiveDispatcher) {
                    instance = AbstractActiveDispatcher.createActiveDispatcher(executor, listenport, backlog, enableSSL, sslPort, new JeusSocketDispatcherListener());
                    continue;
                }
                try {
                    instance = new PassiveDispatcher(executor, listenport, new JeusSocketDispatcherListener());
                }
                catch (ConnectException ex) {
                    if (logger.isLoggable(JeusMessage_Network._1031_LEVEL)) {
                        logger.log(JeusMessage_Network._1031_LEVEL, JeusMessage_Network._1031);
                    }
                    instance = AbstractActiveDispatcher.createActiveDispatcher(executor, listenport, backlog, enableSSL, sslPort, new JeusSocketDispatcherListener());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroySocketDispatcher() {
        if (instance != null) {
            Object object = dispatcherGlobalSynch;
            synchronized (object) {
                if (instance != null) {
                    instance.destroy();
                    instance = null;
                }
            }
        }
    }

    private static void initExecutor() {
        if (executor == null) {
            executor = (ThreadPoolExecutor)PooledExecutorFactory.createThreadPoolExecutor("jeus.util.net.SocketDispatcher", minPoolSize, maxPoolSize, keepAliveTime);
        }
    }

    public static void registerHandler(VirtualListener event) throws IOException {
        instance.register(event);
    }

    public static void unregisterHandler(VirtualListener event) {
        instance.unregister(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void failover(Throwable cause, SocketDispatcher dispatcher) {
        if (logger.isLoggable(JeusMessage_Network._1027_LEVEL)) {
            logger.log(JeusMessage_Network._1027_LEVEL, JeusMessage_Network._1027, (Object)cause.getMessage());
        }
        Object object = dispatcherGlobalSynch;
        synchronized (object) {
            if (executor != null) {
                executor.shutdownNow();
                executor = (ThreadPoolExecutor)PooledExecutorFactory.createThreadPoolExecutor("jeus.util.net.SocketDispatcher", maxPoolSize);
            }
            instance = null;
            VirtualListener[] receiverEnum = dispatcher.getVirtualListenersAndClear();
            dispatcher.destroy();
            try {
                JeusSocketDispatcher.initSocketDispatcher();
            }
            catch (IOException e) {
                throw new JeusRuntimeException(e);
            }
            for (int i = 0; i < receiverEnum.length; ++i) {
                VirtualListener e = receiverEnum[i];
                if (e instanceof SocketEventSender) continue;
                try {
                    JeusSocketDispatcher.registerHandler(e);
                    continue;
                }
                catch (IOException ioe) {
                    if (!logger.isLoggable(JeusMessage_Network._1028_LEVEL)) continue;
                    logger.log(JeusMessage_Network._1028_LEVEL, JeusMessage_Network._1028, e.getId(), (Throwable)ioe);
                }
            }
        }
    }

    public static void setBacklog(int tmp) {
        backlog = tmp;
    }

    public static void setSSLPort(int i) {
        enableSSL = true;
        sslPort = i;
    }

    public static void setPoolMin(int min) {
        minPoolSize = min;
    }

    public static void setPoolMax(int max) {
        maxPoolSize = max;
    }

    public static void setPoolPeriod(long period) {
        keepAliveTime = period;
    }

    public static void setListenPort(int containerBasePort) {
        listenport = containerBasePort;
    }

    static {
        backlog = 128;
        minPoolSize = 1;
        maxPoolSize = 10;
        keepAliveTime = 3600000L;
        dispatcherGlobalSynch = SocketDispatcher.dispatcherGlobalSynch;
    }
}

