/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import jeus.util.net.JeusNetUtil;
import jeus.util.net.JeusTransSocket;
import jeus.util.net.PipeSocket;
import jeus.util.net.TransSocketConstants;
import sun.nio.ch.JeusChannelTransceiverBase;
import sun.nio.ch.JeusTransSocketChannel;

public class JeusTransceiver
extends JeusChannelTransceiverBase
implements TransSocketConstants {
    private int targetPid;
    private int fdVal;
    private String hostname = "localhost";
    private static final Field fdValField;
    private static final Field localAddrField;
    private static final Field implField;
    private static final Field fdField;
    private static final Class implClass;
    private static final Field connectedField;
    private static final Field boundField;
    private static final Field createdField;
    private static final Field lportField;
    private static final Field rportField;
    private Socket targetSocket;
    private int localPort;
    private int remotePort;
    private int isPipe;
    private int newFd;

    public JeusTransceiver(Socket socket, int peer) throws SocketException {
        this.targetPid = peer;
        this.fdVal = socket instanceof PipeSocket ? ((PipeSocket)socket).getfd() : (socket.getChannel() != null ? this.getChannelFd(socket.getChannel()) : JeusTransSocket.getfd(socket));
    }

    public JeusTransceiver(SocketChannel sc, int peer) {
        this.targetPid = peer;
        this.fdVal = this.getChannelFd(sc);
    }

    public void sendChannel(SocketChannel channel, int newLocalPort) throws IOException {
        this.setChannel(channel);
        int tobeSent = this.getChannelFd(channel);
        int ret = this.sendFdTo0(this.fdVal, this.targetPid, tobeSent, newLocalPort, 0, 1, 1);
        if (ret < 0) {
            switch (ret) {
                case -1: {
                    throw new IOException("dup error");
                }
                case -2: {
                    throw new IOException("send error");
                }
            }
            throw new IOException("unknown error");
        }
    }

    public void sendSocket(Socket sock, int newLocalPort) throws IOException {
        int fromChannel;
        int fd;
        this.targetSocket = sock;
        if (sock.getChannel() != null) {
            fd = super.getChannelFd(sock.getChannel());
            this.setChannel(sock.getChannel());
            fromChannel = 1;
        } else {
            fd = JeusTransSocket.getfd(sock);
            fromChannel = 0;
        }
        int ret = this.sendFdTo0(this.fdVal, this.targetPid, fd, newLocalPort, 0, 0, fromChannel);
        if (ret < 0) {
            switch (ret) {
                case -1: {
                    throw new IOException("dup error");
                }
                case -2: {
                    throw new IOException("send error");
                }
            }
            throw new IOException("unknown error");
        }
    }

    public int receive() throws IOException {
        int ret = this.recvFdFrom0(this.fdVal);
        if (ret < 0) {
            switch (ret) {
                case -1: {
                    throw new IOException("socket closed");
                }
                case -2: {
                    throw new IOException("recv socket error");
                }
                case -3: {
                    throw new IOException("invalid msg type");
                }
                case -4: {
                    throw new IOException("recv socket error2");
                }
                case -10: {
                    throw new IOException("resource temporarily unavailable");
                }
            }
            throw new IOException("unknown recv socket error");
        }
        return this.localPort;
    }

    public SocketChannel getNewSocketChannel() throws IOException {
        JeusTransSocketChannel newChannel;
        this.remoteAddr = new InetSocketAddress(this.hostname, this.remotePort);
        this.localAddr = new InetSocketAddress(this.hostname, this.localPort);
        try {
            FileDescriptor fd = new FileDescriptor();
            fdValField.setInt(fd, this.newFd);
            Selector selector = Selector.open();
            newChannel = new JeusTransSocketChannel(selector.provider(), fd, this.remoteAddr);
            try {
                selector.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            localAddrField.set(newChannel, this.localAddr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            newChannel = null;
        }
        return newChannel;
    }

    public Socket getNewSocket() throws IOException {
        JeusTransSocket newSocket;
        try {
            newSocket = new JeusTransSocket(this.localPort);
            Object implobj = implField.get(newSocket);
            Object fdObj = fdField.get(implobj);
            fdValField.setInt(fdObj, this.newFd);
            if (this.isPipe != 1) {
                lportField.setInt(implobj, this.localPort);
                rportField.setInt(implobj, this.remotePort);
            }
            if (this.isPipe != 1) {
                connectedField.setBoolean(newSocket, true);
                boundField.setBoolean(newSocket, true);
                createdField.setBoolean(newSocket, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            newSocket = null;
        }
        return newSocket;
    }

    private native int sendFdTo0(int var1, int var2, int var3, int var4, int var5, int var6, int var7) throws IOException;

    private native int recvFdFrom0(int var1) throws IOException;

    private static native void initJeusTransceiver0();

    private static void initJeusTransceiver() {
        JeusTransceiver.initJeusTransceiver0();
    }

    static {
        implClass = SocketImpl.class;
        try {
            fdValField = FileDescriptor.class.getDeclaredField("fd");
            fdValField.setAccessible(true);
            Class<Socket> targetClass = JeusTransceiver.getChannelClass();
            localAddrField = targetClass.getDeclaredField("localAddress");
            localAddrField.setAccessible(true);
            targetClass = Socket.class;
            implField = targetClass.getDeclaredField("impl");
            implField.setAccessible(true);
            fdField = implClass.getDeclaredField("fd");
            fdField.setAccessible(true);
            connectedField = targetClass.getDeclaredField("connected");
            boundField = targetClass.getDeclaredField("bound");
            createdField = targetClass.getDeclaredField("created");
            connectedField.setAccessible(true);
            boundField.setAccessible(true);
            createdField.setAccessible(true);
            lportField = implClass.getDeclaredField("localport");
            rportField = implClass.getDeclaredField("port");
            lportField.setAccessible(true);
            rportField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        boolean hural = JeusNetUtil.pipeSupported;
        JeusTransceiver.initJeusTransceiver();
    }
}

