/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.net.JNBBuffer;
import jeus.util.net.ReceiverTable;
import jeus.util.net.VirtualListener;

public class PassiveReceiverTable
extends ReceiverTable {
    private AtomicInteger synchronizedPort = new AtomicInteger(0);
    private HashMap keyTable = new HashMap();

    public PassiveReceiverTable(String dispatcherName) {
        super(dispatcherName);
    }

    public synchronized Object register(VirtualListener event) throws IOException {
        String id = event.getId();
        if (this.keyTable.containsKey(id)) {
            throw new IOException("Already used id : " + id);
        }
        Integer key = new Integer(this.synchronizedPort.getAndIncrement());
        this.keyTable.put(id, key);
        this.receivers.put(key, event);
        if (logger.isLoggable(JeusMessage_Network._1021_LEVEL)) {
            logger.log(JeusMessage_Network._1021_LEVEL, JeusMessage_Network._1021, new Object[]{this.dispatcherName, id});
        }
        return key;
    }

    public synchronized void unregister(VirtualListener event) {
        String id = event.getId();
        Object key = this.keyTable.remove(id);
        if (key != null && this.receivers.remove(key) != null) {
            if (logger.isLoggable(JeusMessage_Network._1023_LEVEL)) {
                logger.log(JeusMessage_Network._1023_LEVEL, JeusMessage_Network._1023, new Object[]{this.dispatcherName, id});
            }
        } else if (logger.isLoggable(JeusMessage_Network._1024_LEVEL)) {
            logger.log(JeusMessage_Network._1024_LEVEL, JeusMessage_Network._1024, new Object[]{this.dispatcherName, id});
        }
    }

    public void unregister(Object[] keyArray, JNBBuffer buffer) {
    }
}

