/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.io.OutputStream;

class PipeOutputStream
extends OutputStream {
    private int fd;
    private boolean eof;

    PipeOutputStream(int fd) {
        this.fd = fd;
    }

    private native int pipeWrite(byte[] var1, int var2, int var3, int var4) throws IOException;

    public void write(int b) throws IOException {
        int n;
        if (this.eof) {
            throw new IOException("EOF received");
        }
        byte[] temp = new byte[]{(byte)b};
        while ((n = this.pipeWrite(temp, 0, 1, this.fd)) == 0) {
        }
        if (n < 0) {
            this.eof = true;
            throw new IOException("EOF received");
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.pipeWrite(b, off, len, this.fd);
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }
}

