/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import jeus.util.net.JeusNetUtil;
import jeus.util.net.PipeSocketImpl;
import jeus.util.properties.JeusNetPropertyValues;

public class PipeSocket
extends Socket {
    private PipeSocketImpl impl;
    private String path;
    private int port;
    private int localport;
    public static boolean BIG_ENDIAN = PipeSocketImpl.isBigEndian();

    public PipeSocket(String path) throws IOException {
        this(path, false, true);
    }

    protected PipeSocket(PipeSocket sock) {
        this.impl = sock.impl;
        this.path = sock.path;
        this.port = sock.port;
    }

    public PipeSocket(String path, boolean relativeToJeus, boolean doConnect) throws IOException {
        if (relativeToJeus) {
            path = JeusNetUtil.jeusPipePath + path;
        }
        this.path = path;
        this.port = -1;
        this.localport = -1;
        this.createImpl(this.path, doConnect);
    }

    public PipeSocket(String path, int port) throws IOException {
        this.path = path;
        this.port = port;
        this.localport = -1;
        this.createImpl(this.path, true);
    }

    public PipeSocket(int port, boolean doConnect) throws IOException {
        this("" + port, true, doConnect);
        this.port = port;
    }

    public PipeSocket(String path, PipeSocketImpl impl) {
        this.localport = -1;
        this.path = path;
        this.impl = impl;
    }

    protected void createImpl(String path, boolean doConnect) throws IOException {
        this.impl = new PipeSocketImpl(path);
        if (doConnect) {
            this.impl.connect();
        }
    }

    public void connect() throws IOException {
        this.impl.connect();
    }

    protected PipeSocketImpl getImpl() {
        return this.impl;
    }

    public String getPath() {
        return this.path;
    }

    public InetAddress getInetAddress() {
        return JeusNetPropertyValues.getLocalInetAddress();
    }

    public InetAddress getLocalAddress() {
        return JeusNetPropertyValues.getLocalInetAddress();
    }

    public int getPort() {
        return this.port;
    }

    public int getLocalPort() {
        return this.localport;
    }

    public void setLocalPort(int lp) {
        this.localport = lp;
    }

    public InputStream getInputStream() throws IOException {
        return this.impl.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.impl.getOutputStream();
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.impl.setOption(4102, new Integer(timeout));
    }

    public synchronized int getSoTimeout() throws SocketException {
        Object o = this.impl.getOption(4102);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("invalid size : " + String.valueOf(size));
        }
        this.impl.setOption(4097, new Integer(size));
    }

    public synchronized int getSendBufferSize() throws SocketException {
        int result = 0;
        Object o = this.impl.getOption(4097);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("invalid size : " + String.valueOf(size));
        }
        this.impl.setOption(4098, new Integer(size));
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        int result = 0;
        Object o = this.impl.getOption(4098);
        if (o instanceof Integer) {
            result = (Integer)o;
        }
        return result;
    }

    public void setTcpNoDelay(boolean on) {
    }

    public boolean getTcpNoDelay() {
        return false;
    }

    public void setSoLinger(boolean on, int val) {
    }

    public int getSoLinger() {
        return -1;
    }

    public boolean getKeepAlive() throws SocketException {
        return false;
    }

    public void setKeepAlive(boolean on) throws SocketException {
    }

    public synchronized void close() throws IOException {
        this.impl.close();
    }

    public int getfd() {
        if (this.impl == null) {
            throw new IllegalStateException("PipeSocket impl is null");
        }
        return this.impl.getFileDescriptor();
    }

    public String toString() {
        return "unix(" + this.port + ":" + this.impl.getFileDescriptor() + ")";
    }
}

