/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import jeus.util.cnet.DestinationNotFoundException;
import jeus.util.cnet.SockPassConstants;
import jeus.util.net.JeusNetUtil;

public class SocketProxy
implements SockPassConstants {
    public static Socket getConnection(String host, int port, int virtualPort, int timeout, boolean nopipe) throws UnknownHostException, IOException, InterruptedIOException {
        return SocketProxy.getConnection(host, port, "" + virtualPort, timeout, nopipe, 20000);
    }

    public static Socket getConnection(String host, int port, int virtualPort, int timeout, boolean nopipe, int soTimeout) throws UnknownHostException, IOException, InterruptedIOException {
        return SocketProxy.getConnection(host, port, "" + virtualPort, timeout, nopipe, soTimeout);
    }

    public static Socket getConnection(String host, int port, int virtualPort, int timeout) throws UnknownHostException, IOException, InterruptedIOException {
        return SocketProxy.getConnection(host, port, virtualPort, timeout, true, 20000);
    }

    public static Socket getConnection(String host, int port, int virtualPort, int timeout, int soTimeout) throws UnknownHostException, IOException, InterruptedIOException {
        return SocketProxy.getConnection(host, port, virtualPort, timeout, true, soTimeout);
    }

    private static Socket getConnection(String host, int port, String virtualPort, int timeout, boolean nopipe, int soTimeout) throws UnknownHostException, IOException, InterruptedIOException {
        Socket socket = JeusNetUtil.getSocket(host, port, timeout, nopipe);
        int beforeSoTimeout = socket.getSoTimeout();
        socket.setSoTimeout(soTimeout);
        OutputStream out = socket.getOutputStream();
        byte[] buf = jeus.util.cnet.SocketProxy.makePacket((byte)100, virtualPort);
        out.write(buf);
        out.flush();
        InputStream in = socket.getInputStream();
        int status = in.read();
        switch (status) {
            case 1: {
                socket.setSoTimeout(beforeSoTimeout);
                return socket;
            }
            case 2: {
                SocketProxy.closeSocket(socket);
                throw new DestinationNotFoundException("destination not found. host = " + host + ", port = " + port + ", id = " + virtualPort);
            }
            case 100: {
                SocketProxy.closeSocket(socket);
                throw new DestinationNotFoundException("destination not found. host = " + host + ", port = " + port + ", id = " + virtualPort);
            }
        }
        SocketProxy.closeSocket(socket);
        throw new IOException("connection failed. id = " + virtualPort);
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.shutdownInput();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            socket.shutdownOutput();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

