/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import jeus.util.net.JeusTransSocket;
import jeus.util.net.PipeSocket;
import jeus.util.net.TransSocketConstants;
import jeus.util.net.TransSocketProxy;

public class SocketTransceiver
implements TransSocketConstants {
    private Socket socket;
    private int fd;
    private int peer_pid;

    public SocketTransceiver() {
    }

    public SocketTransceiver(Socket socket, int peer_pid) throws SocketException {
        this.socket = socket;
        this.peer_pid = peer_pid;
        this.fd = socket instanceof PipeSocket ? ((PipeSocket)socket).getfd() : JeusTransSocket.getfd(socket);
    }

    public void sendSocket(Socket newsock) throws IOException {
        JeusTransSocket ts = new JeusTransSocket(newsock);
        ts.sendfd(this.fd, this.peer_pid);
    }

    public void sendSocket(Socket newsock, int newLocalPort) throws IOException {
        JeusTransSocket ts = new JeusTransSocket(newsock);
        ts.setLocalPort(newLocalPort);
        ts.sendfd(this.fd, this.peer_pid);
    }

    public Socket recvSocket(int localPort) throws IOException {
        JeusTransSocket newsock = new JeusTransSocket(localPort);
        newsock.recvfd(this.fd);
        return newsock;
    }

    public Socket recvSocket() throws IOException {
        TransSocketProxy proxy = new TransSocketProxy();
        return proxy.recvSocket(this.fd);
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

