/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.net.MalformedURLException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import jeus.util.net.IPAddressFormat;

public class URLFormat
extends Format {
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof URL) {
            URL u = (URL)obj;
            pos.setBeginIndex(0);
            pos.setEndIndex(0);
            toAppendTo.append(URLFormat.format(u));
            return toAppendTo;
        }
        throw new IllegalArgumentException("Cannot format given Object as a URL");
    }

    public Object parseObject(String source, ParsePosition pos) {
        try {
            return URLFormat.parse(source, pos);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static StringBuffer format(URL u) {
        int len = u.getProtocol().length() + 1;
        if (u.getAuthority() != null && u.getAuthority().length() > 0) {
            len += 2 + u.getAuthority().length();
        }
        if (u.getPath() != null) {
            len += u.getPath().length();
        }
        if (u.getQuery() != null) {
            len += 1 + u.getQuery().length();
        }
        if (u.getRef() != null) {
            len += 1 + u.getRef().length();
        }
        StringBuffer result = new StringBuffer(len);
        result.append(u.getProtocol());
        result.append(":");
        if (u.getAuthority() != null && u.getAuthority().length() > 0) {
            result.append("//");
            result.append(u.getAuthority());
        }
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        return result;
    }

    public static URL parse(String spec) throws MalformedURLException {
        ParsePosition pos = new ParsePosition(0);
        return URLFormat.parse(spec, pos);
    }

    public static URL parse(String spec, ParsePosition pos) throws MalformedURLException {
        char c;
        int i;
        int limit;
        URL url = new URL();
        String original = spec;
        int start = pos.getIndex();
        String newProtocol = null;
        boolean aRef = false;
        for (limit = spec.length(); limit > 0 && spec.charAt(limit - 1) <= ' '; --limit) {
        }
        while (start < limit && spec.charAt(start) <= ' ') {
            ++start;
        }
        if (spec.regionMatches(true, start, "url:", 0, 4)) {
            start += 4;
        }
        if (start < spec.length() && spec.charAt(start) == '#') {
            aRef = true;
        }
        for (i = start; !aRef && i < limit && (c = spec.charAt(i)) != '/'; ++i) {
            if (c != ':') continue;
            String s = spec.substring(start, i).toLowerCase();
            if (!URLFormat.isValidProtocol(s)) break;
            newProtocol = s;
            start = i + 1;
            break;
        }
        if (i == limit && newProtocol == null && URLFormat.isValidProtocol(spec)) {
            url.setProtocol(spec);
            pos.setIndex(limit);
            return url;
        }
        url.setProtocol(newProtocol);
        if (url.getProtocol() == null) {
            pos.setErrorIndex(i);
            throw new MalformedURLException("no protocol: " + original);
        }
        i = spec.indexOf(35, start);
        if (i >= 0) {
            url.setRef(spec.substring(i + 1, limit));
            limit = i;
        }
        URLFormat.parseURL(url, spec, start, limit);
        pos.setIndex(limit);
        return url;
    }

    private static boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = protocol.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void parseURL(URL u, String spec, int start, int limit) {
        int ind;
        boolean isUNCName;
        String protocol = u.getProtocol();
        String authority = u.getAuthority();
        String userInfo = u.getUserInfo();
        String host = u.getHost();
        int port = u.getPort();
        String path = u.getPath();
        String query = u.getQuery();
        String ref = u.getRef();
        boolean isRelPath = false;
        boolean queryOnly = false;
        if (start < limit) {
            int queryStart = spec.indexOf(63);
            boolean bl = queryOnly = queryStart == start;
            if (queryStart != -1 && queryStart < limit) {
                query = spec.substring(queryStart + 1, limit);
                if (limit > queryStart) {
                    limit = queryStart;
                }
                spec = spec.substring(0, queryStart);
            }
        }
        int i = 0;
        boolean bl = isUNCName = start <= limit - 4 && spec.charAt(start) == '/' && spec.charAt(start + 1) == '/' && spec.charAt(start + 2) == '/' && spec.charAt(start + 3) == '/';
        if (!isUNCName && start <= limit - 2 && spec.charAt(start) == '/' && spec.charAt(start + 1) == '/') {
            i = spec.indexOf(47, start += 2);
            if (i < 0 && (i = spec.indexOf(63, start)) < 0) {
                i = limit;
            }
            host = authority = spec.substring(start, i);
            ind = authority.indexOf(64);
            if (ind != -1) {
                userInfo = authority.substring(0, ind);
                host = authority.substring(ind + 1);
            } else {
                userInfo = null;
            }
            if (host != null) {
                if (host.length() > 0 && host.charAt(0) == '[') {
                    ind = host.indexOf(93);
                    if (ind <= 2) throw new IllegalArgumentException("Invalid authority field: " + authority);
                    String nhost = host;
                    if (!IPAddressFormat.isIPv6LiteralAddress((host = nhost.substring(0, ind + 1)).substring(1, ind))) {
                        throw new IllegalArgumentException("Invalid host: " + host);
                    }
                    port = -1;
                    if (nhost.length() > ind + 1) {
                        if (nhost.charAt(ind + 1) != ':') throw new IllegalArgumentException("Invalid authority field: " + authority);
                        if (nhost.length() > ++ind + 1) {
                            port = Integer.parseInt(nhost.substring(ind + 1));
                        }
                    }
                } else {
                    ind = host.indexOf(58);
                    port = -1;
                    if (ind >= 0) {
                        if (host.length() > ind + 1) {
                            port = Integer.parseInt(host.substring(ind + 1));
                        }
                        host = host.substring(0, ind);
                    }
                }
            } else {
                host = "";
            }
            if (port < -1) {
                throw new IllegalArgumentException("Invalid port number :" + port);
            }
            start = i;
            if (authority != null && authority.length() > 0) {
                path = "";
            }
        }
        if (host == null) {
            host = "";
        }
        if (start < limit) {
            if (spec.charAt(start) == '/') {
                path = spec.substring(start, limit);
            } else if (path != null && path.length() > 0) {
                isRelPath = true;
                ind = path.lastIndexOf(47);
                String seperator = "";
                if (ind == -1 && authority != null) {
                    seperator = "/";
                }
                path = path.substring(0, ind + 1) + seperator + spec.substring(start, limit);
            } else {
                String seperator = authority != null ? "/" : "";
                path = seperator + spec.substring(start, limit);
            }
        } else if (queryOnly && path != null) {
            ind = path.lastIndexOf(47);
            if (ind < 0) {
                ind = 0;
            }
            path = path.substring(0, ind) + "/";
        }
        if (path == null) {
            path = "";
        }
        if (isRelPath) {
            while ((i = path.indexOf("/./")) >= 0) {
                path = path.substring(0, i) + path.substring(i + 2);
            }
            i = 0;
            while ((i = path.indexOf("/../", i)) >= 0) {
                if (i > 0 && (limit = path.lastIndexOf(47, i - 1)) >= 0 && path.indexOf("/../", limit) != 0) {
                    path = path.substring(0, limit) + path.substring(i + 3);
                    i = 0;
                    continue;
                }
                i += 3;
            }
            while (path.endsWith("/..") && (limit = path.lastIndexOf(47, (i = path.indexOf("/..")) - 1)) >= 0) {
                path = path.substring(0, limit + 1);
            }
            if (path.startsWith("./") && path.length() > 2) {
                path = path.substring(2);
            }
            if (path.endsWith("/.")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        u.setProtocol(protocol);
        u.setHost(host);
        u.setPort(port);
        u.setAuthority(authority);
        u.setUserInfo(userInfo);
        u.setPath(path);
        u.setQuery(query);
        u.setRef(ref);
    }

    public static class URL {
        private String protocol;
        private String authority;
        private String userInfo;
        private String host;
        private int port;
        private String path;
        private String query;
        private String ref;

        URL() {
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getAuthority() {
            return this.authority;
        }

        public void setAuthority(String authority) {
            this.authority = authority;
        }

        public String getUserInfo() {
            return this.userInfo;
        }

        public void setUserInfo(String userInfo) {
            this.userInfo = userInfo;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public String getRef() {
            return this.ref;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public String toString() {
            return URLFormat.format(this).toString();
        }
    }
}

