/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.oneport;

import java.io.IOException;
import java.io.InputStream;

public abstract class OnePortInputStream
extends InputStream {
    protected static int DEFAULT_BUFFER_SIZE = 32;
    private byte[] buf;
    private int count;
    private int pos;
    protected boolean stopped = false;

    public OnePortInputStream(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
    }

    public OnePortInputStream() {
        this(DEFAULT_BUFFER_SIZE);
    }

    private byte[] getBufIfOpen() throws IOException {
        byte[] buffer = this.buf;
        if (buffer == null) {
            throw new IOException("Stream closed");
        }
        return buffer;
    }

    private void fill(int len) throws IOException {
        int n;
        if (this.stopped) {
            return;
        }
        byte[] buffer = this.getBufIfOpen();
        if (this.pos >= buffer.length) {
            int nsz = this.pos * 2;
            byte[] nbuf = new byte[nsz];
            System.arraycopy(buffer, 0, nbuf, 0, this.pos);
            buffer = nbuf;
        }
        if ((n = this.fill0(buffer, this.pos, len)) > 0) {
            this.count = n + this.pos;
        }
    }

    protected abstract int fill0(byte[] var1, int var2, int var3) throws IOException;

    private int read0(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.count) {
            this.fill(len);
            if (this.pos >= this.count) {
                return -1;
            }
        }
        int avail = this.count - this.pos;
        int cnt = Math.min(avail, len);
        System.arraycopy(this.getBufIfOpen(), this.pos, b, off, cnt);
        this.pos += cnt;
        return cnt;
    }

    public synchronized int read() throws IOException {
        if (this.pos >= this.count) {
            this.fill(1);
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.getBufIfOpen()[this.pos++] & 0xFF;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.getBufIfOpen();
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        do {
            int nread;
            if ((nread = this.read0(b, off + n, len - n)) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while (this.available() > 0);
        return n;
    }

    public synchronized long skip(long n) throws IOException {
        this.getBufIfOpen();
        if (n <= 0L) {
            return 0L;
        }
        long avail = this.count - this.pos;
        if (avail <= 0L) {
            this.fill((int)n);
            avail = this.count - this.pos;
            if (avail <= 0L) {
                return 0L;
            }
        } else if (avail < n) {
            this.fill((int)(n - avail));
            avail = this.count - this.pos;
        }
        long skipped = Math.min(avail, n);
        this.pos = (int)((long)this.pos + skipped);
        return skipped;
    }

    public synchronized int available() throws IOException {
        this.getBufIfOpen();
        return (this.stopped ? 0 : this.available0()) + (this.count - this.pos);
    }

    protected abstract int available0() throws IOException;

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void close() throws IOException {
        if (!this.stopped) {
            this.buf = null;
            this.close0();
        }
    }

    protected abstract void close0() throws IOException;

    public synchronized void rewind() {
        this.pos = 0;
    }

    public synchronized void stop() {
        this.stopped = true;
        this.pos = 0;
    }
}

