/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.oneport;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import jeus.io.Acceptor;
import jeus.io.Selector;
import jeus.io.SocketListener;
import jeus.io.helper.IOComponentCreator;
import jeus.util.PooledExecutorFactory;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.net.VirtualListener;
import jeus.util.net.VirtualServer;
import jeus.util.oneport.OnePortInputStream;
import jeus.util.oneport.OnePortStreamHandler;
import jeus.util.oneport.ProtocolRecognizer;
import jeus.util.oneport.UnrecognizedVirtualPortException;
import jeus.util.properties.JeusNetProperties;

public class OnePortServer
implements SocketListener,
ProtocolRecognizer,
VirtualServer {
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.util.oneport");
    public static final int DEFAULT_MIN_POOL_SIZE = 5;
    public static final int DEFAULT_MAX_POOL_SIZE = 20;
    public static final long DEFAULT_KEEP_ALIVE_TIME = 3600000L;
    public static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final IOComponentCreator ioFactory = JeusNetProperties.isUpperJDK4() ? new IOComponentCreator(3, "OnePortServer", true) : IOComponentCreator.createBlockingCreator("OnePortServer", 2, true);
    private Acceptor acceptor;
    private Selector selector;
    private final Set reconizerSet;
    private volatile ProtocolRecognizer[] recognizerArray = new ProtocolRecognizer[0];
    private Executor executor;
    private final InetSocketAddress address;
    private final int backlog;
    private final int readTimeout;
    private final int maxPoolSize;
    private final int minPoolSize;
    private final long keepAliveTime;
    private volatile boolean closed;
    private Map vlistenerMap;
    private static OnePortServer instance;

    public static synchronized OnePortServer export(InetSocketAddress address, int backlog, int minPoolSize, int maxPoolSize, long keepAliveTime, int readTimeout) throws IOException {
        instance = new OnePortServer(address, backlog, minPoolSize, maxPoolSize, keepAliveTime, readTimeout);
        logger.log(JeusMessage_Network._7_LEVEL, JeusMessage_Network._7, (Object)address);
        return instance;
    }

    public static synchronized void unexport() {
        if (instance == null) {
            return;
        }
        instance.close();
        logger.log(JeusMessage_Network._8_LEVEL, JeusMessage_Network._8);
        instance = null;
    }

    public static synchronized OnePortServer getInstance() {
        return OnePortServer.getInstance(true);
    }

    public static synchronized OnePortServer getInstance(boolean check) {
        if (check && instance == null) {
            throw new IllegalStateException("OnePortServer is not started yet.");
        }
        return instance;
    }

    private OnePortServer(InetSocketAddress address, int backlog, int minPoolSize, int maxPoolSize, long keepAliveTime, int readTimeout) throws IOException {
        this.reconizerSet = new TreeSet();
        this.address = address;
        this.backlog = backlog;
        this.minPoolSize = minPoolSize <= 0 ? 5 : minPoolSize;
        this.maxPoolSize = maxPoolSize <= 0 || maxPoolSize < this.minPoolSize ? Math.max(20, this.minPoolSize) : maxPoolSize;
        this.keepAliveTime = keepAliveTime <= 0L ? 3600000L : keepAliveTime;
        this.readTimeout = readTimeout <= 0 ? 30000 : readTimeout;
        this.executor = PooledExecutorFactory.createThreadPoolExecutor("OnePortServer", this.minPoolSize, this.maxPoolSize, this.keepAliveTime);
        this.acceptor = ioFactory.createAcceptor(address.getPort(), this, null, this.backlog, this.address.getAddress(), "true");
        this.selector = ioFactory.createSelector("OnePortServer-Selector", 1, false);
        this.vlistenerMap = new HashMap();
        this.register(this);
        Thread thread = new Thread((Runnable)this.acceptor, "OnePortServer-Acceptor");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close() {
        if (this.closed) {
            return;
        }
        this.acceptor.stop();
        this.selector.destroySelector();
        this.unregister(this);
        Map map = this.vlistenerMap;
        synchronized (map) {
            this.vlistenerMap.clear();
        }
        this.closed = true;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(ProtocolRecognizer recognizer) {
        Set set = this.reconizerSet;
        synchronized (set) {
            boolean result = this.reconizerSet.add(recognizer);
            if (result) {
                this.recognizerArray = this.reconizerSet.toArray(new ProtocolRecognizer[0]);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ProtocolRecognizer recognizer) {
        Set set = this.reconizerSet;
        synchronized (set) {
            boolean result = this.reconizerSet.remove(recognizer);
            if (result) {
                this.recognizerArray = this.reconizerSet.toArray(new ProtocolRecognizer[0]);
            }
        }
    }

    public String getProtocol() {
        return "VIRTUAL";
    }

    public boolean accept(OnePortInputStream inputStream) throws IOException {
        return this.checkMagic(new DataInputStream(inputStream));
    }

    private boolean checkMagic(DataInput dataInput) throws IOException {
        for (int i = 0; i < MAGIC.length; ++i) {
            if (MAGIC[i] == dataInput.readByte()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recognized(Socket socket) throws IOException {
        VirtualListener listener;
        DataInputStream dataInput = new DataInputStream(socket.getInputStream());
        DataOutputStream dataOutput = new DataOutputStream(socket.getOutputStream());
        this.checkMagic(dataInput);
        byte opcode = dataInput.readByte();
        if (opcode != 100) {
            throw new IOException("Unrecognized operation code.[" + opcode + "]");
        }
        int bodyLength = dataInput.readInt();
        byte[] body = new byte[bodyLength];
        dataInput.readFully(body);
        String port = new String(body);
        Map map = this.vlistenerMap;
        synchronized (map) {
            listener = (VirtualListener)this.vlistenerMap.get(port);
        }
        if (listener == null) {
            if (logger.isLoggable(JeusMessage_Network._1009_LEVEL)) {
                logger.log(JeusMessage_Network._1009_LEVEL, JeusMessage_Network._1009, new Object[]{"OnePortServer", port});
            }
            dataOutput.writeByte(2);
            throw new UnrecognizedVirtualPortException(port);
        }
        if (logger.isLoggable(JeusMessage_Network._1010_LEVEL)) {
            logger.log(JeusMessage_Network._1010_LEVEL, JeusMessage_Network._1010, new Object[]{"OnePortServer", socket, port});
        }
        dataOutput.writeByte(1);
        listener.onSocket(socket);
    }

    public int compareTo(Object o) {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(VirtualListener listener) {
        Map map = this.vlistenerMap;
        synchronized (map) {
            if (listener == null || listener.getId() == null) {
                throw new NullPointerException("listener or listener's id is null");
            }
            if (this.vlistenerMap.put(listener.getId(), listener) != null) {
                if (logger.isLoggable(JeusMessage_Network._1020_LEVEL)) {
                    logger.log(JeusMessage_Network._1020_LEVEL, JeusMessage_Network._1020, new Object[]{"OnePortServer", listener.getId()});
                }
            } else if (logger.isLoggable(JeusMessage_Network._1021_LEVEL)) {
                logger.log(JeusMessage_Network._1021_LEVEL, JeusMessage_Network._1021, new Object[]{"OnePortServer", listener.getId()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(VirtualListener listener) {
        Map map = this.vlistenerMap;
        synchronized (map) {
            if (listener == null || listener.getId() == null) {
                throw new NullPointerException("listener or listener's id is null");
            }
            if (this.vlistenerMap.remove(listener.getId()) != null) {
                if (logger.isLoggable(JeusMessage_Network._1023_LEVEL)) {
                    logger.log(JeusMessage_Network._1023_LEVEL, JeusMessage_Network._1023, new Object[]{"OnePortServer", listener.getId()});
                }
            } else if (logger.isLoggable(JeusMessage_Network._1024_LEVEL)) {
                logger.log(JeusMessage_Network._1024_LEVEL, JeusMessage_Network._1024, new Object[]{"OnePortServer", listener.getId()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSocket(Socket socket) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "New socket[" + socket.getInetAddress() + "] is accepted by acceptor.");
        }
        socket.setSoTimeout(this.readTimeout);
        Set set = this.reconizerSet;
        synchronized (set) {
            OnePortStreamHandler handler = new OnePortStreamHandler(this.executor, socket, this.recognizerArray);
            this.selector.addSelectItem(handler);
        }
    }
}

