/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.oneport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jeus.util.oneport.OnePortServer;
import jeus.util.oneport.ProtocolRecognizer;

public abstract class OnePortServerSocket
extends ServerSocket
implements ProtocolRecognizer {
    private static final Socket END_OF_SOCKET = new Socket();
    private InetSocketAddress address;
    private volatile boolean closed = false;
    private volatile boolean bound = false;
    private final BlockingQueue socketQueue;
    private final Object closeLock = new Object();

    public OnePortServerSocket() throws IOException {
        this.socketQueue = new LinkedBlockingQueue();
    }

    public int compareTo(Object o) {
        String protocol = ((ProtocolRecognizer)o).getProtocol();
        if (protocol.equals("VIRTUAL")) {
            return 1;
        }
        return this.getProtocol().compareTo(((ProtocolRecognizer)o).getProtocol());
    }

    public void recognized(Socket socket) throws IOException {
        if (this.isClosed()) {
            throw new IOException("closed");
        }
        this.socketQueue.offer(socket);
    }

    public Socket accept() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isBound()) {
            throw new SocketException("Socket is not bound yet");
        }
        try {
            Socket socket = (Socket)this.socketQueue.take();
            if (socket == END_OF_SOCKET) {
                this.closeSocket(END_OF_SOCKET);
                throw new SocketException("Socket is closed");
            }
            return socket;
        }
        catch (InterruptedException e) {
            throw new SocketException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        OnePortServer.getInstance().unregister(this);
        this.socketQueue.offer(END_OF_SOCKET);
        object = this.socketQueue;
        synchronized (object) {
            for (Socket socket : this.socketQueue) {
                this.closeSocket(socket);
            }
        }
    }

    private void closeSocket(Socket socket) {
        try {
            socket.shutdownInput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            socket.shutdownOutput();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.bind(endpoint, 0);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        if (!OnePortServer.getInstance().register(this)) {
            throw new SocketException(this.getProtocol() + " protocol is already registered in OnePortServer.");
        }
        this.address = (InetSocketAddress)endpoint;
        this.bound = true;
    }

    public InetAddress getInetAddress() {
        return this.address.getAddress();
    }

    public int getLocalPort() {
        return this.address.getPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.address;
    }

    public boolean isBound() {
        return this.bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public String toString() {
        return "OnePort" + this.getProtocol() + "ServerSocket[" + this.address.getHostName() + ":" + this.address.getPort() + "]";
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
    }

    public synchronized int getSoTimeout() throws IOException {
        return 0;
    }

    public void setReuseAddress(boolean on) throws SocketException {
    }

    public boolean getReuseAddress() throws SocketException {
        return false;
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return 0;
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }
}

